/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;

public class DimensionTuningManager {
    private static final String NBT_TAG = "dimensionTuning";
    public static final DimensionTuningManager instance = new DimensionTuningManager();

    private DimensionTuningManager() {
    }

    public void tunePlayer(EntityPlayer ep, int amt) {
        ep.getEntityData().func_74768_a(NBT_TAG, amt);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    public int getPlayerTuning(EntityPlayer ep) {
        return ep.getEntityData().func_74762_e(NBT_TAG);
    }

    public float getTunedDropRates(EntityPlayer ep) {
        int tune = this.getPlayerTuning(ep);
        if (tune <= 0) {
            return -1.0f;
        }
        if (tune <= 16) {
            return 0.0f;
        }
        if (tune <= 64) {
            return (float)(tune - 16) / 48.0f;
        }
        if (tune <= 576) {
            return 1.0f + (float)(tune - 64) / 256.0f;
        }
        return -21.0f + 24.0f * (float)Math.pow((float)tune / 576.0f, 0.04);
    }

    public int getTunedDropCount(EntityPlayer ep, int base, int min, int max) {
        if (ep.field_70170_p.field_73011_w.field_76574_g != ExtraChromaIDs.DIMID.getValue()) {
            return base;
        }
        int drops = (int)((float)base * this.getTunedDropRates(ep));
        return MathHelper.func_76125_a((int)drops, (int)min, (int)max);
    }

    public static enum TuningThresholds {
        STRUCTURES(192),
        STRUCTUREBIOMES(96),
        SKYRIVER(384, 256),
        FARREGIONS(512),
        DECOHARVEST(4),
        CHESTS(16),
        MONUMENT(224);

        public final int minimumTuning;
        public final int minimumEffect;
        public static final TuningThresholds[] list;

        private TuningThresholds(int t) {
            this(t, 0);
        }

        private TuningThresholds(int t, int e) {
            this.minimumTuning = t;
            this.minimumEffect = e;
        }

        public float getTuningFraction(EntityPlayer ep) {
            int amt = instance.getPlayerTuning(ep);
            if (amt < this.minimumEffect) {
                return 0.0f;
            }
            if (amt >= this.minimumTuning) {
                return 1.0f;
            }
            return (float)(amt - this.minimumEffect) / (float)(this.minimumTuning - this.minimumEffect);
        }

        public boolean isSufficientlyTuned(EntityPlayer ep) {
            if (ep.field_70170_p.field_73011_w.field_76574_g != ExtraChromaIDs.DIMID.getValue()) {
                return true;
            }
            return instance.getPlayerTuning(ep) >= this.minimumTuning;
        }

        static {
            list = TuningThresholds.values();
        }
    }
}

