/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ThreadedGenerator;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Generators.WorldGenFissure;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FissurePatternCalculator
extends ThreadedGenerator {
    private static final int PATTERN_COUNT = 500;
    private static final ArrayList<FissurePattern> patterns = new ArrayList();

    public FissurePatternCalculator(long seed) {
        super(seed);
    }

    @Override
    public void run() throws Throwable {
        patterns.clear();
        for (int i = 0; i < 500; ++i) {
            FissurePattern fp = new FissurePattern();
            fp.calculate(this.rand);
            patterns.add(fp);
        }
    }

    public static FissurePattern getRandomFissure(World world, int x, int y, int z) {
        return patterns.get(world.field_73012_v.nextInt(500));
    }

    public static void generateRandomFissure(World world, int x, int y, int z) {
        FissurePatternCalculator.getRandomFissure(world, x, y, z).generate(world, x, y, z);
    }

    @Override
    public String getStateMessage() {
        return patterns.size() + " fissure layouts calculated.";
    }

    public static class FissurePattern {
        private final HashMap<Coordinate, BlockKey> blockData = new HashMap();
        private final HashMap<Point, Integer> shape = new HashMap();

        private FissurePattern() {
        }

        private void calculate(Random rand) {
            int my = 8 + rand.nextInt(16);
            double w = rand.nextDouble();
            ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
            for (int i = 2; i < 6; ++i) {
                if (rand.nextInt(3) <= 0) continue;
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                dirs.add(dir);
            }
            int color = rand.nextInt(16);
            HashMap<Coordinate, Integer> columns = new HashMap<Coordinate, Integer>();
            for (ForgeDirection dir : dirs) {
                int l = 12;
                ArrayList<ForgeDirection> li = new ArrayList<ForgeDirection>();
                li.add(dir);
                this.cut(rand, 0, 0, 0, w, my, 0, l, li, columns, color);
            }
            for (Coordinate c : columns.keySet()) {
                int h = (Integer)columns.get(c);
                if (this.getBlock(c.xCoord, c.yCoord + h - 1, c.zCoord) != ChromaBlocks.STRUCTSHIELD.getBlockInstance()) continue;
                this.setBlock(c.xCoord, c.yCoord + h, c.zCoord, ChromaBlocks.VOIDRIFT.getBlockInstance(), color);
            }
            for (Coordinate c : this.blockData.keySet()) {
                this.shape.put(new Point(c.xCoord, c.zCoord), 0);
            }
        }

        public Map<Point, Integer> getDepthMap() {
            return Collections.unmodifiableMap(this.shape);
        }

        public void generate(World world, int x, int y, int z) {
            for (Coordinate c : this.blockData.keySet()) {
                Coordinate c2 = c.offset(x, y, z);
                Block b = c2.getBlock((IBlockAccess)world);
                if (b.isAir((IBlockAccess)world, c2.xCoord, c2.yCoord, c2.zCoord) || b == ChromaBlocks.DIMGEN.getBlockInstance() || ReikaBlockHelper.isLiquid((Block)b) || !WorldGenFissure.canCutInto(world, c2.xCoord, c2.yCoord, c2.zCoord)) continue;
                BlockKey bk = this.blockData.get(c);
                if (b.func_149688_o() != Material.field_151576_e && bk.blockID == ChromaBlocks.STRUCTSHIELD.getBlockInstance()) continue;
                c2.setBlock(world, bk.blockID, bk.metadata, 2);
            }
        }

        private void cut(Random rand, int x, int y, int z, double w, int my, int dist, int len, ArrayList<ForgeDirection> follow, HashMap<Coordinate, Integer> columns, int color) {
            for (int dy = my; dy <= y + 12; ++dy) {
                int r = (int)(w * Math.sqrt(1.0 + (double)(dy - my) / 4.0));
                for (int i = -r; i <= r; ++i) {
                    for (int k = -r; k <= r; ++k) {
                        int dx = x + i;
                        int dz = z + k;
                        this.setBlock(dx, dy, dz, Blocks.field_150350_a, 0);
                        for (int d = 0; d < 6; ++d) {
                            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[d];
                            int dx2 = dx + dir.offsetX;
                            int dy2 = dy + dir.offsetY;
                            int dz2 = dz + dir.offsetZ;
                            this.setBlock(dx2, dy2, dz2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.ordinal());
                            Coordinate c = new Coordinate(dx2, 0, dz2);
                            Integer get = columns.get(c);
                            int h = get != null ? get : 0;
                            columns.put(c, Math.max(dy2 + 1, h));
                        }
                        int gy = my - 6;
                        for (int d = 0; d < 6; ++d) {
                            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[d];
                            int dx2 = dx + dir.offsetX;
                            int dy2 = gy + dir.offsetY;
                            int dz2 = dz + dir.offsetZ;
                            if (dir == ForgeDirection.UP) {
                                for (int h = 1; h < my; ++h) {
                                    dy2 = gy + dir.offsetY * h;
                                    this.setBlock(dx2, dy2, dz2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.ordinal());
                                }
                                continue;
                            }
                            this.setBlock(dx2, dy2, dz2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
                        }
                        this.setBlock(dx, gy, dz, ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.LIFEWATER.ordinal());
                    }
                }
            }
            if (dist > 1 && rand.nextInt(2) == 0) {
                ForgeDirection dir = ReikaDirectionHelper.getLeftBy90((ForgeDirection)follow.get(follow.size() - 1));
                if (rand.nextBoolean()) {
                    dir = dir.getOpposite();
                }
                follow.add(dir);
                this.cut(rand, x + dir.offsetX, y, z + dir.offsetZ, w, my, 0, len - 1, follow, columns, color);
                follow.remove(follow.size() - 1);
            }
            if (len > 0 && rand.nextInt(6 + len) > 0) {
                ForgeDirection dir = follow.get(rand.nextInt(follow.size()));
                this.cut(rand, x + dir.offsetX, y, z + dir.offsetZ, w, my, dist + 1, len - 1, follow, columns, color);
            }
        }

        private Block getBlock(int x, int y, int z) {
            BlockKey get = this.blockData.get(new Coordinate(x, y, z));
            return get != null ? get.blockID : null;
        }

        private void setBlock(int x, int y, int z, Block b, int meta) {
            this.blockData.put(new Coordinate(x, y, z), new BlockKey(b, meta));
        }
    }
}

