/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class WorldGenCrystalPit
extends ChromaWorldGenerator {
    private static final CrystalElement[][] colors = new CrystalElement[4][4];

    public WorldGenCrystalPit(DimensionGenerators g, Random rand, long seed) {
        super(g, rand, seed);
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return biome == ChromaDimensionManager.Biomes.CENTER.getBiome() ? 0.00625f : 0.01875f;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int r1 = 8;
        int r2 = 4;
        int primary = rand.nextInt(4);
        if (this.canGenAt(world, x, y, z, r1, r2)) {
            for (int i = -r1; i <= r1; ++i) {
                for (int k = -r1; k <= r1; ++k) {
                    for (int j = r2; j >= -r2; --j) {
                        if (!ReikaMathLibrary.isPointInsideEllipse((double)i, (double)j, (double)k, (double)r1, (double)r2, (double)r1)) continue;
                        int dx = x + i;
                        int dz = z + k;
                        int dy = y + j;
                        if (j >= 0 || ReikaMathLibrary.isPointInsideEllipse((double)i, (double)j, (double)k, (double)(r1 - 1), (double)(r2 - 1), (double)(r1 - 1))) {
                            world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                            continue;
                        }
                        world.func_147465_d(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                        if (j > -2 || rand.nextInt(3) != 0) continue;
                        world.func_147465_d(dx, dy + 1, dz, ChromaBlocks.CRYSTAL.getBlockInstance(), colors[primary][rand.nextInt(4)].ordinal(), 3);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean canGenAt(World world, int x, int y, int z, int r1, int r2) {
        for (int i = -r1; i <= r1; ++i) {
            for (int k = -r1; k <= r1; ++k) {
                for (int j = r2; j >= -r2; --j) {
                    if (!ReikaMathLibrary.isPointInsideEllipse((double)i, (double)j, (double)k, (double)r1, (double)r2, (double)r1)) continue;
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    Block b = world.func_147439_a(dx, dy, dz);
                    if (b instanceof BlockFluidBase || b instanceof BlockLiquid) {
                        return false;
                    }
                    if (j >= 0 || ReikaMathLibrary.isPointInsideEllipse((double)i, (double)j, (double)k, (double)(r1 - 1), (double)(r2 - 1), (double)(r1 - 1))) continue;
                    Block bd = world.func_147439_a(dx, dy - 1, dz);
                    if (bd.isAir((IBlockAccess)world, dx, dy - 1, dz)) {
                        return false;
                    }
                    if (bd.func_149688_o() == Material.field_151576_e || bd.func_149688_o() == Material.field_151577_b || bd.func_149688_o() == Material.field_151573_f || bd.func_149688_o() == Material.field_151578_c) continue;
                    return false;
                }
            }
        }
        return true;
    }

    static {
        WorldGenCrystalPit.colors[0] = new CrystalElement[]{CrystalElement.BLUE, CrystalElement.RED, CrystalElement.PURPLE, CrystalElement.MAGENTA};
        WorldGenCrystalPit.colors[1] = new CrystalElement[]{CrystalElement.GREEN, CrystalElement.YELLOW, CrystalElement.CYAN, CrystalElement.LIME};
        WorldGenCrystalPit.colors[2] = new CrystalElement[]{CrystalElement.BROWN, CrystalElement.PINK, CrystalElement.ORANGE, CrystalElement.LIGHTBLUE};
        WorldGenCrystalPit.colors[3] = new CrystalElement[]{CrystalElement.BLACK, CrystalElement.GRAY, CrystalElement.LIGHTGRAY, CrystalElement.WHITE};
    }
}

