/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Block.Decoration.BlockEtherealLight;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredPlant;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Instantiable.Math.Noise.NoiseGeneratorBase;
import Reika.DragonAPI.Instantiable.Math.Noise.SimplexNoiseGenerator;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenGlowCave
extends ChromaWorldGenerator {
    private static final double MIN_RADIUS = 3.0;
    private static final double MAX_RADIUS = 4.5;
    private static final double MAX_RADIUS_CHANGE_PER_SEGMENT = 0.5;
    private static final double MAX_CRACK_CHANCE = 0.066;
    private static final int MAX_CRACK_Y = 20;
    public static final int FULL_BEDROCK_Y = 8;
    public static final int MAX_BEDROCK_Y = 32;
    private final NoiseGeneratorBase wallSelectionNoise;

    public WorldGenGlowCave(DimensionGenerators g, Random rand, long seed) {
        super(g, rand, seed);
        this.wallSelectionNoise = new SimplexNoiseGenerator(seed).setFrequency(0.3333333333333333).addOctave(2.0, 0.5);
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return biome == ChromaDimensionManager.Biomes.CENTER.getBiome() ? 0.0025f : 0.00125f;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int oy = ReikaWorldHelper.findTopBlockBelowY((World)world, (int)x, (int)255, (int)z);
        Block bk = world.func_147439_a(x, oy, z);
        if (bk == Blocks.field_150349_c || bk == Blocks.field_150354_m) {
            HashSet<Coordinate> set1 = new HashSet<Coordinate>();
            HashSet<Coordinate> set2 = new HashSet<Coordinate>();
            double x0 = (double)x + 0.5;
            double y0 = (double)oy + 0.5 + 1.0;
            double z0 = (double)z + 0.5;
            this.growFrom(world, rand, x0, y0, z0, 4.5, set1, set2, 0, 0.0);
            for (Coordinate c : set1) {
                if (c.getBlock((IBlockAccess)world).func_149688_o() != Material.field_151586_h && ReikaWorldHelper.checkForAdjMaterial((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (Material)Material.field_151586_h) == null && ReikaWorldHelper.checkForAdjBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance()) == null) continue;
                return false;
            }
            if (ReikaObfuscationHelper.isDeObfEnvironment()) {
                ReikaJavaLibrary.pConsole((Object)(set1.size() + " @ " + x + ", " + z));
            }
            this.generate(world, rand, set1, oy);
            int r = 16;
            int spokes = ReikaRandomHelper.getRandomBetween((int)2, (int)6);
            double da = 360.0 / (double)spokes;
            double a0 = rand.nextDouble() * 360.0;
            double va = ReikaRandomHelper.getRandomBetween((double)2.5, (double)15.0);
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    int dx = x + i;
                    int dz = z + k;
                    double d = ReikaMathLibrary.py3d((double)i, (double)0.0, (double)k);
                    if (!(d <= (double)r)) continue;
                    double f = Math.sqrt(1.0 - d / (double)r);
                    if (!(rand.nextDouble() < f)) continue;
                    int dy = ReikaWorldHelper.findTopBlockBelowY((World)world, (int)dx, (int)(oy + 20), (int)dz);
                    Block b = world.func_147439_a(dx, dy, dz);
                    while (b instanceof BlockLeavesBase || b == Blocks.field_150350_a) {
                        b = world.func_147439_a(dx, --dy, dz);
                    }
                    if (b != Blocks.field_150349_c && b != Blocks.field_150354_m) continue;
                    world.func_147465_d(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), rand.nextBoolean() ? BlockStructureShield.BlockType.MOSS.metadata : BlockStructureShield.BlockType.STONE.metadata, 3);
                }
            }
            return true;
        }
        return false;
    }

    private void growFrom(World world, Random rand, double x0, double y0, double z0, double maxr, HashSet<Coordinate> parent, HashSet<Coordinate> path, int forkDepth, double minY) {
        DecimalPosition pos2;
        DecimalPosition pos1;
        int l;
        minY = Math.max(0.0, Math.min(minY, y0 - 1.0));
        ArrayList<CavePoint> li0 = new ArrayList<CavePoint>();
        double r0 = ReikaRandomHelper.getRandomBetween((double)3.0, (double)maxr);
        li0.add(new CavePoint(x0, y0, z0, r0));
        boolean first = true;
        while (y0 > minY) {
            double x2 = ReikaRandomHelper.getRandomPlusMinus((double)x0, (double)(first ? 6.0 : 32.0));
            double z2 = ReikaRandomHelper.getRandomPlusMinus((double)z0, (double)(first ? 6.0 : 32.0));
            double y2 = first ? y0 - 8.0 - (double)rand.nextInt(5) : y0 - (double)rand.nextInt(16);
            y2 = Math.max(y2, minY);
            x0 = x2;
            y0 = y2;
            z0 = z2;
            li0.add(new CavePoint(x0, y0, z0, r0));
            first = false;
        }
        Spline s = new Spline(Spline.SplineType.CHORDAL);
        for (int i = 0; i < li0.size(); ++i) {
            CavePoint pos = (CavePoint)((Object)li0.get(i));
            s.addPoint((Spline.SplineAnchor)pos);
            if (i == 0 || i == li0.size() - 1) continue;
            s.addPoint((Spline.SplineAnchor)pos.offset(0, -1 - rand.nextInt(6), 0));
        }
        List li = s.get(12, false);
        Interpolation rVar = new Interpolation(false);
        for (int d = 0; d < li.size(); d += 1 + rand.nextInt(Math.max(4, l / 6))) {
            rVar.addPoint((double)d, ReikaRandomHelper.getRandomBetween((double)3.0, (double)maxr));
            l = li.size() - d;
        }
        rVar.addPoint((double)(li.size() - 1), ReikaRandomHelper.getRandomBetween((double)3.0, (double)maxr));
        for (int i = 0; !(i >= li.size() - 1 || this.getLine(world, rand, pos1 = (DecimalPosition)li.get(i), pos2 = (DecimalPosition)li.get(i + 1), rVar.getValue((double)i), rVar.getValue((double)(i + 1)), i, parent, path) && forkDepth > 0 && i > 10); ++i) {
            if (forkDepth > 3 || rand.nextInt(Math.max(24, (int)pos1.yCoord)) != 0) continue;
            this.fork(world, rand, pos1, pos2, rVar, i, path, forkDepth);
        }
        parent.addAll(path);
    }

    private void fork(World world, Random rand, DecimalPosition p1, DecimalPosition p2, Interpolation rVar, int idx, HashSet<Coordinate> set, int depth) {
        double f = rand.nextDouble();
        HashSet<Coordinate> ret = new HashSet<Coordinate>();
        this.growFrom(world, rand, p1.xCoord + (p2.xCoord - p1.xCoord) * f, p1.yCoord + (p2.yCoord - p1.yCoord) * f, p1.zCoord + (p2.zCoord - p1.zCoord) * f, rVar.getValue((double)idx + f), set, ret, depth + 1, rand.nextInt(3) == 0 ? 0.0 : (double)ReikaRandomHelper.getRandomBetween((int)6, (int)20));
        set.addAll(ret);
    }

    private void generate(World world, Random rand, HashSet<Coordinate> set, int upper) {
        HashSet<Coordinate> falls = new HashSet<Coordinate>();
        HashSet<Coordinate> air = new HashSet<Coordinate>();
        for (Coordinate c : set) {
            if (c.yCoord < 0) continue;
            boolean top = c.yCoord == upper;
            boolean edge = c.yCoord <= upper && !set.containsAll(c.getAdjacentCoordinates());
            Block b = Blocks.field_150350_a;
            int meta = 0;
            if (!top) {
                if (edge) {
                    if (this.isBedrockWall(world, rand, c)) {
                        b = Blocks.field_150357_h;
                    } else if (rand.nextInt(20) == 0) {
                        b = ChromaBlocks.DIMGEN.getBlockInstance();
                        meta = BlockDimensionDeco.DimDecoTypes.GLOWCAVE.ordinal();
                    } else {
                        b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                        int n = meta = ReikaRandomHelper.doWithChance((double)20.0) ? BlockStructureShield.BlockType.MOSS.metadata : BlockStructureShield.BlockType.STONE.metadata;
                    }
                }
                if (c.yCoord == 0) {
                    b = Blocks.field_150350_a;
                }
            }
            if (b == Blocks.field_150350_a && rand.nextInt(c.yCoord >= 16 ? 160 : 10 + 10 * c.yCoord) == 0) {
                b = ChromaBlocks.LIGHT.getBlockInstance();
                int n = meta = c.yCoord > 12 ? BlockEtherealLight.Flags.PARTICLES.getFlag() : 0;
            }
            if (b == Blocks.field_150350_a && rand.nextInt(60) == 0 && c.yCoord < upper - 10 && !set.contains(c.offset(0, 2, 0))) {
                b = ChromaBlocks.TIEREDPLANT.getBlockInstance();
                meta = BlockTieredPlant.TieredPlants.CAVE.ordinal();
            }
            if (b == Blocks.field_150357_h && c.yCoord < 20) {
                double f = this.getBedrockCrackChance(c);
                if (rand.nextDouble() < f) {
                    b = ChromaBlocks.BEDROCKCRACK.getBlockInstance();
                    meta = this.getRandomCrackMeta(rand, c);
                }
            }
            if (b == Blocks.field_150357_h && c.yCoord == 2) {
                falls.add(c);
            }
            c.setBlock(world, b, meta);
            if (b != Blocks.field_150350_a) continue;
            air.add(c);
        }
        for (Coordinate c : falls) {
            if (air.contains(c.offset(0, 1, 0))) continue;
            int meta = 0;
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                Coordinate c2 = c.offset(dir, 1);
                if (!air.contains(c2) || !air.contains(c2.offset(0, -1, 0))) continue;
                meta |= 1 << i - 2;
            }
            if (meta <= 0) continue;
            c.setBlock(world, ChromaBlocks.VOIDCAVE.getBlockInstance(), meta);
        }
    }

    private int getRandomCrackMeta(Random rand, Coordinate c) {
        int max = 9;
        if (c.yCoord > 8) {
            max = (int)((double)max * (1.0 - (double)(c.yCoord - 8) / 12.0));
        }
        return rand.nextInt(1 + max);
    }

    private double getBedrockCrackChance(Coordinate c) {
        if (c.yCoord <= 8) {
            return 0.066;
        }
        double f = (double)(c.yCoord - 8) / 12.0;
        return (1.0 - f) * 0.066;
    }

    private boolean isBedrockWall(World world, Random rand, Coordinate c) {
        if (c.yCoord >= 32) {
            return false;
        }
        if (c.yCoord <= 8) {
            return true;
        }
        return (double)c.yCoord <= ReikaMathLibrary.normalizeToBounds((double)this.wallSelectionNoise.getValue((double)c.xCoord, (double)c.zCoord), (double)8.0, (double)32.0);
    }

    private boolean getLine(World world, Random rand, DecimalPosition pos1, DecimalPosition pos2, double r1, double r2, int i, HashSet<Coordinate> main, HashSet<Coordinate> line) {
        double dx = pos2.xCoord - pos1.xCoord;
        double dy = pos2.yCoord - pos1.yCoord;
        double dz = pos2.zCoord - pos1.zCoord;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        double dr = r2 - r1;
        boolean flag = false;
        for (double d = 0.25; d < dd; d += 1.0) {
            double f = d / dd;
            double x = pos1.xCoord + f * dx;
            double y = pos1.yCoord + f * dy;
            double z = pos1.zCoord + f * dz;
            double r = r1 + dr * f;
            flag |= this.getSphere(world, x, y, z, r, i, main, line);
        }
        return flag;
    }

    private boolean getSphere(World world, double x, double y, double z, double r, int i, HashSet<Coordinate> main, HashSet<Coordinate> line) {
        boolean flag = false;
        for (double dx = -r; dx <= r; dx += 0.75) {
            for (double dy = -r; dy <= r; dy += 0.75) {
                for (double dz = -r; dz <= r; dz += 0.75) {
                    if (!(dx * dx + dy * dy + dz * dz <= r * r)) continue;
                    int x0 = MathHelper.func_76128_c((double)(x + dx));
                    int y0 = MathHelper.func_76128_c((double)(y + dy));
                    int z0 = MathHelper.func_76128_c((double)(z + dz));
                    Coordinate c = new Coordinate(x0, y0, z0);
                    line.add(c);
                    flag |= main.contains(c);
                }
            }
        }
        return flag;
    }

    private static class CavePoint
    extends Spline.BasicSplinePoint {
        public final double radius;

        public CavePoint(double x, double y, double z, double r) {
            super(x, y, z);
            this.radius = r;
        }

        public CavePoint offset(int x, int y, int z) {
            return new CavePoint(this.posX + (double)x, this.posY + (double)y, this.posZ + (double)z, this.radius);
        }
    }

    private static class CaveBlock {
        private final Coordinate location;
        private final int depthIndex;

        private CaveBlock(int x, int y, int z, int i) {
            this(new Coordinate(x, y, z), i);
        }

        private CaveBlock(Coordinate c, int i) {
            this.location = c;
            this.depthIndex = i;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof CaveBlock && ((CaveBlock)o).location.equals((Object)this.location);
        }
    }
}

