/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDecoTile;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Math.DoublePolygon;
import Reika.DragonAPI.Instantiable.Math.DoubleRectangle;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.GregOreHandler;
import Reika.DragonAPI.ModRegistry.ModOreList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldGenGlowingCracks
extends ChromaWorldGenerator {
    private final WeightedRandom<OreType> oreRand = new WeightedRandom();

    public WorldGenGlowingCracks(DimensionGenerators g, Random rand, long seed) {
        super(g, rand, seed);
        this.oreRand.addEntry((Object)ReikaOreHelper.EMERALD, 10.0);
        this.oreRand.addEntry((Object)ReikaOreHelper.DIAMOND, 20.0);
        this.oreRand.addEntry((Object)ReikaOreHelper.REDSTONE, 50.0);
        this.oreRand.addEntry((Object)ReikaOreHelper.GOLD, 40.0);
        if (ModOreList.SAPPHIRE.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.SAPPHIRE, 30.0);
        }
        if (ModOreList.PLATINUM.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.PLATINUM, 20.0);
        }
        if (ModOreList.AMETHYST.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.AMETHYST, 30.0);
        }
        if (ModOreList.MANA.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.MANA, 20.0);
        }
        if (ModOreList.MOONSTONE.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.MOONSTONE, 10.0);
        }
        if (ModOreList.VINTEUM.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.VINTEUM, 30.0);
        }
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return 0.125f;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int k;
        int i;
        int r = 4;
        for (i = -r; i <= r; ++i) {
            for (k = -r; k <= r; ++k) {
                if (world.func_147439_a(x + i, y - 1, z + k) == Blocks.field_150349_c) continue;
                return false;
            }
        }
        world.func_147465_d(x, y, z, ChromaBlocks.DIMGENTILE.getBlockInstance(), BlockDimensionDecoTile.DimDecoTileTypes.GLOWCRACKS.ordinal(), 3);
        for (i = -r; i <= r; ++i) {
            for (k = -r; k <= r; ++k) {
                world.func_72921_c(x + i, y - 1, z + k, 1, 3);
                world.func_72921_c(x + i, y - 2, z + k, 1, 3);
            }
        }
        int h = 8 + rand.nextInt(9);
        Crystal cry = new Crystal(x, y - 4 - h / 2, z);
        cry.rootHeight = h;
        cry.rootSize = 2 + rand.nextInt(4);
        cry.rotX = rand.nextDouble() * 10.0 - 5.0;
        cry.rotY = rand.nextDouble() * 360.0;
        cry.rotZ = rand.nextDouble() * 10.0 - 5.0;
        cry.calculate();
        cry.randomize(rand);
        Collection li = cry.getCoordinates();
        this.oreRand.setSeed(rand.nextLong());
        OreType ore = (OreType)this.oreRand.getRandomEntry();
        ArrayList li2 = new ArrayList(ore.getAllOreBlocks());
        int idx = rand.nextInt(li2.size());
        ItemStack is = (ItemStack)li2.get(idx);
        while (!li2.isEmpty() && GregOreHandler.getInstance().isGregOre(Block.func_149634_a((Item)is.func_77973_b()))) {
            li2.remove(idx);
            idx = rand.nextInt(li2.size());
            is = (ItemStack)li2.get(idx);
        }
        if (li2.isEmpty()) {
            is = null;
        }
        BlockKey bk = is == null || rand.nextInt(2) == 0 ? new BlockKey(ChromaBlocks.TIEREDORE.getBlockInstance(), this.getRandomOre(rand)) : new BlockKey(Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j());
        for (Coordinate c : li) {
            if (c.getBlock((IBlockAccess)world) != Blocks.field_150348_b && c.getBlock((IBlockAccess)world) != ChromaBlocks.TIEREDORE.getBlockInstance()) continue;
            c.setBlock(world, bk.blockID, bk.metadata, 2);
        }
        return true;
    }

    private int getRandomOre(Random rand) {
        BlockTieredOre.TieredOres ore = BlockTieredOre.TieredOres.list[rand.nextInt(BlockTieredOre.TieredOres.list.length)];
        while (ore.genBlock != Blocks.field_150348_b) {
            ore = BlockTieredOre.TieredOres.list[rand.nextInt(BlockTieredOre.TieredOres.list.length)];
        }
        return ore.ordinal();
    }

    private static class Crystal {
        private final int centerX;
        private final int centerY;
        private final int centerZ;
        private double rootHeight = 8.0;
        private double rootSize = 3.0;
        private double rotX;
        private double rotY;
        private double rotZ;
        private DecimalPosition lowerPoint;
        private DecimalPosition upperPoint;
        private DecimalPosition[] edgePoints;

        private Crystal(int x, int y, int z) {
            this.centerX = x;
            this.centerY = y;
            this.centerZ = z;
        }

        private void calculate() {
            int i;
            Vec3 lowerPointVec = Vec3.func_72443_a((double)0.0, (double)(0.0 - this.rootHeight), (double)0.0);
            Vec3 upperPointVec = Vec3.func_72443_a((double)0.0, (double)(0.0 + this.rootHeight), (double)0.0);
            Vec3[] edgePointsVec = new Vec3[]{Vec3.func_72443_a((double)(0.0 + this.rootSize), (double)0.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)(0.0 + this.rootSize)), Vec3.func_72443_a((double)(0.0 - this.rootSize), (double)0.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)(0.0 - this.rootSize))};
            lowerPointVec = ReikaVectorHelper.rotateVector((Vec3)lowerPointVec, (double)this.rotX, (double)this.rotY, (double)this.rotZ);
            upperPointVec = ReikaVectorHelper.rotateVector((Vec3)upperPointVec, (double)this.rotX, (double)this.rotY, (double)this.rotZ);
            for (i = 0; i < 4; ++i) {
                edgePointsVec[i] = ReikaVectorHelper.rotateVector((Vec3)edgePointsVec[i], (double)this.rotX, (double)this.rotY, (double)this.rotZ);
            }
            this.edgePoints = new DecimalPosition[4];
            this.lowerPoint = new DecimalPosition(lowerPointVec).offset((double)this.centerX, (double)this.centerY, (double)this.centerZ);
            this.upperPoint = new DecimalPosition(upperPointVec).offset((double)this.centerX, (double)this.centerY, (double)this.centerZ);
            for (i = 0; i < 4; ++i) {
                this.edgePoints[i] = new DecimalPosition(edgePointsVec[i]).offset((double)this.centerX, (double)this.centerY, (double)this.centerZ);
            }
        }

        private void randomize(Random rand) {
            this.lowerPoint = this.lowerPoint.offset(rand.nextDouble() - 0.5, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5);
            this.upperPoint = this.upperPoint.offset(rand.nextDouble() - 0.5, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5);
            for (int i = 0; i < 4; ++i) {
                this.edgePoints[i] = this.edgePoints[i].offset(rand.nextDouble() - 0.5, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5);
            }
        }

        private Collection<Coordinate> getCoordinates() {
            HashSet<Coordinate> set = new HashSet<Coordinate>();
            AxisAlignedBB box = ReikaAABBHelper.fromPoints((DecimalPosition[])new DecimalPosition[]{this.upperPoint, this.lowerPoint, this.edgePoints[0], this.edgePoints[1], this.edgePoints[2], this.edgePoints[3]});
            int y0 = MathHelper.func_76128_c((double)box.field_72338_b);
            int y1 = MathHelper.func_76143_f((double)box.field_72337_e);
            for (int y = y0; y < y1; ++y) {
                double dy = (double)y + 0.5;
                DoublePolygon slice = new DoublePolygon();
                for (int i = 0; i < 4; ++i) {
                    DecimalPosition p = this.edgePoints[i];
                    double f = dy < (double)this.centerY ? ((double)this.centerY - dy) / ((double)this.centerY - this.lowerPoint.yCoord) : 1.0 - (dy - (double)this.centerY) / (this.upperPoint.yCoord - (double)this.centerY);
                    double cx = dy < (double)this.centerY ? this.lowerPoint.xCoord : this.upperPoint.xCoord;
                    double cz = dy < (double)this.centerY ? this.lowerPoint.zCoord : this.upperPoint.zCoord;
                    double x = cx + (p.xCoord - cx) * (dy < (double)this.centerY ? 1.0 - f : f);
                    double z = cz + (p.zCoord - cz) * (dy < (double)this.centerY ? 1.0 - f : f);
                    slice.addPoint(x, z);
                }
                DoubleRectangle r = slice.getBounds();
                int x0 = MathHelper.func_76128_c((double)r.x);
                int x1 = MathHelper.func_76143_f((double)(r.x + r.width));
                int z0 = MathHelper.func_76128_c((double)r.y);
                int z1 = MathHelper.func_76143_f((double)(r.y + r.height));
                for (int x = x0; x <= x1; ++x) {
                    for (int z = z0; z <= z1; ++z) {
                        double dx = (double)x + 0.5;
                        double dz = (double)z + 0.5;
                        if (!slice.contains(dx, dz) && !slice.contains(dx - 0.5, dz - 0.5) && !slice.contains(dx + 0.5, dz + 0.5)) continue;
                        set.add(new Coordinate(x, y, z));
                    }
                }
            }
            return set;
        }
    }
}

