/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ItemMagicRegistry;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class WorldGenTerrainCrystal
extends ChromaWorldGenerator {
    public WorldGenTerrainCrystal(DimensionGenerators g, Random rand, long seed) {
        super(g, rand, seed);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int h = y + 64 + rand.nextInt(64);
        if (h > 250) {
            return false;
        }
        int n = 4 + rand.nextInt(9);
        for (int i = 0; i < n; ++i) {
            int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)24);
            int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)24);
            int dy = ReikaRandomHelper.getRandomPlusMinus((int)h, (int)12);
            int s = 3 + rand.nextInt(6);
            float f = (float)ReikaRandomHelper.getRandomPlusMinus((double)1.5, (double)0.5);
            TerrainCrystal t = new TerrainCrystal(s, f);
            t.hasTreasure = rand.nextInt(18) == 0;
            t.hasCore = rand.nextInt(6) == 0;
            t.hasPool = rand.nextInt(3) == 0;
            t.hasResource = !t.hasTreasure && !t.hasCore && !t.hasPool && rand.nextInt(3) == 0;
            if (rand.nextInt(4) == 0) {
                t.heightExponent = ReikaRandomHelper.getRandomBetween((double)0.25, (double)(rand.nextBoolean() ? 1.5 : 2.0));
            }
            if (rand.nextInt(8) == 0) {
                t.stone = new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.ordinal());
                t.top = new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.MOSS.ordinal());
            }
            switch (rand.nextInt(12)) {
                case 0: {
                    t.core = new BlockKey(Blocks.field_150482_ag);
                    break;
                }
                case 1: {
                    t.core = new BlockKey(Blocks.field_150412_bA);
                    break;
                }
                case 2: 
                case 3: {
                    t.core = new BlockKey(Blocks.field_150343_Z);
                }
            }
            switch (rand.nextInt(12)) {
                case 0: 
                case 1: {
                    t.pool = new BlockKey(ChromaBlocks.CHROMA.getBlockInstance());
                    break;
                }
                case 2: 
                case 3: {
                    t.pool = new BlockKey(FluidRegistry.getFluid((String)"ender").getBlock());
                    break;
                }
                case 4: {
                    Fluid fs = FluidRegistry.getFluid((String)"ic2uumatter");
                    if (fs == null || !fs.canBePlacedInWorld()) break;
                    t.core = new BlockKey(fs.getBlock());
                    break;
                }
                case 6: {
                    Fluid fs = FluidRegistry.getFluid((String)"fluidpure");
                    if (fs == null || !fs.canBePlacedInWorld()) break;
                    t.core = new BlockKey(fs.getBlock());
                    break;
                }
            }
            FilledBlockArray b = t.generate(world, dx, dy, dz);
            int tries = 0;
            while (tries < 100 && !b.isAtLeastXPercent(world, 90.0, Blocks.field_150350_a)) {
                dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)16);
                dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)16);
                dy = ReikaRandomHelper.getRandomPlusMinus((int)h, (int)6);
                b = t.generate(world, dx, dy, dz);
            }
            if (!b.isAtLeastXPercent(world, 90.0, Blocks.field_150350_a)) continue;
            b.place();
            if (!t.hasTreasure) continue;
            BlockLootChest.TileEntityLootChest te = (BlockLootChest.TileEntityLootChest)world.func_147438_o(dx, dy - t.size / 2, dz);
            this.generateLoot(te, rand);
        }
        return true;
    }

    private void generateLoot(BlockLootChest.TileEntityLootChest te, Random rand) {
        int n = 16 + rand.nextInt(24);
        ArrayList<ItemStack> li = ItemMagicRegistry.instance.getAllRegisteredItems();
        for (int i = 0; i < n; ++i) {
            int idx = rand.nextInt(li.size());
            ItemStack in = li.get(idx);
            ElementTagCompound value = ItemMagicRegistry.instance.getItemValue(in);
            int max = Math.min(16, 24 / value.getMaximumValue());
            int num = Math.min(1 + rand.nextInt(max), in.func_77976_d());
            ItemStack is = ReikaItemHelper.getSizedItemStack((ItemStack)in, (int)num);
            int slot = rand.nextInt(te.func_70302_i_());
            while (te.func_70301_a(slot) != null) {
                slot = rand.nextInt(te.func_70302_i_());
            }
            te.func_70299_a(slot, is);
        }
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return 0.005f;
    }

    private static class TerrainCrystal {
        private final int size;
        private final float heightFactor;
        private double heightExponent = 1.0;
        private boolean hasCore = false;
        private boolean hasPool = false;
        private boolean hasTreasure = false;
        private boolean hasResource = false;
        private BlockKey top = new BlockKey((Block)Blocks.field_150349_c);
        private BlockKey stone = new BlockKey(Blocks.field_150348_b);
        private BlockKey core = new BlockKey(Blocks.field_150353_l);
        private BlockKey pool = new BlockKey(Blocks.field_150355_j);

        private TerrainCrystal(int s, float h) {
            this.size = s;
            this.heightFactor = h;
        }

        public FilledBlockArray generate(World world, int x, int y, int z) {
            FilledBlockArray arr = new FilledBlockArray(world);
            int dy = y;
            double r = this.size;
            double mh = (float)this.size * this.heightFactor;
            int h = 0;
            while (r > 0.0) {
                int dr = MathHelper.func_76143_f((double)r);
                for (int i = -dr; i <= dr; ++i) {
                    for (int k = -dr; k <= dr; ++k) {
                        BlockKey b;
                        int d = Math.abs(i) + Math.abs(k);
                        if (d > dr) continue;
                        int dx = x + i;
                        int dz = z + k;
                        BlockKey blockKey = b = dy == y ? this.top : this.stone;
                        if (this.hasCore && d < dr - 1 && dy < y) {
                            b = this.core;
                        }
                        if (this.hasPool && d < dr - 1 && dy == y) {
                            b = this.pool;
                        }
                        arr.setBlock(dx, dy, dz, (BlockCheck)b);
                    }
                }
                r = (double)this.size * Math.pow(1.0 - (double)(++h) / mh, this.heightExponent);
                --dy;
            }
            if (this.hasTreasure) {
                arr.setBlock(x, y - this.size / 2, z, ChromaBlocks.LOOTCHEST.getBlockInstance());
            }
            if (this.hasResource) {
                int y2 = y - this.size / 2;
                arr.setBlock(x, y2, z, ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.LATTICE.ordinal());
                arr.setBlock(x, y2 + 1, z, ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.LATTICE.ordinal());
                arr.setBlock(x, y2 - 1, z, ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.LATTICE.ordinal());
                arr.setBlock(x + 1, y2, z, ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.LATTICE.ordinal());
                arr.setBlock(x - 1, y2, z, ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.LATTICE.ordinal());
                arr.setBlock(x, y2, z + 1, ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.LATTICE.ordinal());
                arr.setBlock(x, y2, z - 1, ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.LATTICE.ordinal());
            }
            if (this.hasCore) {
                HashSet<Coordinate> set = new HashSet<Coordinate>();
                for (Coordinate c : arr.keySet()) {
                    if (c.yCoord != arr.getMinY()) continue;
                    set.add(c);
                }
                for (Coordinate c : set) {
                    arr.setBlock(c.xCoord, c.yCoord, c.zCoord, (BlockCheck)this.stone);
                }
            }
            return arr;
        }
    }
}

