/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Rendering;

import Reika.ChromatiCraft.ChromaClient;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.IO.RemoteSourcedAsset;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Aurora {
    private static final RemoteSourcedAsset texture = ChromaClient.dynamicAssets.createAsset("Textures/aurora4.png");
    private static final int HEIGHT = 24;
    private final DecimalPosition point1;
    private final DecimalPosition point2;
    private final double length;
    private final double segmentSize;
    private AuroraSpline shape;
    public final int color1;
    public final int color2;

    public Aurora(int c1, int c2, double speed, double x1, double y1, double z1, double x2, double y2, double z2) {
        this.point1 = new DecimalPosition(x1, y1, z1);
        this.point2 = new DecimalPosition(x2, y2, z2);
        this.length = this.point2.getDistanceTo(this.point1);
        this.segmentSize = 16.0;
        int n = (int)Math.round(this.length / this.segmentSize);
        this.shape = new AuroraSpline(this.point1, this.point2, n, speed, this.segmentSize / 3.0);
        this.color1 = c1;
        this.color2 = c2;
    }

    public void update() {
        this.shape.update();
    }

    public void render() {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glShadeModel((int)7425);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glShadeModel((int)7425);
        ReikaRenderHelper.disableEntityLighting();
        ReikaTextureHelper.bindTexture((RemoteSourcedAsset)texture);
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78380_c(240);
        double t = (double)System.currentTimeMillis() / 150.0;
        int f = (int)(t % 32.0);
        double u = (double)(f % 4) * 0.125;
        double v = (double)(f / 4) * 0.25;
        double du = u + 0.125;
        double dv = v + 0.25;
        int steps = 32;
        List li = this.shape.spline.get(steps, false);
        for (int i = 0; i < li.size() - 1; ++i) {
            float fa;
            DecimalPosition pos1 = (DecimalPosition)li.get(i);
            DecimalPosition pos2 = (DecimalPosition)li.get(i + 1);
            double y1 = this.point1.yCoord + (this.point2.yCoord - this.point1.yCoord) * ((double)i / (double)li.size());
            double y2 = this.point1.yCoord + (this.point2.yCoord - this.point1.yCoord) * ((double)(i + 1) / (double)li.size());
            int c = (i - 1) % steps;
            double u1 = u + (double)c * (du - u) / (double)steps;
            double u2 = u1 + (du - u) / (double)steps;
            double v1 = dv;
            double v2 = v;
            float n = 32.0f;
            float f2 = (float)i < n ? (float)i / n : (fa = (float)(li.size() - i) < n ? (float)(li.size() - i - 1) / n : 1.0f);
            float fb = (float)(i + 1) < n ? (float)(i + 1) / n : ((float)(li.size() - (i + 1)) < n ? (float)(li.size() - (i + 1) - 1) / n : 1.0f);
            int c1a = ReikaColorAPI.getColorWithBrightnessMultiplier((int)this.color1, (float)fa);
            int c1b = ReikaColorAPI.getColorWithBrightnessMultiplier((int)this.color1, (float)fb);
            int c2a = ReikaColorAPI.getColorWithBrightnessMultiplier((int)this.color2, (float)fa);
            int c2b = ReikaColorAPI.getColorWithBrightnessMultiplier((int)this.color2, (float)fb);
            v5.func_78378_d(c1a);
            v5.func_78374_a(pos1.xCoord, y1, pos1.zCoord, u1, v1);
            v5.func_78378_d(c2a);
            v5.func_78374_a(pos1.xCoord, y1 + 24.0, pos1.zCoord, u1, v2);
            v5.func_78378_d(c2b);
            v5.func_78374_a(pos2.xCoord, y2 + 24.0, pos2.zCoord, u2, v2);
            v5.func_78378_d(c1b);
            v5.func_78374_a(pos2.xCoord, y2, pos2.zCoord, u2, v1);
        }
        v5.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private static class AuroraPoint
    extends Spline.BasicSplinePoint {
        private final double velocity;
        private final double variance;
        private double tolerance = 0.25;
        private double targetOffset;
        private double offset;
        private final double distanceX;
        private final double distanceY;
        private final double distanceZ;
        private final DecimalPosition origin;
        private final double distanceFraction;
        private final double xFactor;
        private final double zFactor;

        private AuroraPoint(DecimalPosition pos, double var, double vel, DecimalPosition o, double dxTot, double dyTot, double dzTot, double f, double fx, double fz) {
            super(pos.xCoord, pos.yCoord, pos.zCoord);
            this.variance = var;
            this.velocity = vel;
            this.distanceX = dxTot;
            this.distanceY = dyTot;
            this.distanceZ = dzTot;
            this.distanceFraction = f;
            this.origin = o;
            this.xFactor = fx;
            this.zFactor = fz;
            this.offset = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)this.variance);
            this.pickNewTarget();
        }

        public void update() {
            double d = this.targetOffset - this.offset;
            this.tolerance = 1.0;
            if (this.atTarget(d)) {
                this.pickNewTarget();
            }
            this.posY = this.origin.yCoord + this.distanceFraction * this.distanceY;
            this.posX = this.origin.xCoord + this.distanceFraction * this.distanceX + this.offset * this.xFactor;
            this.posZ = this.origin.zCoord + this.distanceFraction * this.distanceZ + this.offset * this.zFactor;
            this.move(d);
        }

        private void move(double d) {
            if (Math.abs(d) >= this.tolerance) {
                this.offset += this.velocity / 48.0 * Math.signum(d);
            }
        }

        private boolean atTarget(double d) {
            return Math.abs(d) < this.tolerance;
        }

        private void pickNewTarget() {
            this.targetOffset = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)this.variance);
        }
    }

    private static class AuroraSpline {
        private final Spline spline = new Spline(Spline.SplineType.CHORDAL);

        private AuroraSpline(DecimalPosition p1, DecimalPosition p2, int n, double vel, double var) {
            double dx = p2.xCoord - p1.xCoord;
            double dy = p2.yCoord - p1.yCoord;
            double dz = p2.zCoord - p1.zCoord;
            double ang = Math.toRadians(-ReikaPhysicsHelper.cartesianToPolar((double)dx, (double)dy, (double)dz)[2]);
            double fx = Math.cos(ang);
            double fz = Math.sin(ang);
            for (int i = 0; i <= n; ++i) {
                boolean end = i == 0 || i == n;
                double f = (double)i / (double)n;
                DecimalPosition mid = DecimalPosition.interpolate((DecimalPosition)p1, (DecimalPosition)p2, (double)f);
                this.spline.addPoint((Spline.SplineAnchor)new AuroraPoint(mid, end ? 0.0 : var, end ? 0.0 : vel, p1, dx, dy, dz, f, fx, fz));
            }
        }

        private void update() {
            this.spline.update();
        }
    }
}

