/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Rendering;

import Reika.ChromatiCraft.ChromaClient;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaShaders;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.DragonAPI.Auxiliary.Trackers.SpecialDayTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.IO.RemoteSourcedAsset;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class ChromaCloudRenderer
extends IRenderHandler {
    public static final ChromaCloudRenderer instance = new ChromaCloudRenderer();
    private static final int FOG_STAR_SECTIONS = 8;
    private final FogStarBrightness[][] fogStarBrightness = new FogStarBrightness[9][9];
    private final RemoteSourcedAsset[] skyTex = new RemoteSourcedAsset[4];

    private ChromaCloudRenderer() {
        int i;
        for (i = 0; i < this.fogStarBrightness.length; ++i) {
            for (int k = 0; k < this.fogStarBrightness.length; ++k) {
                this.fogStarBrightness[i][k] = new FogStarBrightness(DragonAPICore.rand);
            }
        }
        for (i = 0; i < 4; ++i) {
            this.skyTex[i] = ChromaClient.dynamicAssets.createAsset("Textures/clouds/dimsky_" + i + ".png");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float ptick, WorldClient world, Minecraft mc) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glDepthMask((boolean)false);
        Tessellator v5 = Tessellator.field_78398_a;
        double w = 512.0;
        float f2 = 1.0f;
        float playerY = (float)(mc.field_71451_h.field_70137_T + (mc.field_71451_h.field_70163_u - mc.field_71451_h.field_70137_T) * (double)ptick);
        float y = 36.0f - playerY * 0.0625f;
        double x = (mc.field_71451_h.field_70169_q + (mc.field_71451_h.field_70165_t - mc.field_71451_h.field_70169_q) * (double)ptick) / (double)f2;
        double z = (mc.field_71451_h.field_70166_s + (mc.field_71451_h.field_70161_v - mc.field_71451_h.field_70166_s) * (double)ptick) / (double)f2 + 0.33;
        GL11.glTranslated((double)(-x % (w * 2.0)), (double)y, (double)(-z % (w * 2.0)));
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glDisable((int)3008);
        int r = 2;
        for (int a = -r; a <= r; ++a) {
            for (int b = -r; b <= r; ++b) {
                boolean flag = SpecialDayTracker.instance.loadAprilTextures();
                int n = flag ? 1 : 4;
                for (int i = 0; i < n; ++i) {
                    if (flag) {
                        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/clouds/dimsky_april.png");
                    } else {
                        ReikaTextureHelper.bindTexture((RemoteSourcedAsset)this.skyTex[i]);
                    }
                    double s = 0.75 + 0.25 * (double)i;
                    double slide = (double)((float)(world.func_82737_E() % 24000L) + ptick) / 24000.0 * w * s % w;
                    GL11.glPushMatrix();
                    GL11.glRotated((double)(i * 60), (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslated((double)slide, (double)0.0, (double)0.0);
                    double d = -i * 6;
                    int c1 = 160;
                    int c2 = 112;
                    c1 = (int)((double)c1 * Math.min(1.0, Math.max(0.0, (double)playerY / 64.0)));
                    c2 = (int)((double)c2 * Math.min(1.0, Math.max(0.0, (double)playerY / 64.0)));
                    double mult = flag ? 1.0 : 0.625 + 0.375 * Math.sin((double)System.currentTimeMillis() / 2000.0 + (double)i * Math.PI / 2.0);
                    c1 = (int)((double)c1 * mult);
                    c2 = (int)((double)c2 * mult);
                    c1 = (int)((double)c1 * (1.0 - (double)(a * a + b * b) / 8.0));
                    c2 = (int)((double)c2 * (1.0 - (double)(a * a + b * b) / 8.0));
                    c1 = ReikaColorAPI.GStoHex((int)c1);
                    c2 = ReikaColorAPI.GStoHex((int)c2);
                    this.drawCloudLayer2(v5, a, b, c1, w * 1.0, 180.0 + d - (double)playerY * 0.4375, i);
                    this.drawCloudLayer2(v5, a, b, c2, w, 0.0 + d, i);
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void drawVoidFog(EntityPlayer ep) {
        if (MinecraftForgeClient.getRenderPass() != 0) {
            return;
        }
        if (ep.field_70163_u > 80.0) {
            return;
        }
        if (ep.field_70163_u < 20.0 && ChromaDimensionManager.getStructurePlayerIsIn(ep) == null) {
            ChromaShaders.DIMFLOOR.refresh();
            ChromaShaders.DIMFLOOR.rampUpIntensity(0.05f, 1.1f);
            float f = ep.field_70163_u <= 10.0 ? 1.0f : 1.0f - (float)((ep.field_70163_u - 10.0) / 10.0);
            ChromaShaders.DIMFLOOR.setIntensity(Math.min(ChromaShaders.DIMFLOOR.getIntensity(), f));
            ChromaShaders.DIMFLOOR.lingerTime = 20;
            ChromaShaders.DIMFLOOR.rampDownAmount = 0.001f;
            ChromaShaders.DIMFLOOR.rampDownFactor = 0.999f;
            float f2 = 0.0f;
            if (ep.field_70163_u <= 1.0) {
                f2 = 1.0f;
            } else if (ep.field_70163_u <= 3.5) {
                f2 = 1.0f - (float)((ep.field_70163_u - 1.0) / 2.5);
            }
            ChromaShaders.DIMFLOOR.getShader().setField("starFactor", (Object)Float.valueOf(f2));
        }
        Tessellator v5 = Tessellator.field_78398_a;
        float f = ReikaRenderHelper.getPartialTickTime();
        double ox = ep.field_70165_t + (ep.field_70165_t - ep.field_70142_S) * (double)f;
        double oy = ep.field_70163_u + (ep.field_70163_u - ep.field_70137_T) * (double)f;
        double oz = ep.field_70161_v + (ep.field_70161_v - ep.field_70136_U) * (double)f;
        double h0 = 0.0;
        if (oy < 0.0) {
            h0 += oy;
        }
        double w = 512.0;
        int color = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)(190 + (int)(10.0 * Math.sin(((float)ep.field_70173_aa + f) / 83.0f))));
        color = ReikaColorAPI.getModifiedSat((int)color, (float)(0.25f + (float)(0.125 * Math.cos(((float)ep.field_70173_aa + f) / 57.0f))));
        double r = w * 2.0;
        double tx = ox % r / r;
        double tz = oz % r / r;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        ReikaRenderHelper.disableEntityLighting();
        GL11.glDepthMask((boolean)false);
        GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
        double t = (float)ep.field_70173_aa + f;
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/clouds/dimfog.png");
        v5.func_78382_b();
        double h1 = 0.125 + 0.0625 * Math.cos(t / 71.0);
        double h = 0.05;
        float a = 1.0f;
        double dx = 0.0;
        double dz = 0.0;
        double maxh = h0;
        while ((double)a > 0.125) {
            h += h1 + h / 3.0;
            v5.func_78384_a(color, (int)(a * 255.0f));
            v5.func_78374_a(ox + dx - w, h0 + h, oz + dz - w, tx, tz);
            v5.func_78374_a(ox + dx + w, h0 + h, oz + dz - w, tx + 6.0, tz);
            v5.func_78374_a(ox + dx + w, h0 + h, oz + dz + w, tx + 6.0, tz + 6.0);
            v5.func_78374_a(ox + dx - w, h0 + h, oz + dz + w, tx, tz + 6.0);
            dx += Math.sin((double)ep.hashCode() / 117.0 + h * 11.0 + t / 47.0);
            dz += Math.sin((double)ep.hashCode() / 153.0 + h * 13.0 + t / 53.0);
            a = (float)((double)a * 0.75);
            maxh = h0 + h;
        }
        if (oy < 2.0) {
            a = Math.min(1.0f, 1.0f - (float)(oy / 2.0));
            dx = 0.0;
            dz = 0.0;
            v5.func_78384_a(color, (int)(a * 255.0f));
            v5.func_78374_a(ox + dx - w, oy - 4.0, oz + dz - w, tx, tz);
            v5.func_78374_a(ox + dx + w, oy - 4.0, oz + dz - w, tx + 3.0, tz);
            v5.func_78374_a(ox + dx + w, oy - 4.0, oz + dz + w, tx + 3.0, tz + 3.0);
            v5.func_78374_a(ox + dx - w, oy - 4.0, oz + dz + w, tx, tz + 3.0);
        }
        v5.func_78381_a();
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/clouds/dimfog-stars.png");
        v5.func_78382_b();
        v5.func_78378_d(ReikaColorAPI.mixColors((int)color, (int)0xFFFFFF, (float)0.5f));
        double x0 = ox - w;
        double z0 = oz - w;
        double sz = w * 2.0 / 8.0;
        double dt = 12.0;
        double st = dt / 8.0;
        double d = 36.0;
        double y = Math.min(h0 + 0.05, oy - d);
        for (int i = 0; i < 8; ++i) {
            for (int k = 0; k < 8; ++k) {
                double x1 = x0 + (double)i * sz;
                double z1 = z0 + (double)k * sz;
                double u = tx + 0.35 + st * (double)i;
                double v = tz + 0.5 + st * (double)k;
                double b1 = ChromaCloudRenderer.instance.fogStarBrightness[i][k].getBrightness(t);
                double b2 = ChromaCloudRenderer.instance.fogStarBrightness[i + 1][k].getBrightness(t);
                double b3 = ChromaCloudRenderer.instance.fogStarBrightness[i + 1][k + 1].getBrightness(t);
                double b4 = ChromaCloudRenderer.instance.fogStarBrightness[i][k + 1].getBrightness(t);
                v5.func_78378_d(ReikaColorAPI.GStoHex((int)((int)(255.0 * b1))));
                v5.func_78374_a(x1, y, z1, u, v);
                v5.func_78378_d(ReikaColorAPI.GStoHex((int)((int)(255.0 * b2))));
                v5.func_78374_a(x1 + sz, y, z1, u + st, v);
                v5.func_78378_d(ReikaColorAPI.GStoHex((int)((int)(255.0 * b3))));
                v5.func_78374_a(x1 + sz, y, z1 + sz, u + st, v + st);
                v5.func_78378_d(ReikaColorAPI.GStoHex((int)((int)(255.0 * b4))));
                v5.func_78374_a(x1, y, z1 + sz, u, v + st);
            }
        }
        v5.func_78381_a();
        ReikaRenderHelper.enableEntityLighting();
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private double getCloudOffset(int i, int k, int index) {
        long time = System.currentTimeMillis() + (long)(index * 40000000);
        double d = 2.0 + 2.0 * Math.sin((double)(i * i + k * k) / 32.0 * (double)((time % 250000L + 250000L) % 250000L) / 250000.0);
        return d * (Math.sin((double)i + (double)time / 5000.0) + Math.sin((double)k / 2.0 + (double)time / 2000.0));
    }

    private void drawCloudLayer2(Tessellator v5, int a, int b, int color, double w, double h, int index) {
        v5.func_78382_b();
        v5.func_78378_d(color);
        long time = System.currentTimeMillis() + (long)(index * 40000000);
        double d1 = 4.0 * Math.sin((double)time / 10000.0);
        double d2 = 9.0 * Math.sin((double)time / 20000.0);
        double d3 = 3.0 * Math.sin((double)time / 4000.0);
        double d4 = 6.0 * Math.cos((double)time / 15000.0);
        double h1 = h + d1;
        double h2 = h + d2;
        double h3 = h + d3;
        double h4 = h + d4;
        double dw = (double)a * w * 2.0;
        double dw2 = (double)b * w * 2.0;
        v5.func_78374_a(dw - w, h1, dw2 - w, 0.0, 0.0);
        v5.func_78374_a(dw + w, h2, dw2 - w, 1.0, 0.0);
        v5.func_78374_a(dw + w, h3, dw2 + w, 1.0, 1.0);
        v5.func_78374_a(dw - w, h4, dw2 + w, 0.0, 1.0);
        v5.func_78381_a();
    }

    private void drawCloudLayer(Tessellator v5, int color, double w, double h, int index) {
        v5.func_78382_b();
        v5.func_78384_a(0xFFFFFF, color);
        int s = 128;
        double[][] off = new double[s + 2][s + 2];
        for (int i = -1; i <= s; ++i) {
            for (int k = -1; k <= s; ++k) {
                off[i + 1][k + 1] = this.getCloudOffset(i, k, index) * (double)(h > 0.0 ? 4 : 1);
            }
        }
        double f = 1.0 / (double)s;
        double f2 = f * w;
        for (int i = 0; i < s; ++i) {
            double fxt = (double)i * f;
            double fx = (double)i * f2;
            double dx = -w + fx;
            for (int k = 0; k < s; ++k) {
                double fzt = (double)k * f;
                double fz = (double)k * f2;
                double dz = -w + fz;
                double hmm = h + (off[i + 1][k + 1] + off[i - 1 + 1][k - 1 + 1] + off[i - 1 + 1][k + 1] + off[i + 1][k - 1 + 1]) / 5.0;
                double hpm = h + (off[i + 1][k + 1] + off[i + 1 + 1][k - 1 + 1] + off[i + 1 + 1][k + 1] + off[i + 1][k - 1 + 1]) / 5.0;
                double hpp = h + (off[i + 1][k + 1] + off[i + 1 + 1][k + 1 + 1] + off[i + 1 + 1][k + 1] + off[i + 1][k + 1 + 1]) / 5.0;
                double hmp = h + (off[i + 1][k + 1] + off[i - 1 + 1][k + 1 + 1] + off[i - 1 + 1][k + 1] + off[i + 1][k + 1 + 1]) / 5.0;
                v5.func_78374_a(dx, hmm, dz, fxt, fzt);
                v5.func_78374_a(dx + f2, hpm, dz, fxt + f, fzt);
                v5.func_78374_a(dx + f2, hpp, dz + f2, fxt + f, fzt + f);
                v5.func_78374_a(dx, hmp, dz + f2, fxt, fzt + f);
            }
        }
        v5.func_78381_a();
    }

    private void renderCloudsVanilla(WorldClient world, Minecraft mc, float ptick) {
        float f10;
        float f9;
        float f8;
        float playerY = (float)(mc.field_71451_h.field_70137_T + (mc.field_71451_h.field_70163_u - mc.field_71451_h.field_70137_T) * (double)ptick);
        Tessellator tessellator = Tessellator.field_78398_a;
        float f2 = 12.0f;
        float cloudTickCounter = world.func_82737_E();
        double slide = cloudTickCounter + ptick;
        double posX = (mc.field_71451_h.field_70169_q + (mc.field_71451_h.field_70165_t - mc.field_71451_h.field_70169_q) * (double)ptick + slide * 0.03) / (double)f2;
        double posZ = (mc.field_71451_h.field_70166_s + (mc.field_71451_h.field_70161_v - mc.field_71451_h.field_70166_s) * (double)ptick) / (double)f2 + 0.33;
        float f4 = world.field_73011_w.func_76571_f() - playerY + 0.33f;
        int i = MathHelper.func_76128_c((double)(posX / 2048.0));
        int j = MathHelper.func_76128_c((double)(posZ / 2048.0));
        posX -= (double)(i * 2048);
        posZ -= (double)(j * 2048);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/clouds/dimension.png");
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Vec3 vec3 = world.func_72824_f(ptick);
        float red = (float)vec3.field_72450_a;
        float green = (float)vec3.field_72448_b;
        float blue = (float)vec3.field_72449_c;
        if (mc.field_71474_y.field_74337_g) {
            f8 = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
            f9 = (red * 30.0f + green * 70.0f) / 100.0f;
            f10 = (red * 30.0f + blue * 70.0f) / 100.0f;
            red = f8;
            green = f9;
            blue = f10;
        }
        f8 = (float)(posX * 0.0);
        f9 = (float)(posZ * 0.0);
        f10 = 0.00390625f;
        f8 = (float)MathHelper.func_76128_c((double)posX) * f10;
        f9 = (float)MathHelper.func_76128_c((double)posZ) * f10;
        float floatX = (float)(posX - (double)MathHelper.func_76128_c((double)posX));
        float floatZ = (float)(posZ - (double)MathHelper.func_76128_c((double)posZ));
        int b0 = 8;
        int b1 = 4;
        float f13 = 0.0f;
        GL11.glScalef((float)f2, (float)1.0f, (float)f2);
        for (int k = 0; k < 2; ++k) {
            if (k == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else if (mc.field_71474_y.field_74337_g) {
                if (EntityRenderer.field_78515_b == 0) {
                    GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                } else {
                    GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                }
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            for (int dx = -b1 + 1; dx <= b1; ++dx) {
                for (int dz = -b1 + 1; dz <= b1; ++dz) {
                    int j1;
                    tessellator.func_78382_b();
                    float f14 = dx * b0;
                    float f15 = dz * b0;
                    float f16 = f14 - floatX;
                    float f17 = f15 - floatZ;
                    double sx = (double)f16 - mc.field_71451_h.field_70165_t;
                    double sz = (double)f17 - mc.field_71451_h.field_70161_v;
                    double f3 = 4.0 + 2.0 * Math.sin((sx * sx + sz * sz) / 10000.0);
                    if ((double)f4 > -f3 - 1.0) {
                        tessellator.func_78369_a(red * 0.7f, green * 0.7f, blue * 0.7f, 0.8f);
                        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                        tessellator.func_78374_a((double)(f16 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + (float)b0), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + (float)b0), (double)(f4 + 0.0f), (double)(f17 + (float)b0), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + (float)b0), (double)(f4 + 0.0f), (double)(f17 + 0.0f), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + 0.0f), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                    }
                    if ((double)f4 <= f3 + 1.0) {
                        tessellator.func_78369_a(red, green, blue, 0.8f);
                        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                        tessellator.func_78374_a((double)(f16 + 0.0f), (double)f4 + f3 - (double)f13, (double)(f17 + (float)b0), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + (float)b0), (double)f4 + f3 - (double)f13, (double)(f17 + (float)b0), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + (float)b0), (double)f4 + f3 - (double)f13, (double)(f17 + 0.0f), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + 0.0f), (double)f4 + f3 - (double)f13, (double)(f17 + 0.0f), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                    }
                    tessellator.func_78369_a(red * 0.9f, green * 0.9f, blue * 0.9f, 0.8f);
                    if (dx > -1) {
                        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                        for (j1 = 0; j1 < b0; ++j1) {
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + (float)b0), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 0.0f), (double)f4 + f3, (double)(f17 + (float)b0), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 0.0f), (double)f4 + f3, (double)(f17 + 0.0f), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + 0.0f), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                        }
                    }
                    if (dx <= 1) {
                        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                        for (j1 = 0; j1 < b0; ++j1) {
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 1.0f - f13), (double)(f4 + 0.0f), (double)(f17 + (float)b0), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 1.0f - f13), (double)f4 + f3, (double)(f17 + (float)b0), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 1.0f - f13), (double)f4 + f3, (double)(f17 + 0.0f), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 1.0f - f13), (double)(f4 + 0.0f), (double)(f17 + 0.0f), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                        }
                    }
                    tessellator.func_78369_a(red * 0.8f, green * 0.8f, blue * 0.8f, 0.8f);
                    if (dz > -1) {
                        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                        for (j1 = 0; j1 < b0; ++j1) {
                            tessellator.func_78374_a((double)(f16 + 0.0f), (double)f4 + f3, (double)(f17 + (float)j1 + 0.0f), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)b0), (double)f4 + f3, (double)(f17 + (float)j1 + 0.0f), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)b0), (double)(f4 + 0.0f), (double)(f17 + (float)j1 + 0.0f), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + (float)j1 + 0.0f), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                        }
                    }
                    if (dz <= 1) {
                        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                        for (j1 = 0; j1 < b0; ++j1) {
                            tessellator.func_78374_a((double)(f16 + 0.0f), (double)f4 + f3, (double)(f17 + (float)j1 + 1.0f - f13), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)b0), (double)f4 + f3, (double)(f17 + (float)j1 + 1.0f - f13), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)b0), (double)(f4 + 0.0f), (double)(f17 + (float)j1 + 1.0f - f13), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + (float)j1 + 1.0f - f13), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                        }
                    }
                    tessellator.func_78381_a();
                }
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    private static class FogStarBrightness {
        private final double period;
        private final double offset;

        private FogStarBrightness(Random rand) {
            this(8.0 + rand.nextDouble() * 18.0, rand.nextDouble() * Math.PI * 2.0);
        }

        private FogStarBrightness(double p, double o) {
            this.period = 1.0 / p;
            this.offset = o;
        }

        public double getBrightness(double t) {
            return 0.5 + 0.5 * Math.sin(this.offset + t * this.period);
        }
    }
}

