/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Rendering;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class ChromaSkyRenderer
extends IRenderHandler {
    public static final ChromaSkyRenderer instance = new ChromaSkyRenderer();
    private final int[] starColors = new int[]{0xFFFFFF, 13041658, 13035007, 10204927, 8155391, 0xFF6868, 0xFFADAD, 0xFFDAAD, 16773293};
    private final Random rand = new Random();
    public static final int BASE_STARS = 5000;
    public static final int STARS_VARIATION = 2500;
    private final Star[] stars = new Star[7500];
    private final TexturedQuad[] nebulae = new TexturedQuad[16];
    private final TexturedQuad[] planets = new TexturedQuad[32];

    private ChromaSkyRenderer() {
        int i;
        for (i = 0; i < this.stars.length; ++i) {
            int texture = this.rand.nextInt(16);
            int c1 = this.starColors[this.rand.nextInt(this.starColors.length)];
            double tw = ReikaRandomHelper.getRandomBetween((double)0.125, (double)4.0);
            double ta = ReikaRandomHelper.getRandomBetween((double)0.0625, (double)0.375);
            this.stars[i] = Star.createRandomized(c1, texture, tw, ta, this.rand);
            if (this.stars[i] == null) continue;
            this.stars[i].twinkleOffset = i;
        }
        for (i = 0; i < this.nebulae.length; ++i) {
            this.nebulae[i] = TexturedQuad.constructRandomized(i, 4, 175.0, this.rand);
        }
        for (i = 0; i < this.planets.length; ++i) {
            this.planets[i] = TexturedQuad.constructRandomized(i, 2, 30.0, this.rand);
        }
    }

    private int getStarCount(double tick) {
        return 5000 + (int)(2500.0 * Math.sin(tick / 24000.0));
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float f;
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3553);
        this.renderBlackscreen();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glDepthMask((boolean)false);
        double t = System.currentTimeMillis();
        float f2 = mc.field_71439_g.field_70163_u <= 18.0 ? 0.0f : (f = mc.field_71439_g.field_70163_u >= 30.0 ? 1.0f : (float)((mc.field_71439_g.field_70163_u - 18.0) / 12.0));
        if (ReikaEntityHelper.canEntitySeeTheSky((Entity)mc.field_71439_g)) {
            f = 1.0f;
        }
        GL11.glPushMatrix();
        this.renderStars(t, f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.renderPlanets(t, f);
        GL11.glPopMatrix();
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    private void renderNebulae(double t, float f) {
        if (f == 0.0f) {
            return;
        }
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/stars2.png");
        Tessellator v5 = Tessellator.field_78398_a;
        for (int i = 0; i < this.nebulae.length; ++i) {
            TexturedQuad neb = this.nebulae[i];
            if (neb == null) continue;
            GL11.glPushMatrix();
            double rx = i * 8;
            double ry = i % 4 * 32;
            double rz = -i * 15 + 90;
            GL11.glRotated((double)rx, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)ry, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rz, (double)0.0, (double)0.0, (double)1.0);
            v5.func_78382_b();
            v5.func_78380_c(240);
            v5.func_78378_d(ReikaColorAPI.GStoHex((int)((int)(255.0f * f))));
            neb.render(380.0, 1.0f, t);
            v5.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    private void renderPlanets(double t, float f) {
        if (f == 0.0f) {
            return;
        }
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/planets2.png");
        Tessellator v5 = Tessellator.field_78398_a;
        for (int k = 0; k < this.planets.length; ++k) {
            TexturedQuad planet = this.planets[k];
            if (planet == null) continue;
            int i = k % 4;
            GL11.glPushMatrix();
            double rx = (double)(k * 8) + t / 4000.0 % 360.0 + (double)i * 90.0 * Math.signum((double)(k % 2) - 0.5);
            double ry = (double)(i / 2 * 180) + t / 16000.0 % 360.0 - (double)i * 30.0;
            double rz = (double)(k % 4 * 60) + t / 240000.0 % 360.0 * (double)(1 + i % 2);
            GL11.glRotated((double)rx, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)ry, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rz, (double)0.0, (double)0.0, (double)1.0);
            v5.func_78382_b();
            v5.func_78380_c(240);
            v5.func_78378_d(ReikaColorAPI.GStoHex((int)((int)(255.0f * f))));
            planet.render(380.0, 1.0f, t);
            v5.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    private void renderBlackscreen() {
        Tessellator v5 = Tessellator.field_78398_a;
        for (int i = 0; i < 6; ++i) {
            double d = 450.0;
            double u = 0.0;
            double v = 0.0;
            double du = 1.0 - u;
            double dv = 1.0 - v;
            GL11.glPushMatrix();
            switch (i) {
                case 1: {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 2: {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 3: {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 4: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                case 5: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            v5.func_78382_b();
            v5.func_78378_d(0);
            v5.func_78374_a(-d, -d, -d, u, v);
            v5.func_78374_a(-d, -d, d, u, dv);
            v5.func_78374_a(d, -d, d, du, dv);
            v5.func_78374_a(d, -d, -d, du, v);
            v5.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    private void renderStars(double t, float f) {
        if (f == 0.0f) {
            return;
        }
        double f1 = 0.125;
        double f2 = 0.125;
        double f3 = 0.125;
        GL11.glRotated((double)(RenderManager.field_78725_b * f1), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)(RenderManager.field_78726_c * f2), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(RenderManager.field_78723_d * f3), (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)(t / 12000.0 % 360.0), (double)0.0, (double)0.0, (double)1.0);
        this.renderNebulae(t, f);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/stars.png");
        int nstar = this.getStarCount(t);
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78380_c(240);
        for (int i = 0; i < nstar; ++i) {
            Star s = this.stars[i];
            if (s == null) continue;
            int dt = nstar - i;
            double dl = (double)i / 10.0 / (double)nstar;
            s.render(320.0 - dl, Math.min((float)dt, 24.0f * f), t);
        }
        v5.func_78381_a();
    }

    private static class TexturedQuad {
        public final int textureIndex;
        public final double size;
        private final double[] texU;
        private final double[] texV;
        private final double d0;
        private final double d1;
        private final double d2;
        private final double d3;
        private final double d9;
        private final double d10;
        private final double d12;
        private final double d13;
        private final double d16;

        private TexturedQuad(int tex, int rowWidth, double s, double d0, double d1, double d2, double d3, double d9, double d10, double d12, double d13, double d16) {
            this.textureIndex = tex;
            this.size = s;
            int ttex = rowWidth * rowWidth;
            tex = (tex % ttex + ttex) % ttex;
            double du = (double)(this.textureIndex % rowWidth) / (double)rowWidth;
            double dv = (double)(this.textureIndex / rowWidth) / (double)rowWidth;
            this.texU = new double[]{du, du, du + 1.0 / (double)rowWidth, du + 1.0 / (double)rowWidth};
            this.texV = new double[]{dv, dv + 1.0 / (double)rowWidth, dv + 1.0 / (double)rowWidth, dv};
            this.d0 = d0;
            this.d1 = d1;
            this.d2 = d2;
            this.d3 = d3;
            this.d9 = d9;
            this.d10 = d10;
            this.d12 = d12;
            this.d13 = d13;
            this.d16 = d16;
        }

        private static TexturedQuad constructRandomized(int tex, int row, double s, Random rand) {
            double d0 = rand.nextFloat() * 2.0f - 1.0f;
            double d1 = rand.nextFloat() * 2.0f - 1.0f;
            double d2 = rand.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + rand.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (d4 < 1.0 && d4 > 0.01) {
                d4 = 1.0 / Math.sqrt(d4);
                double d8 = Math.atan2(d0 *= d4, d2 *= d4);
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1 *= d4);
                double d12 = Math.sin(d11);
                double d13 = Math.cos(d11);
                double d14 = rand.nextDouble() * Math.PI * 2.0;
                double d16 = Math.cos(d14);
                return new TexturedQuad(tex, row, s, d0, d1, d2, d3, d9, d10, d12, d13, d16);
            }
            return null;
        }

        protected void render(double d, float brightness, double time) {
            double d5 = this.d0 * d;
            double d6 = this.d1 * d;
            double d7 = this.d2 * d;
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * this.d3;
                double d19 = (double)((j + 1 & 2) - 1) * this.d3;
                double d20 = d18 * this.d16 - d19 * this.size;
                double d21 = d19 * this.d16 + d18 * this.size;
                double d22 = d20 * this.d12 + d17 * this.d13;
                double d23 = d17 * this.d12 - d20 * this.d13;
                double d24 = d23 * this.d9 - d21 * this.d10;
                double d25 = d21 * this.d9 + d23 * this.d10;
                Tessellator.field_78398_a.func_78374_a(d5 + d24, d6 + d22, d7 + d25, this.texU[j], this.texV[j]);
            }
        }
    }

    private static class Star
    extends TexturedQuad {
        public final int color;
        private final double twinkleSpeed;
        private final double twinkleAmplitude;
        private double twinkleOffset;

        private Star(int c, int tex, double s, double tw, double ta, double d0, double d1, double d2, double d3, double d9, double d10, double d12, double d13, double d16) {
            super(tex, 4, s, d0, d1, d2, d3, d9, d10, d12, d13, d16);
            this.color = c;
            this.twinkleSpeed = tw;
            this.twinkleAmplitude = ta;
        }

        private static Star createRandomized(int c, int tex, double tw, double ta, Random rand) {
            double d0 = rand.nextFloat() * 2.0f - 1.0f;
            double d1 = rand.nextFloat() * 2.0f - 1.0f;
            double d2 = rand.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + rand.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (d4 < 1.0 && d4 > 0.01) {
                d4 = 1.0 / Math.sqrt(d4);
                double d8 = Math.atan2(d0 *= d4, d2 *= d4);
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1 *= d4);
                double d12 = Math.sin(d11);
                double d13 = Math.cos(d11);
                double d14 = rand.nextDouble() * Math.PI * 2.0;
                double d16 = Math.cos(d14);
                double size = 1.0 + Math.sin(d14) * (rand.nextDouble() * 4.0);
                return new Star(c, tex, size * 12.0, tw, ta, d0, d1, d2, d3, d9, d10, d12, d13, d16);
            }
            return null;
        }

        @Override
        protected void render(double d, float brightness, double time) {
            if (brightness <= 0.0f) {
                return;
            }
            double td = 500.0;
            double tb = 1.0 - this.twinkleAmplitude;
            int c2 = ReikaColorAPI.getColorWithBrightnessMultiplier((int)this.color, (float)((float)(tb + this.twinkleAmplitude * Math.sin(this.twinkleOffset + time * this.twinkleSpeed / td))));
            int c = brightness >= 24.0f ? c2 : ReikaColorAPI.getColorWithBrightnessMultiplier((int)c2, (float)(brightness / 24.0f));
            Tessellator.field_78398_a.func_78378_d(c);
            super.render(d, brightness, time);
        }
    }
}

