/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Rendering;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaShaders;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.World.Dimension.SkyRiverGenerator;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.ParticleController.CollectingPositionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SkyRiverRenderer {
    public static final SkyRiverRenderer instance = new SkyRiverRenderer();
    private static final double STEP_PER_POINT = 0.75;

    private SkyRiverRenderer() {
    }

    public void render() {
        EntityClientPlayerMP pl;
        SkyRiverGenerator.RiverPoint closest;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glDepthMask((boolean)false);
        Collection<SkyRiverGenerator.RiverPoint> c = SkyRiverGenerator.getPointsWithin((EntityPlayer)Minecraft.func_71410_x().field_71439_g, 512.0, false);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"/Reika/ChromatiCraft/Textures/SkyRiver2.png");
        boolean rendered = false;
        for (SkyRiverGenerator.RiverPoint p : c) {
            double pz;
            double py;
            double px;
            double d;
            int i;
            double lz;
            double ly;
            double lx;
            int n;
            int clr;
            if (p.nextRiverPoint == null) continue;
            rendered = true;
            GL11.glPushMatrix();
            GL11.glTranslated((double)p.position.xCoord, (double)p.position.yCoord, (double)p.position.zCoord);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glTranslated((double)((double)(-System.currentTimeMillis()) % 4000.0 / 4000.0), (double)0.0, (double)0.0);
            GL11.glMatrixMode((int)5888);
            double t = (double)System.currentTimeMillis() / 1250.0;
            double r1 = 12.0 + 4.0 * Math.sin(t - (double)p.positionID * 0.75);
            double r2 = 12.0 + 4.0 * Math.sin(t - (double)p.nextRiverPoint.positionID * 0.75);
            int c1 = clr = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)((int)(((double)(p.positionID * 4) - (double)System.currentTimeMillis() / 500.0) % 360.0)));
            int c2 = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)((int)(((double)((p.positionID + 1) * 4) - (double)System.currentTimeMillis() / 500.0) % 360.0)));
            if (p.positionID == 1) {
                c1 = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c1, (float)0.01f);
            } else if (p.nextRiverPoint.nextRiverPoint == null) {
                c2 = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c2, (float)0.01f);
            }
            ChromaFX.drawEnergyTransferBeam(p.position, p.next, c1, c2, r1, r2, 36, t / 4500.0, true);
            GL11.glMatrixMode((int)5890);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            if (Minecraft.func_71410_x().func_147113_T()) continue;
            if (p.positionID == 1) {
                n = ReikaRandomHelper.getRandomBetween((int)1, (int)3);
                lx = p.next.xCoord - p.position.xCoord;
                ly = p.next.yCoord - p.position.yCoord;
                lz = p.next.zCoord - p.position.zCoord;
                for (i = 0; i < n; ++i) {
                    d = ReikaRandomHelper.getRandomBetween((double)0.5, (double)0.9375);
                    px = p.position.xCoord - lx * d;
                    py = p.position.yCoord - ly * d;
                    pz = p.position.zCoord - lz * d;
                    double tx = p.position.xCoord + lx / 32.0;
                    double ty = p.position.yCoord + ly / 32.0;
                    double tz = p.position.zCoord + lz / 32.0;
                    double dx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)(r1 / 2.0));
                    double dy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)(r1 / 2.0));
                    double dz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)(r1 / 2.0));
                    double dd = ReikaRandomHelper.getRandomBetween((double)1.25, (double)2.0);
                    int l = ReikaRandomHelper.getRandomBetween((int)15, (int)30);
                    CollectingPositionController pc = new CollectingPositionController(px += dx * dd, py += dy * dd, pz += dz * dd, tx += dx, ty += dy, tz += dz, l);
                    EntityBlurFX fx = new EntityCCBlurFX((World)Minecraft.func_71410_x().field_71441_e, px, py, pz).setIcon(ChromaIcons.FADE_GENTLE).setLife(l).setScale(14.0f).setPositionController((PositionController)pc).setColor(clr);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
                continue;
            }
            if (p.nextRiverPoint.nextRiverPoint != null) continue;
            n = ReikaRandomHelper.getRandomBetween((int)1, (int)3);
            lx = p.next.xCoord - p.position.xCoord;
            ly = p.next.yCoord - p.position.yCoord;
            lz = p.next.zCoord - p.position.zCoord;
            for (i = 0; i < n; ++i) {
                d = ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.375);
                px = p.position.xCoord + lx * d;
                py = p.position.yCoord + ly * d;
                pz = p.position.zCoord + lz * d;
                double dx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)(r1 / 4.0));
                double dy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)(r1 / 4.0));
                double dz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)(r1 / 4.0));
                double dd = ReikaRandomHelper.getRandomBetween((double)1.25, (double)2.0);
                px += dx * dd;
                py += dy * dd;
                pz += dz * dd;
                double v = ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.25) / 8.0;
                double vx = v * lx;
                double vy = v * ly;
                double vz = v * lz;
                vx = ReikaRandomHelper.getRandomPlusMinus((double)vx, (double)0.125);
                vy = ReikaRandomHelper.getRandomPlusMinus((double)vy, (double)0.125);
                vz = ReikaRandomHelper.getRandomPlusMinus((double)vz, (double)0.125);
                int l = ReikaRandomHelper.getRandomBetween((int)30, (int)80);
                EntityBlurFX fx = new EntityCCBlurFX((World)Minecraft.func_71410_x().field_71441_e, px, py, pz, vx, vy, vz).setIcon(ChromaIcons.FADE_GENTLE).setLife(l).setScale(14.0f).setColor(clr);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        if (rendered && (closest = SkyRiverGenerator.getClosestPoint((EntityPlayer)(pl = Minecraft.func_71410_x().field_71439_g), 16.0, true)) != null && SkyRiverGenerator.isWithinSkyRiver((EntityPlayer)pl, closest)) {
            ChromaShaders.INSKYRIVER.rampUpIntensity(0.02f, 1.06f);
            ChromaShaders.INSKYRIVER.refresh();
            ChromaShaders.INSKYRIVER.lingerTime = 20;
            ChromaShaders.INSKYRIVER.rampDownAmount = 0.004f;
            ChromaShaders.INSKYRIVER.rampDownFactor = 0.994f;
            ChromaShaders.INSKYRIVER.getShader().setMatricesToCurrent();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void doRenderRiver() {
    }
}

