/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.Altar;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.AltarGenerator;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class AltarTunnel
extends StructurePiece<AltarGenerator> {
    public final int length;
    public final ForgeDirection direction;
    private final ForgeDirection left;

    public AltarTunnel(AltarGenerator g, ForgeDirection dir, int len) {
        super(g);
        this.direction = dir;
        this.length = len;
        this.left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        for (int i = 0; i < this.length; ++i) {
            this.generateSlice(world, x + this.direction.offsetX * i, y + this.direction.offsetY * i, z + this.direction.offsetZ * i);
        }
    }

    private void generateSlice(ChunkSplicedGenerationCache world, int dx, int dy, int dz) {
        int w = 4;
        int h = 6;
        for (int i = -w; i <= w; ++i) {
            for (int k = 0; k < h; ++k) {
                int dx2 = dx + this.left.offsetX * i;
                int dz2 = dz + this.left.offsetZ * i;
                int dy2 = dy + k;
                boolean edge = k == 0 || k == h - 1 || i == w || i == -w;
                Block b = edge ? ChromaBlocks.STRUCTSHIELD.getBlockInstance() : Blocks.field_150350_a;
                int mt = edge ? BlockStructureShield.BlockType.STONE.metadata : 0;
                world.setBlock(dx2, dy2, dz2, b, mt);
            }
        }
    }
}

