/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.AntFarm;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.AntFarmGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.init.Blocks;

public class AntFarmTunnel_Old
extends StructurePiece<AntFarmGenerator> {
    public final ReikaDirectionHelper.CubeDirections direction;
    public final int slope;
    public final int length1;
    public final int length2;
    public final int length3;
    public final int tunnelRadius;
    private final HashSet<Coordinate> air = new HashSet();
    private final HashMap<Coordinate, BlockKey> blocks = new HashMap();

    public AntFarmTunnel_Old(AntFarmGenerator a, ReikaDirectionHelper.CubeDirections dir, int s, int l1, int l2, int l3, int r, int x, int y, int z, HashSet<Coordinate> airSpaces) {
        super(a);
        this.direction = dir;
        this.slope = s;
        this.length1 = l1;
        this.length2 = l2;
        this.length3 = l3;
        this.tunnelRadius = r;
        this.initialize(x, y, z, airSpaces);
    }

    private void initialize(int x, int y, int z, HashSet<Coordinate> airSpaces) {
        int dz;
        int dx;
        int d;
        for (d = 0; d < this.length1; ++d) {
            dx = x + this.direction.directionX * d;
            dz = z + this.direction.directionZ * d;
            this.generateTunnelSection(dx, y, dz, this.tunnelRadius, airSpaces);
        }
        x += this.direction.directionX * this.length1;
        z += this.direction.directionZ * this.length1;
        for (d = 0; d < this.length2; ++d) {
            dx = x + this.direction.directionX * d;
            dz = z + this.direction.directionZ * d;
            int dy = y + d * this.slope;
            this.generateTunnelSection(dx, dy, dz, this.tunnelRadius, airSpaces);
        }
        y += this.length2 * this.slope;
        x += this.direction.directionX * this.length2;
        z += this.direction.directionZ * this.length2;
        for (d = 0; d < this.length3; ++d) {
            dx = x + this.direction.directionX * d;
            dz = z + this.direction.directionZ * d;
            this.generateTunnelSection(dx, y, dz, Math.max(2, Math.round((float)this.tunnelRadius - 0.125f * (float)d)), airSpaces);
        }
        x += this.direction.directionX * this.length3;
        z += this.direction.directionZ * this.length3;
    }

    private void generateTunnelSection(int dx, int dy, int dz, int r, HashSet<Coordinate> airSpaces) {
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    BlockKey b;
                    double dd = ReikaMathLibrary.py3d((double)i, (double)j, (double)k);
                    if (!(dd <= (double)r + 0.5)) continue;
                    int ddx = dx + i;
                    int ddy = dy + j;
                    int ddz = dz + k;
                    Coordinate c = new Coordinate(ddx, ddy, ddz);
                    BlockKey blockKey = b = dd <= (double)r - 0.5 ? new BlockKey(Blocks.field_150350_a) : new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    if (this.air.contains(c) || airSpaces.contains(c)) {
                        b = new BlockKey(Blocks.field_150350_a);
                    }
                    this.blocks.put(c, b);
                    if (b.blockID != Blocks.field_150350_a) continue;
                    this.air.add(c);
                }
            }
        }
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        for (Coordinate c : this.blocks.keySet()) {
            BlockKey bk = this.blocks.get(c);
            world.setBlock(c.xCoord, c.yCoord, c.zCoord, bk.blockID, bk.metadata);
        }
    }

    public Collection<Coordinate> getAirSpaces() {
        return Collections.unmodifiableCollection(this.air);
    }

    public boolean intersectsWith(HashSet<Coordinate> space) {
        for (Coordinate c : this.air) {
            if (!space.contains(c)) continue;
            return true;
        }
        return false;
    }
}

