/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.Bridge;

import Reika.ChromatiCraft.Block.Dimension.Structure.Bridge.BlockBridgeControl;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.Bridge.BridgeNode;
import Reika.ChromatiCraft.World.Dimension.Structure.BridgeGenerator;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.UUID;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BridgeSwitch
extends BridgeNode {
    public BridgeSwitch(BridgeGenerator s) {
        super(s, 3);
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        int i;
        super.generate(world, x, y, z);
        for (i = 0; i < 4; ++i) {
            if (this.connections[i]) continue;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i + 2];
            int dx = x + dir.offsetX * this.radius + (this.radius - 1) * dir.offsetZ;
            int dz = z + dir.offsetZ * this.radius + (this.radius - 1) * dir.offsetX;
            world.setBlock(dx, y + 2, dz, Blocks.field_150478_aa, 5);
            dx = x + dir.offsetX * this.radius + (-this.radius + 1) * dir.offsetZ;
            dz = z + dir.offsetZ * this.radius + (-this.radius + 1) * dir.offsetX;
            world.setBlock(dx, y + 2, dz, Blocks.field_150478_aa, 5);
        }
        for (i = -2; i <= 2; ++i) {
            world.setBlock(x + i, y, z - 2, Blocks.field_150344_f, ReikaItemHelper.spruceWood.metadata);
            world.setBlock(x + i, y, z + 2, Blocks.field_150344_f, ReikaItemHelper.spruceWood.metadata);
            world.setBlock(x - 2, y, z + i, Blocks.field_150344_f, ReikaItemHelper.spruceWood.metadata);
            world.setBlock(x + 2, y, z + i, Blocks.field_150344_f, ReikaItemHelper.spruceWood.metadata);
        }
        for (i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                world.setBlock(x + i, y + 5, z + k, Blocks.field_150344_f);
            }
        }
        this.generateStairs(world, x - 3, y + 1, z - 3);
        this.addSwitch(world, x, y + 1, z);
    }

    private void generateStairs(ChunkSplicedGenerationCache world, int x, int y, int z) {
        world.setBlock(x + 0, y + 2, z + 0, Blocks.field_150344_f);
        world.setBlock(x + 0, y + 2, z + 6, Blocks.field_150344_f);
        world.setBlock(x + 0, y + 3, z + 0, Blocks.field_150476_ad, 2);
        world.setBlock(x + 0, y + 3, z + 1, Blocks.field_150476_ad);
        world.setBlock(x + 0, y + 3, z + 2, Blocks.field_150476_ad);
        world.setBlock(x + 0, y + 3, z + 3, Blocks.field_150476_ad);
        world.setBlock(x + 0, y + 3, z + 4, Blocks.field_150476_ad);
        world.setBlock(x + 0, y + 3, z + 5, Blocks.field_150476_ad);
        world.setBlock(x + 0, y + 3, z + 6, Blocks.field_150476_ad, 3);
        world.setBlock(x + 1, y + 3, z + 0, Blocks.field_150476_ad, 2);
        world.setBlock(x + 1, y + 3, z + 1, Blocks.field_150476_ad, 5);
        world.setBlock(x + 1, y + 3, z + 2, Blocks.field_150476_ad, 5);
        world.setBlock(x + 1, y + 3, z + 3, Blocks.field_150476_ad, 5);
        world.setBlock(x + 1, y + 3, z + 4, Blocks.field_150476_ad, 5);
        world.setBlock(x + 1, y + 3, z + 5, Blocks.field_150476_ad, 6);
        world.setBlock(x + 1, y + 3, z + 6, Blocks.field_150476_ad, 3);
        world.setBlock(x + 1, y + 4, z + 1, Blocks.field_150476_ad);
        world.setBlock(x + 1, y + 4, z + 2, Blocks.field_150476_ad);
        world.setBlock(x + 1, y + 4, z + 3, Blocks.field_150476_ad);
        world.setBlock(x + 1, y + 4, z + 4, Blocks.field_150476_ad);
        world.setBlock(x + 1, y + 4, z + 5, Blocks.field_150476_ad, 3);
        world.setBlock(x + 2, y + 0, z + 2, Blocks.field_150476_ad, 2);
        world.setBlock(x + 2, y + 0, z + 3, Blocks.field_150476_ad);
        world.setBlock(x + 2, y + 0, z + 4, Blocks.field_150476_ad);
        world.setBlock(x + 2, y + 3, z + 0, Blocks.field_150476_ad, 2);
        world.setBlock(x + 2, y + 3, z + 1, Blocks.field_150476_ad, 7);
        world.setBlock(x + 2, y + 3, z + 5, Blocks.field_150476_ad, 6);
        world.setBlock(x + 2, y + 3, z + 6, Blocks.field_150476_ad, 3);
        world.setBlock(x + 2, y + 4, z + 1, Blocks.field_150476_ad, 2);
        world.setBlock(x + 2, y + 4, z + 5, Blocks.field_150476_ad, 3);
        world.setBlock(x + 3, y + 0, z + 2, Blocks.field_150476_ad, 2);
        world.setBlock(x + 3, y + 0, z + 4, Blocks.field_150476_ad, 3);
        world.setBlock(x + 3, y + 3, z + 0, Blocks.field_150476_ad, 2);
        world.setBlock(x + 3, y + 3, z + 1, Blocks.field_150476_ad, 7);
        world.setBlock(x + 3, y + 3, z + 5, Blocks.field_150476_ad, 6);
        world.setBlock(x + 3, y + 3, z + 6, Blocks.field_150476_ad, 3);
        world.setBlock(x + 3, y + 4, z + 1, Blocks.field_150476_ad, 2);
        world.setBlock(x + 3, y + 4, z + 5, Blocks.field_150476_ad, 3);
        world.setBlock(x + 4, y + 0, z + 2, Blocks.field_150476_ad, 2);
        world.setBlock(x + 4, y + 0, z + 3, Blocks.field_150476_ad, 1);
        world.setBlock(x + 4, y + 0, z + 4, Blocks.field_150476_ad, 3);
        world.setBlock(x + 4, y + 3, z + 0, Blocks.field_150476_ad, 2);
        world.setBlock(x + 4, y + 3, z + 1, Blocks.field_150476_ad, 7);
        world.setBlock(x + 4, y + 3, z + 5, Blocks.field_150476_ad, 6);
        world.setBlock(x + 4, y + 3, z + 6, Blocks.field_150476_ad, 3);
        world.setBlock(x + 4, y + 4, z + 1, Blocks.field_150476_ad, 2);
        world.setBlock(x + 4, y + 4, z + 5, Blocks.field_150476_ad, 3);
        world.setBlock(x + 5, y + 3, z + 0, Blocks.field_150476_ad, 2);
        world.setBlock(x + 5, y + 3, z + 1, Blocks.field_150476_ad, 7);
        world.setBlock(x + 5, y + 3, z + 2, Blocks.field_150476_ad, 4);
        world.setBlock(x + 5, y + 3, z + 3, Blocks.field_150476_ad, 4);
        world.setBlock(x + 5, y + 3, z + 4, Blocks.field_150476_ad, 4);
        world.setBlock(x + 5, y + 3, z + 5, Blocks.field_150476_ad, 6);
        world.setBlock(x + 5, y + 3, z + 6, Blocks.field_150476_ad, 3);
        world.setBlock(x + 5, y + 4, z + 1, Blocks.field_150476_ad, 1);
        world.setBlock(x + 5, y + 4, z + 2, Blocks.field_150476_ad, 1);
        world.setBlock(x + 5, y + 4, z + 3, Blocks.field_150476_ad, 1);
        world.setBlock(x + 5, y + 4, z + 4, Blocks.field_150476_ad, 1);
        world.setBlock(x + 5, y + 4, z + 5, Blocks.field_150476_ad, 1);
        world.setBlock(x + 6, y + 2, z + 0, Blocks.field_150344_f);
        world.setBlock(x + 6, y + 2, z + 6, Blocks.field_150344_f);
        world.setBlock(x + 6, y + 3, z + 0, Blocks.field_150476_ad, 1);
        world.setBlock(x + 6, y + 3, z + 1, Blocks.field_150476_ad, 1);
        world.setBlock(x + 6, y + 3, z + 2, Blocks.field_150476_ad, 1);
        world.setBlock(x + 6, y + 3, z + 3, Blocks.field_150476_ad, 1);
        world.setBlock(x + 6, y + 3, z + 4, Blocks.field_150476_ad, 1);
        world.setBlock(x + 6, y + 3, z + 5, Blocks.field_150476_ad, 1);
        world.setBlock(x + 6, y + 3, z + 6, Blocks.field_150476_ad, 3);
    }

    private void addSwitch(ChunkSplicedGenerationCache world, int x, int y, int z) {
        UUID uid = UUID.randomUUID();
        world.setTileEntity(x, y, z, ChromaBlocks.BRIDGECONTROL.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new KeyCallback(((BridgeGenerator)this.parent).id, uid));
        ((BridgeGenerator)this.parent).addKey(uid);
    }

    private static class KeyCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID structure;
        private final UUID key;

        public KeyCallback(UUID s, UUID k) {
            this.structure = s;
            this.key = k;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof BlockBridgeControl.TileBridgeControl) {
                ((BlockBridgeControl.TileBridgeControl)te).setData(this.structure, this.key);
            }
        }
    }
}

