/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.DataStorage;

import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.ShiftMazeState;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMazeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class ShiftMazeData
extends StructureData {
    private final ShiftMazeGenerator gen;

    public ShiftMazeData(ShiftMazeGenerator gen) {
        super(gen);
        this.gen = gen;
    }

    @Override
    public void load(HashMap<String, Object> map) {
    }

    @Override
    public void onInteract(World world, int x, int y, int z, EntityPlayer ep, int s, HashMap<String, Object> extraData) {
        this.cycleState(world, x, y, z);
    }

    private void cycleState(World world, int x, int y, int z) {
        ShiftMazeState lastState = this.gen.getActiveState();
        this.gen.cycleState();
        ShiftMazeState newState = this.gen.getActiveState();
        for (Coordinate c : this.gen.getAllToggleDoors()) {
            if (lastState.isDoorOpen(c) && !newState.isDoorOpen(c)) {
                this.toggleDoor(world, c, false);
            }
            if (lastState.isDoorOpen(c) || !newState.isDoorOpen(c)) continue;
            this.toggleDoor(world, c, true);
        }
        ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
    }

    private void toggleDoor(World world, Coordinate c, boolean open) {
        int meta = open ? 1 : 0;
        c.setBlock(world, ChromaBlocks.SHIFTLOCK.getBlockInstance(), meta);
        c.triggerBlockUpdate(world, false);
        ReikaSoundHelper.playBreakSound((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (Block)Blocks.field_150348_b);
    }
}

