/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.Laser;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Block.Dimension.Structure.Laser.BlockLaserEffector;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.LaserPuzzleGenerator;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructureExport;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.io.IOException;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LaserLevel
extends StructurePiece<LaserPuzzleGenerator>
implements StructureExport.PlacementCallback,
StructureExport.NBTCallback {
    private final String name;
    private static final String PATH = "Structure Data/Laser";
    private StructureExport data;
    public boolean isSolved = false;
    private Coordinate doorLocation;

    public LaserLevel(LaserPuzzleGenerator s, String name) {
        super(s);
        this.data = new StructureExport(name, PATH, ChromatiCraft.class).addIgnoredBlock(new BlockKey(Blocks.field_150348_b)).addIgnoredBlock(new BlockKey(Blocks.field_150350_a));
        this.name = name;
        try {
            this.data.encryptData = true;
            this.data.load();
            BlockBox box = this.data.getBounds();
            Coordinate origin = new Coordinate(box.minX, box.minY, box.minZ).negate();
            this.data.offset(origin);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load structure data for laser level '" + name + "'", e);
        }
    }

    public int getLengthX() {
        return this.data.getBounds().getSizeX();
    }

    public int getLengthZ() {
        return this.data.getBounds().getSizeZ();
    }

    public BlockBox getBounds() {
        return this.data.getBounds();
    }

    public int getFullLengthX() {
        return this.getLengthX() + 8;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        int dz;
        int dx;
        int zp;
        int i;
        Coordinate pos = new Coordinate(x, y, z - (this.getLengthZ() + 1) / 2);
        this.data.offset(pos);
        int dr = 1;
        int w = 7;
        int w2 = w + dr;
        BlockBox def = this.data.getBounds();
        int[] r = new int[]{2, 2, 2, 3, w, w, w, w, w - 1, w - 2, w - 4, 0, -3, -5};
        for (i = 0; i < r.length; ++i) {
            int r1 = r[i] - 1;
            int r2 = r1 + dr;
            int rb = i >= 4 ? r2 : r1;
            BlockBox box = this.data.getBounds().expand(r1, 0, rb).offset(new Coordinate(0, i - 1, 0));
            for (int dx2 = def.minX - w; dx2 <= def.maxX + w; ++dx2) {
                for (int dz2 = def.minZ - w2; dz2 <= def.maxZ + w2; ++dz2) {
                    boolean wall;
                    int dy = y + i - 1;
                    boolean bl = wall = i == 0 || i == r.length - 1 || !box.isBlockInside(dx2, dy, dz2);
                    if (wall) {
                        world.setBlock(dx2, dy, dz2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                        continue;
                    }
                    world.setBlock(dx2, dy, dz2, Blocks.field_150350_a);
                }
            }
        }
        this.data.placeCallback = this;
        this.data.setExtraNBTTag("level", (Object)this.name);
        this.data.setExtraNBTTag("uid", (Object)((LaserPuzzleGenerator)this.parent).id.toString());
        this.data.addNBTOverride("dir", (StructureExport.NBTCallback)this);
        this.data.place(world);
        for (i = 3; i <= 6; ++i) {
            int dy = y + i;
            int d = i == 6 ? 1 : 2;
            for (int k = -d; k <= d; ++k) {
                world.setBlock(def.minX - w, dy, z + k, Blocks.field_150350_a);
                world.setBlock(def.maxX + w, dy, z + k, ChromaBlocks.DOOR.getBlockInstance(), BlockChromaDoor.getMetadata(false, false, false, true));
            }
        }
        this.doorLocation = new Coordinate(def.maxX + w, y + 3, z);
        int xc = x + (this.getLengthX() + 1) / 2;
        for (int dz3 = zp = z - (this.getLengthZ() + 1) / 2 - 3; dz3 >= zp - 4; --dz3) {
            int dx3;
            for (dx3 = def.minX; dx3 <= def.maxX; ++dx3) {
                world.setBlock(dx3, y + 3, dz3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            }
            for (dx3 = def.minX + 1; dx3 <= def.maxX - 1; ++dx3) {
                if (Math.abs(dx3 - xc) > 1 || dz3 != zp - 1) {
                    world.setBlock(dx3, y + 4, dz3, Blocks.field_150417_aV);
                    continue;
                }
                world.setBlock(dx3, y + 4, dz3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            }
            world.setBlock(def.minX - 1, y + 3, dz3, Blocks.field_150390_bg, 0);
            world.setBlock(def.maxX + 1, y + 3, dz3, Blocks.field_150390_bg, 1);
            world.setBlock(def.minX, y + 4, dz3, Blocks.field_150390_bg, 0);
            world.setBlock(def.maxX, y + 4, dz3, Blocks.field_150390_bg, 1);
        }
        for (dx = def.minX - 1; dx <= def.maxX + 1; ++dx) {
            for (int i2 = 3; i2 <= 4; ++i2) {
                int dz4 = zp;
                int dy = y + i2;
                world.setBlock(dx, dy, dz4, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                if (Math.abs(dx - xc) > 2) {
                    world.setBlock(dx, dy, dz4 - 4, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    continue;
                }
                world.setBlock(dx, dy, dz4 - 4, Blocks.field_150417_aV);
            }
        }
        ((LaserPuzzleGenerator)this.parent).generateDataTile(xc, y + 4, zp, "level", this.name);
        world.setBlock(xc, y + 3, zp, ChromaBlocks.LIGHTPANEL.getBlockInstance(), 1);
        ((LaserPuzzleGenerator)this.parent).generatePasswordTile(xc, y + 2, zp);
        for (dx = def.minX - w + 1; dx <= def.maxX + w - 1; ++dx) {
            for (dz = def.minZ - w2 + 2; dz <= def.maxZ + w2 - 2; ++dz) {
                if (dx == def.minX - w || dx == def.maxX + w || dz == def.minZ - w2 || dz == def.maxZ + w2) continue;
                boolean flag = false;
                if (dx > def.minX - w + 1 && dx < def.maxX + w - 1) {
                    if (dx > def.maxX + 3 || dx < def.minX - 3) {
                        flag = true;
                    }
                    if (dz > def.maxZ + 3 || dz < def.minZ - 3) {
                        flag = true;
                    }
                }
                if (Math.abs(dz - z) <= 1 && (dx == def.minX - w + 1 || dx == def.maxX + w - 1)) {
                    flag = true;
                }
                if (!flag) continue;
                world.setBlock(dx, y + 2, dz, Blocks.field_150417_aV);
            }
        }
        for (dx = def.minX + 1; dx <= def.maxX - 1; ++dx) {
            dz = def.maxZ + 2;
            world.setBlock(dx, y + 1, dz, Blocks.field_150350_a);
        }
        world.setBlock(def.minX - 2, y + 1, def.minZ - 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.maxX + 2, y + 1, def.minZ - 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.minX - 2, y + 1, def.maxZ + 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.maxX + 2, y + 1, def.maxZ + 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.minX - 5, y + 2, z, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.maxX + 5, y + 2, z, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(xc, y + 2, def.maxZ + 5, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.minX - w, y + 4, def.maxZ + w2 - 3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.minX - w, y + 5, def.maxZ + w2 - 5, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.maxX + w, y + 4, def.maxZ + w2 - 3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.maxX + w, y + 5, def.maxZ + w2 - 5, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.minX - w, y + 4, def.minZ - w2 + 3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.minX - w, y + 5, def.minZ - w2 + 5, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.maxX + w, y + 4, def.minZ - w2 + 3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.maxX + w, y + 5, def.minZ - w2 + 5, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.minX - w + 2, y + 4, def.maxZ + w2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.minX - w + 4, y + 5, def.maxZ + w2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.maxX + w - 2, y + 4, def.maxZ + w2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.maxX + w - 4, y + 5, def.maxZ + w2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.minX - w + 7, y + 5, def.minZ - w2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(def.maxX + w - 7, y + 5, def.minZ - w2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(xc + 1, y + 4, zp - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(xc - 1, y + 4, zp - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(xc + 1, y + 11, z, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(xc, y + 11, z, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
        world.setBlock(xc - 1, y + 11, z, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
    }

    public void onPlace(Coordinate c, BlockKey bk, NBTTagCompound data) {
        if (bk.blockID == ChromaBlocks.LASEREFFECT.getBlockInstance()) {
            if (bk.metadata == BlockLaserEffector.LaserEffectType.EMITTER.ordinal()) {
                ((LaserPuzzleGenerator)this.parent).addEmitter(this.name, c);
            } else if (bk.metadata == BlockLaserEffector.LaserEffectType.TARGET.ordinal() || bk.metadata == BlockLaserEffector.LaserEffectType.TARGET_THRU.ordinal()) {
                ((LaserPuzzleGenerator)this.parent).addTarget(this.name, c);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public NBTBase getOverriddenValue(Coordinate c, BlockKey bk, String key, NBTBase original, NBTTagCompound data) {
        if (key.equals("dir") && !data.func_74767_n("fixed") && !BlockLaserEffector.LaserEffectType.list[bk.metadata].isOmniDirectional() && bk.metadata != BlockLaserEffector.LaserEffectType.EMITTER.ordinal() && bk.metadata != BlockLaserEffector.LaserEffectType.TARGET.ordinal() && bk.metadata != BlockLaserEffector.LaserEffectType.TARGET_THRU.ordinal()) {
            int dir = ReikaRandomHelper.getSafeRandomInt((int)ReikaDirectionHelper.CubeDirections.list.length);
            return new NBTTagInt(dir);
        }
        return original;
    }

    public void applyDoorState(World world) {
        BlockChromaDoor.TileEntityChromaDoor te = (BlockChromaDoor.TileEntityChromaDoor)this.doorLocation.getTileEntity((IBlockAccess)world);
        if (te == null) {
            ChromatiCraft.logger.log((Object)("No door for laser puzzle room " + this.name + " @ " + this.doorLocation + "?"));
            return;
        }
        if (this.isSolved) {
            te.open(0);
        } else {
            te.close();
        }
    }
}

