/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Block.Dimension.Structure.Laser.BlockLaserEffector;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Entity.EntityLaserPulse;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.Dimension.Structure.Laser.LaserEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.Laser.LaserLevel;
import Reika.ChromatiCraft.World.Dimension.Structure.Laser.LaserLoot;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LaserPuzzleGenerator
extends DimensionStructureGenerator {
    private static final ArrayList<String> order = new ArrayList();
    private final HashMap<String, LaserPuzzleStatus> rooms = new HashMap();

    @Override
    protected void calculate(int chunkX, int chunkZ, Random rand) {
        int y;
        int x = chunkX + 13;
        int z = chunkZ;
        this.posY = y = 10 + rand.nextInt(70);
        for (String s : order) {
            LaserLevel l = new LaserLevel(this, s);
            this.rooms.put(s, new LaserPuzzleStatus(l));
            l.generate(this.world, x, y, z);
            int dx = x + l.getFullLengthX();
            int dx2 = dx + 8;
            if (!s.equals("complex")) {
                for (int ddx = dx; ddx < dx2; ++ddx) {
                    for (int dy = y + 2; dy <= y + 7; ++dy) {
                        int w = dy >= y + 6 ? 2 : 3;
                        for (int d = -w; d <= w; ++d) {
                            boolean wall;
                            int dz = z + d;
                            boolean bl = wall = dy == y + 2 || dy == y + 7 || Math.abs(d) == w;
                            if (wall) {
                                this.world.setBlock(ddx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                                continue;
                            }
                            this.world.setBlock(ddx, dy, dz, Blocks.field_150350_a);
                        }
                    }
                }
            } else {
                new LaserLoot(this).generate(this.world, dx, y, z);
            }
            x = dx2 + 7;
        }
        this.addDynamicStructure(new LaserEntrance(this), chunkX, chunkZ);
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    public boolean hasBeenSolved(World world) {
        for (LaserPuzzleStatus l : this.rooms.values()) {
            if (((LaserPuzzleStatus)l).puzzle.isSolved) continue;
            return false;
        }
        return true;
    }

    @Override
    public void openStructure(World world) {
        for (LaserPuzzleStatus l : this.rooms.values()) {
            ((LaserPuzzleStatus)l).puzzle.isSolved = true;
            l.puzzle.applyDoorState(world);
        }
    }

    @Override
    public StructureData createDataStorage() {
        return new LaserPuzzleData(this);
    }

    @Override
    protected void clearCaches() {
        this.rooms.clear();
    }

    public void addEmitter(String name, Coordinate c) {
        this.rooms.get(name).emitters.add(c);
    }

    public void addTarget(String name, Coordinate c) {
        this.rooms.get(name).targets.add(c);
    }

    public boolean areLasersInPlay(String level) {
        return this.rooms.get(level).laserStatus;
    }

    public void completeTrigger(String level, World world, Coordinate c, boolean complete) {
        LaserPuzzleStatus l = this.rooms.get(level);
        if (complete) {
            l.activeTargets.add(c);
        } else {
            l.activeTargets.remove(c);
        }
        l.checkCompletion(world);
    }

    static {
        int d = ChromaOptions.getStructureDifficulty();
        order.add("mirrortut");
        order.add("mirrors2");
        order.add("refractortut");
        order.add("splittertut");
        if (d > 1) {
            order.add("filtertut");
            order.add("polartut");
            order.add("polar2");
            order.add("oneway");
        }
        order.add("prismtut1");
        order.add("prismtut2");
        if (d > 2) {
            order.add("prism3");
            order.add("complex");
        }
    }

    private static class LaserPuzzleData
    extends StructureData {
        private String level;
        private long lastClickTime = -1L;

        private LaserPuzzleData(LaserPuzzleGenerator g) {
            super(g);
        }

        @Override
        public void load(HashMap<String, Object> map) {
            this.level = (String)map.get("level");
        }

        @Override
        public void onInteract(World world, int x, int y, int z, EntityPlayer ep, int s, HashMap<String, Object> extraData) {
            long time;
            if (this.level.equals(extraData.get("level")) && (time = world.func_82737_E()) - this.lastClickTime >= 5L) {
                Object te;
                this.lastClickTime = time;
                LaserPuzzleGenerator gen = (LaserPuzzleGenerator)this.generator;
                LaserPuzzleStatus l = (LaserPuzzleStatus)gen.rooms.get(this.level);
                l.activeTargets.clear();
                ((LaserPuzzleStatus)l).puzzle.isSolved = false;
                boolean on = gen.areLasersInPlay(this.level);
                for (Coordinate c : l.targets) {
                    te = c.getTileEntity((IBlockAccess)world);
                    if (!(te instanceof BlockLaserEffector.TargetTile)) continue;
                    ((BlockLaserEffector.TargetTile)((Object)te)).trigger(false, false, on);
                }
                if (on) {
                    l.laserStatus = false;
                    world.func_72921_c(x, y - 1, z, 1, 3);
                    AxisAlignedBB box = l.puzzle.getBounds().asAABB();
                    List li = world.func_72872_a(EntityLaserPulse.class, box);
                    for (EntityLaserPulse e : li) {
                        e.func_70076_C();
                    }
                } else {
                    for (Coordinate c : l.emitters) {
                        te = c.getTileEntity((IBlockAccess)world);
                        if (!(te instanceof BlockLaserEffector.LaserEffectTile)) continue;
                        ((BlockLaserEffector.LaserEffectTile)((Object)te)).fire();
                    }
                    l.laserStatus = true;
                    world.func_72921_c(x, y - 1, z, 3, 3);
                }
            }
        }
    }

    private static class LaserPuzzleStatus {
        private final LaserLevel puzzle;
        private final HashSet<Coordinate> emitters = new HashSet();
        private final HashSet<Coordinate> targets = new HashSet();
        private final HashSet<Coordinate> activeTargets = new HashSet();
        private boolean laserStatus = false;

        private LaserPuzzleStatus(LaserLevel p) {
            this.puzzle = p;
        }

        private void checkCompletion(World world) {
            this.puzzle.isSolved = this.targets.equals(this.activeTargets);
            this.puzzle.applyDoorState(world);
            if (this.puzzle.isSolved) {
                AxisAlignedBB box = this.puzzle.getBounds().asAABB();
                List li = world.func_72872_a(EntityLaserPulse.class, box);
                for (EntityLaserPulse e : li) {
                    e.func_70076_C();
                }
            }
        }
    }
}

