/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.LightPanel;

import Reika.ChromatiCraft.World.Dimension.Structure.LightPanel.LightType;
import java.util.Arrays;

public class LightGroup {
    private final boolean[][] lights;
    private boolean isEmpty = true;

    public LightGroup(int rows) {
        this.lights = new boolean[rows][LightType.list.length];
    }

    public void addLight(int row, LightType light) {
        this.lights[row][light.ordinal()] = true;
        this.isEmpty = false;
    }

    public boolean containsLight(int row, LightType light) {
        return this.lights[row][light.ordinal()];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.lights.length; ++i) {
            sb.append(Arrays.toString(this.lights[i]));
            sb.append("\n");
        }
        return sb.toString();
    }

    public LightGroup copy() {
        LightGroup lg = new LightGroup(this.lights.length);
        for (int i = 0; i < lg.lights.length; ++i) {
            lg.lights[i] = Arrays.copyOf(this.lights[i], this.lights[i].length);
        }
        lg.isEmpty = this.isEmpty;
        return lg;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }
}

