/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.LightPanel;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Block.Dimension.Structure.LightPanel.BlockLightPanel;
import Reika.ChromatiCraft.Block.Dimension.Structure.LightPanel.BlockLightSwitch;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanel.LightGroup;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanel.LightType;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanelGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LightPanelRoom
extends StructurePiece<LightPanelGenerator> {
    public static final int DEPTH = 18;
    public final int rowCount;
    public final int switchCount;
    public final int level;
    private LightState[] switches;
    private final Light[][] lights;
    private final ReikaMusicHelper.MusicKey[] pitches;
    private final ReikaMusicHelper.KeySignature key;
    private final List<ReikaMusicHelper.MusicKey> usablePitches = new ArrayList<ReikaMusicHelper.MusicKey>();
    private Coordinate doorLocation;
    private boolean lastState;
    private final Random rand;

    public LightPanelRoom(LightPanelGenerator s, int r, int sw, int lvl, Random rand, int posX, int posY, int posZ) {
        super(s);
        this.rowCount = r;
        this.switchCount = sw;
        this.level = lvl;
        this.rand = rand;
        this.lights = new Light[this.rowCount][LightType.list.length];
        for (int i = 0; i < this.rowCount; ++i) {
            for (int k = 0; k < LightType.list.length; ++k) {
                this.lights[i][k] = new Light();
            }
        }
        this.pitches = new ReikaMusicHelper.MusicKey[this.switchCount];
        this.key = ReikaMusicHelper.KeySignature.keys[rand.nextInt(ReikaMusicHelper.KeySignature.keys.length)];
        for (ReikaMusicHelper.Note n : this.key.getScale()) {
            this.usablePitches.add(ReikaMusicHelper.MusicKey.C5.getInterval(n.ordinal()));
        }
        this.usablePitches.add(ReikaMusicHelper.MusicKey.C6);
    }

    public final void generatePuzzle() {
        do {
            this.generateConnections();
        } while (!this.isSolvable());
    }

    private void generateConnections() {
        int i;
        this.switches = new LightState[this.switchCount];
        for (i = 0; i < this.rowCount; ++i) {
            for (int k = 0; k < LightType.list.length; ++k) {
                this.lights[i][k].linkedSwitches.clear();
            }
        }
        for (i = 0; i < this.switches.length; ++i) {
            LightGroup lg = new LightGroup(this.rowCount);
            this.switches[i] = new LightState(lg);
        }
        this.doGenerateConnections();
    }

    protected void doGenerateConnections() {
        int sw;
        int idx;
        int i;
        int[] greenDistrib = new int[this.switches.length];
        int[] redDistrib = new int[this.switches.length];
        int[] blueDistrib = new int[this.switches.length];
        int maxCollect = Math.max(1, 2 * this.rowCount / this.switchCount);
        for (int i2 = 0; i2 < this.rowCount; ++i2) {
            int n = this.rand.nextInt(4) == 0 ? 2 : 1;
            for (int m = 0; m < n; ++m) {
                int sw2 = this.rand.nextInt(this.switchCount);
                while (greenDistrib[sw2] > maxCollect) {
                    sw2 = this.rand.nextInt(this.switchCount);
                }
                this.addConnection(sw2, i2, LightType.TARGET);
                int n2 = sw2;
                greenDistrib[n2] = greenDistrib[n2] + 1;
            }
        }
        ArrayList<Integer> reds = new ArrayList<Integer>();
        int nred = Math.max(2, Math.min(this.rowCount - 1, this.rowCount / 2 + ReikaRandomHelper.getRandomPlusMinus((int)0, (int)2)));
        int nredleft = Math.max(1, this.rand.nextInt(nred / 2));
        int nblue = nred - nredleft;
        for (i = 0; i < nred; ++i) {
            idx = this.rand.nextInt(this.switchCount);
            while (reds.contains(idx)) {
                idx = this.rand.nextInt(this.switchCount);
            }
            reds.add(idx);
            sw = this.rand.nextInt(this.switchCount);
            while (redDistrib[sw] > maxCollect) {
                sw = this.rand.nextInt(this.switchCount);
            }
            this.addConnection(sw, idx, LightType.BLOCK);
            int n = sw;
            redDistrib[n] = redDistrib[n] + 1;
        }
        for (i = 0; i < nblue; ++i) {
            idx = (Integer)reds.remove(this.rand.nextInt(reds.size()));
            sw = this.rand.nextInt(this.switchCount);
            while (blueDistrib[sw] > maxCollect) {
                sw = this.rand.nextInt(this.switchCount);
            }
            this.addConnection(sw, idx, LightType.CANCEL);
            int n = sw;
            blueDistrib[n] = blueDistrib[n] + 1;
        }
    }

    protected final void addConnection(int sw, int row, LightType type) {
        this.switches[sw].group.addLight(row, type);
        this.lights[row][type.ordinal()].linkedSwitches.add(sw);
        if (this.pitches[sw] == null) {
            this.addPitch(sw);
        }
    }

    private void addPitch(int sw) {
        int idx = this.rand.nextInt(this.usablePitches.size());
        ReikaMusicHelper.MusicKey key = this.usablePitches.get(idx);
        this.usablePitches.remove(idx);
        this.pitches[sw] = key;
    }

    protected boolean isSolvable() {
        ArrayList<boolean[]> li = this.getCombosThatLightAllGreen();
        for (boolean[] state : li) {
            for (int k = 0; k < this.switches.length; ++k) {
                this.switches[k].active = state[k];
            }
            if (!this.isComplete()) continue;
            this.reset();
            return true;
        }
        this.reset();
        return false;
    }

    protected final ArrayList<boolean[]> getCombosThatLightAllGreen() {
        ArrayList<Object> li = new ArrayList<boolean[]>();
        li.add(new boolean[this.switchCount]);
        for (int i = 0; i < this.rowCount; ++i) {
            Light l = this.lights[i][LightType.TARGET.ordinal()];
            ArrayList<boolean[]> repl = new ArrayList<boolean[]>();
            Iterator iterator = l.linkedSwitches.iterator();
            while (iterator.hasNext()) {
                int sw = (Integer)iterator.next();
                for (boolean[] blArray : li) {
                    boolean[] state = Arrays.copyOf(blArray, blArray.length);
                    state[sw] = true;
                    repl.add(state);
                }
            }
            li = repl;
        }
        return li;
    }

    private void reset() {
        for (int k = 0; k < this.switches.length; ++k) {
            this.switches[k].active = false;
        }
    }

    public final void toggleSwitch(World world, int x, int y, int z, int sw, boolean active) {
        this.switches[sw].active = active;
        this.updateLights(world);
        if (active) {
            ChromaSounds.DING.playSoundAtBlock(world, x, y, z, 2.0f, (float)CrystalMusicManager.instance.getPitchFactor(this.pitches[sw]));
        }
    }

    public final int getWidth() {
        return (this.switchCount + this.switchCount - 1) / 2 + 3;
    }

    public final int getHeight() {
        return this.rowCount + 4 + 2 + 1;
    }

    private void updateLights(World world) {
        for (int i = 0; i < this.rowCount; ++i) {
            for (int k = 0; k < LightType.list.length; ++k) {
                boolean flag = false;
                for (int n = 0; n < this.switchCount; ++n) {
                    if (!this.switches[n].active || !this.switches[n].group.containsLight(i, LightType.list[k])) continue;
                    flag = true;
                    break;
                }
                this.lights[i][k].state = flag;
                BlockLightPanel.activate(world, ((Light)this.lights[i][k]).location.xCoord, ((Light)this.lights[i][k]).location.yCoord, ((Light)this.lights[i][k]).location.zCoord, flag);
            }
        }
        boolean flag = this.isComplete();
        if (flag != this.lastState) {
            this.updateDoor(world, flag);
        }
        this.lastState = flag;
    }

    public void updateDoor(World world, boolean open) {
        if (this.doorLocation != null) {
            TileEntity te = this.doorLocation.getTileEntity((IBlockAccess)world);
            BlockChromaDoor.TileEntityChromaDoor td = (BlockChromaDoor.TileEntityChromaDoor)te;
            if (open) {
                td.open(0);
            } else {
                td.close();
            }
        }
    }

    @Override
    public final void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        int dz;
        int k;
        int dy;
        int k2;
        int i;
        int i2;
        int r = this.getWidth();
        for (int k3 = -r; k3 <= r; ++k3) {
            int dz2 = z + k3;
            for (i2 = 0; i2 <= 18; ++i2) {
                int dx = x + i2;
                int h = this.getHeight();
                for (int j = 0; j <= h; ++j) {
                    if (i2 == 0 || i2 == 18 || k3 == -r || k3 == r || j == 0 || j == h) {
                        world.setBlock(dx, y + j, dz2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                        continue;
                    }
                    world.setBlock(dx, y + j, dz2, Blocks.field_150350_a);
                }
            }
        }
        int dx = x + 12;
        for (i = -this.getWidth(); i <= this.getWidth(); ++i) {
            for (k2 = 1; k2 < this.getHeight(); ++k2) {
                world.setBlock(dx, y + k2, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            }
        }
        for (i = 0; i < this.rowCount; ++i) {
            dy = y + 1 + 4 + 1 + i;
            for (int l = 0; l < LightType.list.length; ++l) {
                int dz3 = z - LightType.list.length + l * 2 + 1;
                this.placeLight(world, dx, dy, dz3, i, LightType.list[l]);
                world.setBlock(dx, dy, dz3 + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
            }
        }
        for (i = -1; i <= this.rowCount; ++i) {
            dy = y + 1 + 1 + i + 4;
            world.setBlock(dx, dy, z - 3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
            world.setBlock(dx, dy, z - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
            world.setBlock(dx, dy, z + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
            world.setBlock(dx, dy, z + 3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
            world.setBlock(dx, dy, z - LightType.list.length - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            world.setBlock(dx, dy, z + LightType.list.length + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
        }
        for (i = -this.getWidth(); i <= this.getWidth(); ++i) {
            for (k2 = 1; k2 <= 4; ++k2) {
                world.setBlock(dx, y + k2, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            }
            if (Math.abs(i) >= Math.abs(LightType.list.length * 2 - 1)) continue;
            int mb = Math.abs(i) == Math.abs(LightType.list.length * 2 - 1) - 1 ? BlockStructureShield.BlockType.STONE.metadata : BlockStructureShield.BlockType.CLOAK.metadata;
            world.setBlock(dx, y + 1 + 4, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), mb);
            world.setBlock(dx, y + 1 + 4 + this.rowCount + 1, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), mb);
        }
        for (i = -2; i <= 2; ++i) {
            for (k2 = 1; k2 <= 3; ++k2) {
                world.setBlock(dx, y + k2, z + i, ChromaBlocks.DOOR.getBlockInstance(), BlockChromaDoor.getMetadata(false, false, false, true));
            }
        }
        this.doorLocation = new Coordinate(dx, y + 1, z);
        dx = x + 6;
        for (k = 0; k < this.switchCount; ++k) {
            dy = y + 1;
            dz = z - this.switchCount * 2 / 2 + k * 2 + 1;
            world.setBlock(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            world.setBlock(dx, dy + 1, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            if (k == this.switchCount - 1) continue;
            world.setBlock(dx, dy, dz + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            world.setBlock(dx, dy + 1, dz + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.GLASS.metadata);
        }
        for (k = 0; k < this.switchCount; ++k) {
            dy = y + 1 + 1;
            dz = z - this.switchCount * 2 / 2 + k * 2 + 1;
            this.placeSwitch(world, dx, dy, dz, k);
        }
        if (this.level == 0) {
            ((LightPanelGenerator)this.parent).generatePasswordTile(dx - 5, y + 1, z);
        }
        for (i = -2; i <= 2; ++i) {
            for (k2 = 1; k2 <= 3; ++k2) {
                world.setBlock(x, y + k2, z + i, Blocks.field_150350_a);
                world.setBlock(x + 18, y + k2, z + i, Blocks.field_150350_a);
            }
        }
        world.setBlock(x, y + 4, z + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(x, y + 4, z - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(x, y + 2, z - 3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(x, y + 2, z + 3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        for (k = -this.getWidth(); k <= this.getWidth(); ++k) {
            for (i2 = 13; i2 <= 18; ++i2) {
                int j = 5;
                if (Math.abs(k) >= this.getWidth() - 1) {
                    j = 3;
                } else if (Math.abs(k) >= this.getWidth() - 3) {
                    j = 4;
                }
                world.setBlock(x + i2, y + 1 + j, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            }
        }
        Object[] items = new Object[]{ChromaStacks.lumaDust, 70, ChromaStacks.chargedBlueShard, 90, ChromaStacks.lumenGem, 50, ChromaStacks.glowChunk, 10};
        ((LightPanelGenerator)this.parent).generateLootChest(x + 18 - 3, y + 1, z - this.getWidth() + 1, ForgeDirection.SOUTH, "strongholdCorridor", 0, items);
        ((LightPanelGenerator)this.parent).generateLootChest(x + 18 - 3, y + 1, z + this.getWidth() - 1, ForgeDirection.NORTH, "strongholdCorridor", 0, items);
        world.setBlock(x + 18 - 3, y, z - this.getWidth() + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(x + 18 - 3, y, z + this.getWidth() - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
    }

    private void placeSwitch(ChunkSplicedGenerationCache world, int x, int y, int z, int sw) {
        world.setTileEntity(x, y, z, ChromaBlocks.PANELSWITCH.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new SwitchCallback(((LightPanelGenerator)this.parent).id, this.level, sw));
    }

    private void placeLight(ChunkSplicedGenerationCache world, int x, int y, int z, int row, LightType type) {
        Coordinate c = new Coordinate(x, y, z);
        this.lights[row][type.ordinal()].location = c;
        world.setBlock(x, y, z, ChromaBlocks.LIGHTPANEL.getBlockInstance(), type.ordinal() * 2);
    }

    public final boolean isComplete() {
        for (int i = 0; i < this.rowCount; ++i) {
            if (!this.lights[i][LightType.TARGET.ordinal()].state) {
                return false;
            }
            if (!this.lights[i][LightType.BLOCK.ordinal()].state || this.lights[i][LightType.CANCEL.ordinal()].state) continue;
            return false;
        }
        return true;
    }

    private static class SwitchCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID uid;
        private final int level;
        private final int channel;

        private SwitchCallback(UUID id, int lvl, int ch) {
            this.uid = id;
            this.level = lvl;
            this.channel = ch;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof BlockLightSwitch.LightSwitchTile) {
                ((BlockLightSwitch.LightSwitchTile)te).setData(this.level, this.channel);
                ((BlockLightSwitch.LightSwitchTile)te).uid = this.uid;
            }
        }
    }

    protected static class Light {
        private Coordinate location;
        private final HashSet<Integer> linkedSwitches = new HashSet();
        private boolean state;

        private Light() {
        }

        public String toString() {
            return String.valueOf(this.state);
        }
    }

    protected static class LightState {
        private final LightGroup group;
        private boolean active;

        private LightState(LightGroup lg) {
            this.group = lg;
        }

        public String toString() {
            return this.group.toString();
        }
    }
}

