/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanel.FixedLightPanelRoom;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanel.FixedLightPattern;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanel.LightPanelEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanel.LightPanelLoot;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanel.LightPanelRoom;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanel.LightType;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import cpw.mods.fml.common.FMLCommonHandler;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.world.World;

public class LightPanelGenerator
extends DimensionStructureGenerator {
    private static final int[] ROW_COUNTS = new int[]{3, 4, 6, 6, 8, 8, 10, 10, 12, 12, 14, 16};
    private static final int[] SWITCH_COUNTS = new int[]{3, 3, 4, 4, 5, 6, 6, 8, 8, 8, 10, 10};
    private static final int[] PATTERN_TIERS = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6};
    private static final int[][] PREFAB_SIZES = new int[][]{{3, 3}, {4, 4}, {4, 6}, {4, 8}, {5, 8}, {6, 10}, {8, 12}};
    private static final String PATH = "Structure Data/LightPanel";
    private static final ArrayList<FixedLightPattern>[] usablePatterns = new ArrayList[7];
    private final ArrayList<FixedLightPattern>[] patterns = new ArrayList[7];
    private LightPanelRoom[] levels;

    private static void loadData(int tier) throws Exception {
        int nsw = PREFAB_SIZES[tier][0];
        int nrw = PREFAB_SIZES[tier][1];
        int x1 = 1;
        int y1 = 1;
        int sx = LightType.list.length * nsw + nsw + 1 + 1;
        int sy = nrw + 2 + 1;
        try (InputStream in = ChromatiCraft.class.getResourceAsStream("Structure Data/LightPanel/tier" + tier + ".png");){
            BufferedImage img = ImageIO.read(in);
            int by = y1;
            for (int bx = x1; bx < img.getWidth(); bx += sx) {
                FixedLightPattern p = new FixedLightPattern(tier, nrw, nsw);
                for (int k = 0; k < nsw; ++k) {
                    for (int i = 0; i < nrw; ++i) {
                        for (int l = 0; l < LightType.list.length; ++l) {
                            LightType type = LightType.list[l];
                            int x = bx + 1 + l + k * (LightType.list.length + 1);
                            int y = by + 1 + i;
                            int rgb = img.getRGB(x, y);
                            int value = ReikaMathLibrary.clipLeadingHexBits((int)(rgb & type.renderColor));
                            if (value != 255) continue;
                            p.connect(k, i, type);
                        }
                    }
                }
                if (p.isEmpty()) continue;
                usablePatterns[tier].add(p);
            }
        }
        if (usablePatterns[tier].isEmpty()) {
            throw new IllegalStateException("This puzzle is unsolvable, as there are no valid patterns for tier " + tier + "!");
        }
    }

    @Override
    protected void calculate(int chunkX, int chunkZ, Random rand) {
        for (int i = 0; i < this.patterns.length; ++i) {
            this.patterns[i] = new ArrayList<FixedLightPattern>(usablePatterns[i]);
        }
        this.posY = 20 + rand.nextInt(80);
        int x = chunkX;
        int z = chunkZ;
        this.addDynamicStructure(new LightPanelEntrance(this), x, z);
        x += 11;
        int size = LightPanelGenerator.getSize();
        this.levels = new LightPanelRoom[size];
        for (int i = 0; i < this.levels.length; ++i) {
            FixedLightPattern p = this.getPattern(i, rand);
            int r = p.rowCount;
            int s = p.switchCount;
            FixedLightPanelRoom lpr = new FixedLightPanelRoom(this, r, s, i, rand, x, this.posY, z, p);
            lpr.generatePuzzle();
            this.levels[i] = lpr;
            lpr.generate(this.world, x, this.posY, z);
            x += 19;
        }
        new LightPanelLoot(this).generate(this.world, x += 10, this.posY, z);
    }

    private FixedLightPattern getPattern(int level, Random rand) {
        int tier = PATTERN_TIERS[level];
        int idx = rand.nextInt(this.patterns[tier].size());
        FixedLightPattern p = this.patterns[tier].get(idx);
        if (this.patterns[tier].size() > 1) {
            this.patterns[tier].remove(idx);
        }
        return p;
    }

    private static int getSize() {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return 5;
            }
            case 2: {
                return 8;
            }
        }
        return 12;
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    public boolean hasBeenSolved(World world) {
        for (int i = 0; i < this.levels.length; ++i) {
            if (this.levels[i].isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void openStructure(World world) {
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i].updateDoor(world, true);
        }
    }

    public void toggleSwitch(World world, int x, int y, int z, int level, int channel, boolean active) {
        this.levels[level].toggleSwitch(world, x, y, z, channel, active);
    }

    @Override
    protected void clearCaches() {
        this.levels = null;
    }

    static {
        for (int i = 0; i < usablePatterns.length; ++i) {
            LightPanelGenerator.usablePatterns[i] = new ArrayList();
            try {
                LightPanelGenerator.loadData(i);
                continue;
            }
            catch (Exception e) {
                FMLCommonHandler.instance().raiseException((Throwable)e, "Error initializing Light Panel Puzzle", true);
            }
        }
    }
}

