/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.Locks;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.BlockHoverBlock;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.LocksGenerator;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class LockRoomConnector
extends StructurePiece<LocksGenerator> {
    private final int[] length;
    private boolean window;
    private int openFloor;
    private boolean openCeiling;
    private boolean forceLoot;

    public LockRoomConnector(LocksGenerator s, int[] len) {
        super(s);
        this.length = len;
    }

    public LockRoomConnector(LocksGenerator s, int lenn, int lens, int lenw, int lene) {
        this(s, new int[]{lenn, lens, lenw, lene});
    }

    public LockRoomConnector setLength(ForgeDirection dir, int len) {
        this.length[dir.ordinal() - 2] = len;
        return this;
    }

    public LockRoomConnector setWindowed() {
        this.window = true;
        return this;
    }

    public LockRoomConnector setOpenFloor(int depth) {
        this.openFloor = depth;
        return this;
    }

    public LockRoomConnector setOpenCeiling() {
        this.openCeiling = true;
        return this;
    }

    public LockRoomConnector forceLoot() {
        this.forceLoot = true;
        return this;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        int dz;
        int dz2;
        int i;
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        int ms = BlockStructureShield.BlockType.STONE.metadata;
        int ml = BlockStructureShield.BlockType.LIGHT.metadata;
        int mg = BlockStructureShield.BlockType.GLASS.metadata;
        int r = 2;
        for (i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                int dx = x + i;
                dz2 = z + k;
                world.setBlock(dx, y, dz2, b, ms);
                world.setBlock(dx, y + 5, dz2, b, ms);
                for (int h = 1; h <= 4; ++h) {
                    world.setBlock(dx, y + h, dz2, Blocks.field_150350_a);
                }
            }
        }
        world.setBlock(x - 2, y, z - 2, b, ml);
        world.setBlock(x + 2, y, z - 2, b, ml);
        world.setBlock(x - 2, y, z + 2, b, ml);
        world.setBlock(x + 2, y, z + 2, b, ml);
        if (this.forceLoot || !this.openCeiling && this.openFloor == 0) {
            if (ReikaRandomHelper.doWithChance((double)25.0)) {
                ((LocksGenerator)this.parent).generateLootChest(x - 2, y + 1, z, ForgeDirection.EAST, "pyramidJungleChest", 0, ChromaStacks.iridChunk.func_77946_l(), 10, ChromaStacks.avolite.func_77946_l(), 50);
            } else {
                ((LocksGenerator)this.parent).generateLootChest(x - 2, y + 1, z, ForgeDirection.EAST, "pyramidJungleChest", 0, new Object[0]);
            }
        }
        for (int k = 2; k < 6; ++k) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[k];
            ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
            int len = this.length[k - 2];
            if (len > 0) {
                for (int i2 = 3; i2 < len + 3; ++i2) {
                    int dx = x + dir.offsetX * i2;
                    int dz3 = z + dir.offsetZ * i2;
                    for (int w = -2; w <= 2; ++w) {
                        int dx2 = dx + w * left.offsetX;
                        int dz22 = dz3 + w * left.offsetZ;
                        world.setBlock(dx2, y, dz22, b, ms);
                        world.setBlock(dx2, y + 4, dz22, b, ms);
                    }
                    for (int h = 1; h <= 3; ++h) {
                        world.setBlock(dx + 2 * left.offsetX, y + h, dz3 + 2 * left.offsetZ, b, ms);
                        world.setBlock(dx - 2 * left.offsetX, y + h, dz3 - 2 * left.offsetZ, b, ms);
                        world.setBlock(dx, y + h, dz3, Blocks.field_150350_a);
                        world.setBlock(dx + 1 * left.offsetX, y + h, dz3 + 1 * left.offsetZ, Blocks.field_150350_a);
                        world.setBlock(dx - 1 * left.offsetX, y + h, dz3 - 1 * left.offsetZ, Blocks.field_150350_a);
                    }
                }
                continue;
            }
            int dx = x + dir.offsetX * 3;
            dz = z + dir.offsetZ * 3;
            for (int w = -2; w <= 2; ++w) {
                int dx2 = dx + w * left.offsetX;
                int dz23 = dz + w * left.offsetZ;
                for (int h = 0; h <= 4; ++h) {
                    world.setBlock(dx2, y + h, dz23, b, ms);
                }
            }
        }
        if (this.window || this.openCeiling) {
            for (i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    int dx = x + i;
                    dz2 = z + k;
                    world.setBlock(dx, y + 5, dz2, this.window ? b : Blocks.field_150350_a, this.window ? mg : 0);
                }
            }
        }
        if (this.openFloor > 0) {
            for (int j = 1; j < this.openFloor; ++j) {
                for (int i3 = -2; i3 <= 2; ++i3) {
                    for (int k = -2; k <= 2; ++k) {
                        int dx = x + i3;
                        int dy = y - j;
                        dz = z + k;
                        boolean air = Math.abs(i3) <= 1 && Math.abs(k) <= 1;
                        world.setBlock(dx, dy, dz, air ? Blocks.field_150350_a : b, air ? 0 : (j % 8 == 2 && (i3 == 0 || k == 0) ? ml : ms));
                        if (!air || j < -this.openFloor + 5 || j % 8 != 5) continue;
                        world.setBlock(dx, dy, dz, ChromaBlocks.HOVER.getBlockInstance(), BlockHoverBlock.HoverType.DAMPER.getPermanentMeta());
                    }
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    int dx = x + i;
                    dz2 = z + k;
                    world.setBlock(dx, y, dz2, Blocks.field_150350_a);
                }
            }
        }
    }
}

