/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.Locks;

import Reika.ChromatiCraft.Base.DynamicStructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LockRoomConnector;
import Reika.ChromatiCraft.World.Dimension.Structure.LocksGenerator;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LocksEntrance
extends DynamicStructurePiece<LocksGenerator> {
    public final int radius;
    public final ForgeDirection facing;
    private final ForgeDirection left;
    public final int length;

    public LocksEntrance(LocksGenerator s, ForgeDirection dir, int r, int len) {
        super(s);
        this.radius = r;
        this.facing = dir;
        this.left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.facing);
        this.length = len;
    }

    @Override
    public void generate(World world, int x, int z) {
        int y = world.func_72825_h(x, z) - 1;
        Block bk = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        for (int i = -this.radius; i <= this.radius; ++i) {
            int dx = x + i;
            for (int k = -this.radius; k <= this.radius; ++k) {
                int dz = z + k;
                int sign = (int)Math.signum(this.facing.offsetX + this.facing.offsetZ);
                int step = this.facing.offsetX != 0 ? i : k;
                int d = Math.abs(this.facing.offsetX == 0 ? i : k);
                int d2 = Math.abs(step);
                int h = this.getHeight(d);
                int hm = d > 0 ? this.getHeight(d - 1) : -1;
                int hp = this.getHeight(d + 1);
                for (int j = 0; j <= h; ++j) {
                    boolean wall;
                    int dy = y + j;
                    boolean enter = step * sign == -this.radius && j > 0 && j < h - 1 && d < this.radius - 1;
                    boolean bl = wall = !enter && (Math.abs(i) == this.radius || Math.abs(k) == this.radius || j == 0 || j == h);
                    boolean window = j == h && (this.radius == 6 ? d == 1 : h == this.getHeight(0) - 1 && h == hm && h == hp) && d2 > 0 && d2 < this.radius - 1;
                    world.func_147465_d(dx, dy, dz, wall ? bk : Blocks.field_150350_a, wall ? (window ? BlockStructureShield.BlockType.GLASS.metadata : BlockStructureShield.BlockType.STONE.metadata) : 0, 3);
                }
            }
        }
        int dx = x + this.facing.offsetX * this.radius;
        int dz = z + this.facing.offsetZ * this.radius;
        int w = 2;
        for (int a = -w; a <= w; ++a) {
            int dx2 = dx + this.left.offsetX * a;
            int dz2 = dz + this.left.offsetZ * a;
            int h = Math.abs(a) == w ? 3 : 4;
            for (int b = 1; b <= h; ++b) {
                int dy = y + b;
                world.func_147449_b(dx2, dy, dz2, Blocks.field_150350_a);
            }
        }
        this.generateTunnel(world, x, y, z);
    }

    private int getHeight(int d) {
        int in = this.radius - d;
        return (int)(2.0 + Math.sqrt(2.5 * (double)in));
    }

    private void generateTunnel(World world, int x, int y, int z) {
        int r = this.length + this.radius + 3;
        int dx = x + this.facing.offsetX * r;
        int dz = z + this.facing.offsetZ * r;
        int posY = ((LocksGenerator)this.parent).getPosY();
        int d = y - posY;
        LockRoomConnector tunnel = new LockRoomConnector((LocksGenerator)this.parent, 0, 0, 0, 0).setWindowed().setLength(this.facing.getOpposite(), this.length).setOpenFloor(d - 5);
        tunnel.generate((ChunkSplicedGenerationCache)new ChunkSplicedGenerationCache.RelayCache(world), dx, posY + d, dz);
    }
}

