/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.World.Dimension.Structure.Monument.MonumentHighlighter;
import Reika.ChromatiCraft.World.Dimension.Structure.Monument.MonumentMineralBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.Monument.MonumentStructure;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class MonumentGenerator {
    private final ChunkSplicedGenerationCache world = new ChunkSplicedGenerationCache();
    private final HashMap<Coordinate, Block> mineralBlocks = new HashMap();
    protected int posX;
    protected int posY;
    protected int posZ;
    protected Coordinate controller;

    public final int getPosX() {
        return this.posX;
    }

    public final int getPosY() {
        return this.posY;
    }

    public final int getPosZ() {
        return this.posZ;
    }

    public Coordinate getController() {
        return this.controller;
    }

    public final void startCalculate(int x, int z, Random rand) {
        this.posX = x;
        this.posZ = z;
        this.posY = 103;
        int r = 32;
        int r2 = 24;
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                for (int j = 0; j <= r2; ++j) {
                    if (ReikaMathLibrary.isPointInsideEllipse((double)i, (double)j, (double)k, (double)r, (double)r2, (double)r)) {
                        this.world.setBlock(x + i, this.posY + j, z + k, Blocks.field_150350_a);
                    }
                    this.world.setBlock(x + i, this.posY - 1, z + k, (Block)Blocks.field_150349_c);
                }
            }
        }
        new MonumentStructure().generate(this.world, rand, x - 21, this.posY, z - 21);
        new MonumentMineralBlocks(this).generate(this.world, rand, x - 21, this.posY, z - 21);
        this.controller = new MonumentHighlighter().generate(this.world, rand, x - 21, this.posY, z - 21);
    }

    public final void generateChunk(World w, ChunkCoordIntPair cp) {
        this.world.generate(w, cp);
    }

    public final void generateAll(World w) {
        this.world.generateAll(w);
    }

    public void clear() {
        this.world.clear();
        this.mineralBlocks.clear();
    }

    public void registerMineralBlock(int x, int y, int z, Block b) {
        this.mineralBlocks.put(new Coordinate(x, y, z), b);
    }

    public Map<Coordinate, Block> getMineralBlocks() {
        return Collections.unmodifiableMap(this.mineralBlocks);
    }
}

