/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.Music;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Dimension.Structure.Music.BlockMusicMemory;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.Structure.Music.MusicPuzzleBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.MusicPuzzleGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MusicPuzzle
extends StructurePiece<MusicPuzzleGenerator>
implements ChunkSplicedGenerationCache.TileCallback {
    private final LinkedList<ReikaMusicHelper.MusicKey> melody = new LinkedList();
    private int length;
    private CrystalElement center;
    private ReikaMusicHelper.KeySignature signature;
    private ArrayList<ReikaMusicHelper.MusicKey> validNotes;
    private ReikaMusicHelper.MusicKey lastKey;
    private final MusicPuzzleBlocks blocks;
    private final int index;
    public boolean isSolved = false;
    public Coordinate controllerLocation;

    public MusicPuzzle(MusicPuzzleGenerator s, int len, int idx) {
        super(s);
        this.length = len;
        this.index = idx;
        this.blocks = new MusicPuzzleBlocks();
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        this.blocks.generate(world, x, y, z);
        Block tr = ChromaBlocks.MUSICTRIGGER.getBlockInstance();
        Block dr = ChromaBlocks.DOOR.getBlockInstance();
        world.setBlock(x + 6, y + 1, z + 18, dr);
        world.setBlock(x + 6, y + 2, z + 18, dr);
        world.setBlock(x + 6, y + 3, z + 18, dr);
        world.setBlock(x + 4, y + 1, z + 18, dr);
        world.setBlock(x + 4, y + 2, z + 18, dr);
        world.setBlock(x + 4, y + 3, z + 18, dr);
        world.setBlock(x + 5, y + 1, z + 18, dr);
        world.setBlock(x + 5, y + 2, z + 18, dr);
        world.setBlock(x + 5, y + 3, z + 18, dr);
        world.setBlock(x + 1, y + 1, z + 6, tr);
        world.setBlock(x + 1, y + 1, z + 7, tr);
        world.setBlock(x + 1, y + 1, z + 8, tr);
        world.setBlock(x + 1, y + 1, z + 9, tr);
        world.setBlock(x + 1, y + 1, z + 10, tr);
        world.setBlock(x + 1, y + 1, z + 11, tr);
        world.setBlock(x + 1, y + 1, z + 12, tr);
        world.setBlock(x + 1, y + 1, z + 13, tr);
        world.setBlock(x + 9, y + 1, z + 6, tr);
        world.setBlock(x + 9, y + 1, z + 7, tr);
        world.setBlock(x + 9, y + 1, z + 8, tr);
        world.setBlock(x + 9, y + 1, z + 9, tr);
        world.setBlock(x + 9, y + 1, z + 10, tr);
        world.setBlock(x + 9, y + 1, z + 11, tr);
        world.setBlock(x + 9, y + 1, z + 12, tr);
        world.setBlock(x + 9, y + 1, z + 13, tr);
        world.setTileEntity(x + 5, y + 1, z + 5, ChromaBlocks.MUSICMEMORY.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)this);
        if (this.index == 0) {
            ((MusicPuzzleGenerator)this.parent).generatePasswordTile(x + 5, y + 2, z + 5);
        }
    }

    public void initialize(Random rand) {
        this.center = CrystalElement.randomElement();
        this.signature = CrystalMusicManager.instance.getSignature(this.center);
        this.validNotes = new ArrayList<ReikaMusicHelper.MusicKey>(CrystalMusicManager.instance.getValidNotesToMixWith(this.center));
        for (int i = 0; i < this.length; ++i) {
            ReikaMusicHelper.MusicKey key = this.randomKey(rand);
            while (!this.keyIsCurrentlyValid(key)) {
                key = this.randomKey(rand);
            }
            this.melody.add(key);
            this.lastKey = key;
        }
    }

    private boolean keyIsCurrentlyValid(ReikaMusicHelper.MusicKey key) {
        if (this.lastKey == null) {
            return true;
        }
        int diff = key.ordinal() - this.lastKey.ordinal();
        if (diff > 12 || diff < -12) {
            return false;
        }
        int mod = diff % 12;
        if (mod == 11) {
            return false;
        }
        return mod != 6;
    }

    public void loadPrefab(MusicPuzzleGenerator.MelodyPrefab pre) {
        List<ReikaMusicHelper.MusicKey> li = pre.getNotes();
        this.melody.clear();
        this.melody.addAll(li);
        this.length = li.size();
        this.signature = pre.key;
        this.center = pre.center;
    }

    public List<ReikaMusicHelper.MusicKey> getMelody() {
        return Collections.unmodifiableList(this.melody);
    }

    public boolean compare(ArrayList<ReikaMusicHelper.MusicKey> li) {
        return li.equals(this.melody);
    }

    private ReikaMusicHelper.MusicKey randomKey(Random rand) {
        return this.validNotes.get(rand.nextInt(this.validNotes.size()));
    }

    public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
        if (te instanceof BlockMusicMemory.TileMusicMemory) {
            ((BlockMusicMemory.TileMusicMemory)te).program(this, this.index);
            ((BlockMusicMemory.TileMusicMemory)te).uid = ((MusicPuzzleGenerator)this.parent).id;
            this.controllerLocation = new Coordinate(te);
        }
    }
}

