/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.PistonTape;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.RGBColorData;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class DoorKey {
    private final DoorValue[] colors;
    public final int colorCount;
    public final int index;
    public final int value;

    DoorKey(int idx, RGBColorData[] clr) {
        this.index = idx;
        this.colorCount = clr.length;
        this.colors = new DoorValue[this.colorCount];
        int v = 0;
        for (int i = 0; i < this.colorCount; ++i) {
            this.colors[i] = new DoorValue(i, clr[i]);
            v |= this.colors[i].numberValue << i * 3;
        }
        this.value = v;
    }

    public DoorValue getValue(int idx) {
        return this.colors[idx];
    }

    void setTarget(int idx, Coordinate c) {
        this.colors[idx].target = c;
    }

    public static class KeyIO
    implements ReikaNBTHelper.NBTIO<DoorKey> {
        public static final KeyIO instance = new KeyIO();

        private KeyIO() {
        }

        public DoorKey createFromNBT(NBTBase nbt) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            int num = tag.func_74762_e("count");
            int idx = tag.func_74762_e("idx");
            RGBColorData[] arr = new RGBColorData[num];
            for (int i = 0; i < num; ++i) {
                NBTTagCompound val = tag.func_74775_l("clr_" + i);
                RGBColorData clr = RGBColorData.white();
                clr.readFromNBT(val);
                arr[i] = clr;
            }
            return new DoorKey(idx, arr);
        }

        public NBTBase convertToNBT(DoorKey obj) {
            NBTTagCompound ret = new NBTTagCompound();
            for (int i = 0; i < obj.colorCount; ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                obj.colors[i].color.writeToNBT(tag);
                ret.func_74782_a("clr_" + i, (NBTBase)tag);
            }
            ret.func_74768_a("count", obj.colorCount);
            ret.func_74768_a("idx", obj.index);
            return ret;
        }
    }

    public class DoorValue {
        public final int index;
        private RGBColorData color;
        private Coordinate target;
        public final int numberValue;

        private DoorValue(int i, RGBColorData clr) {
            this.index = i;
            this.color = clr;
            this.numberValue = (clr.red ? 4 : 0) | (clr.green ? 2 : 0) | (clr.blue ? 1 : 0);
        }

        RGBColorData getColor() {
            return this.color.copy();
        }

        public int getRenderColor() {
            return this.color.getRenderColor();
        }

        DoorKey getParent() {
            return DoorKey.this;
        }

        Coordinate getTargetLocation() {
            return this.target;
        }
    }
}

