/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Block.Dimension.Structure.PistonTape.BlockPistonTarget;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.DoorKey;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeStage;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DoorSection
extends StructurePiece<PistonTapeGenerator> {
    static final int WIDTH = 10;
    static final int HEIGHT = 4;
    private final ForgeDirection tunnelDir;
    final DoorKey doorData;
    private final TapeStage level;
    private final boolean isClosed;
    private final int index;
    private final HashSet<Coordinate> doors = new HashSet();

    public DoorSection(PistonTapeGenerator s, TapeStage t, ForgeDirection dir, DoorKey d, int idx, boolean closed) {
        super(s);
        this.tunnelDir = dir;
        this.doorData = d;
        this.level = t;
        this.isClosed = closed;
        this.index = idx;
    }

    public int getLength() {
        return Math.max(3, this.level.bitsPerDoor + 2);
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        int h;
        int i;
        int d;
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.tunnelDir);
        int ms = BlockStructureShield.BlockType.STONE.metadata;
        int esc = this.getEscapeMeta();
        Block escd = ChromaBlocks.SHIFTLOCK.getBlockInstance();
        int len = this.getLength();
        for (d = 0; d <= len; ++d) {
            for (i = 0; i <= 10; ++i) {
                for (int h2 = 0; h2 < 4; ++h2) {
                    if (this.isClosed && d == len && i > 4) {
                        world.setBlock(x + i * left.offsetX + d * this.tunnelDir.offsetX, y + h2, z + i * left.offsetZ + d * this.tunnelDir.offsetZ, b, ms);
                        continue;
                    }
                    world.setBlock(x + i * left.offsetX + d * this.tunnelDir.offsetX, y + h2, z + i * left.offsetZ + d * this.tunnelDir.offsetZ, Blocks.field_150350_a);
                }
            }
            for (h = 1; h < 4; ++h) {
                world.setBlock(x + left.offsetX * 10 + d * this.tunnelDir.offsetX, y + h, z + left.offsetZ * 10 + d * this.tunnelDir.offsetZ, b, ms);
            }
        }
        for (d = 0; d <= len; ++d) {
            for (i = 0; i <= 10; ++i) {
                world.setBlock(x + i * left.offsetX + d * this.tunnelDir.offsetX, y, z + i * left.offsetZ + d * this.tunnelDir.offsetZ, b, ms);
                world.setBlock(x + i * left.offsetX + d * this.tunnelDir.offsetX, y + 4, z + i * left.offsetZ + d * this.tunnelDir.offsetZ, b, ms);
            }
            for (h = 1; h < 4; ++h) {
                world.setBlock(x + d * this.tunnelDir.offsetX, y + h, z + d * this.tunnelDir.offsetZ, b, ms);
                world.setBlock(x + d * this.tunnelDir.offsetX + 1 * left.offsetX, y + h, z + d * this.tunnelDir.offsetZ + 1 * left.offsetZ, b, ms);
                world.setBlock(x + d * this.tunnelDir.offsetX + 5 * left.offsetX, y + h, z + d * this.tunnelDir.offsetZ + 5 * left.offsetZ, b, ms);
            }
        }
        for (int hw = 2; hw <= 4; ++hw) {
            for (i = 1; i < 4; ++i) {
                this.placeDoorBlock(world, x + left.offsetX * hw, y + i, z + left.offsetZ * hw);
            }
        }
        for (int i2 = 1; i2 < 4; ++i2) {
            int a = this.level.bitsPerDoor > 2 ? 1 : 0;
            int m = i2 == 2 ? BlockStructureShield.BlockType.LIGHT.metadata : ms;
            world.setBlock(x + left.offsetX * 6 + (a + 1) * this.tunnelDir.offsetX, y + i2, z + left.offsetZ * 6 + (a + 1) * this.tunnelDir.offsetZ, b, m);
            world.setBlock(x + left.offsetX * 6 + (a + 3) * this.tunnelDir.offsetX, y + i2, z + left.offsetZ * 6 + (a + 3) * this.tunnelDir.offsetZ, b, m);
            world.setBlock(x + left.offsetX * 5 + (a + 2) * this.tunnelDir.offsetX, y + i2, z + left.offsetZ * 5 + (a + 2) * this.tunnelDir.offsetZ, escd, esc);
        }
        world.setBlock(x + left.offsetX + 2 * this.tunnelDir.offsetX, y, z + left.offsetZ + 2 * this.tunnelDir.offsetZ, b, BlockStructureShield.BlockType.LIGHT.metadata);
        ((PistonTapeGenerator)this.parent).generateLootChest(x + left.offsetX + 2 * this.tunnelDir.offsetX, y + 1, z + left.offsetZ + 2 * this.tunnelDir.offsetZ, this.getChestFacing(), "mineshaftCorridor", 0, new Object[0]);
        world.setBlock(x + left.offsetX + 2 * this.tunnelDir.offsetX, y + 2, z + left.offsetZ + 2 * this.tunnelDir.offsetZ, b, BlockStructureShield.BlockType.CRACK.metadata);
        Coordinate door = new Coordinate(x + left.offsetX * 3, y + 1, z + left.offsetZ * 3);
        for (i = 0; i < this.level.bitsPerDoor; ++i) {
            this.placeTarget(world, x + left.offsetX * 5 + (i - this.level.bitsPerDoor / 2) * this.tunnelDir.offsetX, y + 2, z + left.offsetZ * 5 + (i - this.level.bitsPerDoor / 2) * this.tunnelDir.offsetZ, i, door);
        }
    }

    private ForgeDirection getChestFacing() {
        return ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.tunnelDir);
    }

    private int getEscapeMeta() {
        switch (this.tunnelDir) {
            case WEST: {
                return 9;
            }
            case EAST: {
                return 7;
            }
            case NORTH: {
                return 3;
            }
            case SOUTH: {
                return 5;
            }
        }
        return 1;
    }

    private void placeTarget(ChunkSplicedGenerationCache world, int x, int y, int z, int idx, Coordinate door) {
        this.doorData.setTarget(idx, new Coordinate(x, y, z));
        world.setTileEntity(x, y, z, ChromaBlocks.PISTONTARGET.getBlockInstance(), 1, (ChunkSplicedGenerationCache.TileCallback)new DoorTargetCallback(this.doorData.getValue(idx), this.level, this.index, ReikaDirectionHelper.getRightBy90((ForgeDirection)this.tunnelDir), door, ((PistonTapeGenerator)this.parent).id));
    }

    private void placeDoorBlock(ChunkSplicedGenerationCache world, int x, int y, int z) {
        world.setBlock(x, y, z, ChromaBlocks.DOOR.getBlockInstance());
        this.doors.add(new Coordinate(x, y, z));
    }

    public void forceOpenDoor(World world) {
        for (Coordinate c : this.doors) {
            BlockChromaDoor.setOpen(world, c.xCoord, c.yCoord, c.zCoord, true);
        }
    }

    private static class DoorTargetCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID id;
        private final int stage;
        private final int doorIndex;
        private final DoorKey.DoorValue data;
        private final Coordinate door;
        private final ForgeDirection direction;

        private DoorTargetCallback(DoorKey.DoorValue d, TapeStage s, int step, ForgeDirection dir, Coordinate c, UUID uid) {
            this.id = uid;
            this.data = d;
            this.door = c;
            this.direction = dir;
            this.doorIndex = step;
            this.stage = s.index;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            ((BlockPistonTarget.PistonDoorTile)te).uid = this.id;
            ((BlockPistonTarget.PistonDoorTile)te).setColor(this.data.getColor());
            ((BlockPistonTarget.PistonDoorTile)te).setData(this.direction, this.stage, this.doorIndex, this.data.index, this.data.getParent().colorCount);
            ((BlockPistonTarget.PistonDoorTile)te).setTarget(this.door);
        }
    }
}

