/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeArea;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class PistonTapeAccessHall
extends StructurePiece<PistonTapeGenerator> {
    public static final int WIDTH = 9;
    public static final int HEIGHT = 4;
    public static final int DEPTH = 3;
    private final TapeArea tape;

    public PistonTapeAccessHall(PistonTapeGenerator gen, TapeArea t) {
        super(gen);
        this.tape = t;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        ForgeDirection dir = this.tape.hallDirection;
        ForgeDirection left = this.tape.tape.facing.getOpposite();
        for (int i = 0; i <= 3; ++i) {
            for (int l = 0; l <= 9; ++l) {
                int dx = x + dir.offsetX * i + left.offsetX * l;
                int dz = z + dir.offsetZ * i + left.offsetZ * l;
                for (int u = 0; u <= 4; ++u) {
                    world.setBlock(dx, y + u, dz, Blocks.field_150350_a);
                }
                int m = l == 0 || l == 9 ? BlockStructureShield.BlockType.STONE.metadata : BlockStructureShield.BlockType.COBBLE.metadata;
                world.setBlock(dx, y, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m);
                world.setBlock(dx, y + 4, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            }
            for (int u = 1; u <= 4; ++u) {
                world.setBlock(x + dir.offsetX * i, y + u, z + dir.offsetZ * i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                world.setBlock(x + dir.offsetX * i + left.offsetX * 9, y + u, z + dir.offsetZ * i + left.offsetZ * 9, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            }
        }
        for (int u = 1; u <= 4; ++u) {
            world.setBlock(x + dir.offsetX * 3 + left.offsetX * 4, y + u, z + dir.offsetZ * 3 + left.offsetZ * 4, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            world.setBlock(x + dir.offsetX * 3 + left.offsetX * 5, y + u, z + dir.offsetZ * 3 + left.offsetZ * 5, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
        }
        world.setBlock(x + dir.offsetX, y + 2, z + dir.offsetZ, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        world.setBlock(x + dir.offsetX + left.offsetX * 9, y + 2, z + dir.offsetZ + left.offsetZ * 9, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata);
        int h = 4;
        int d = 1 + this.tape.tape.busWidth / 2 + 1;
        for (int i = 1; i <= d; ++i) {
            int dx = x + dir.offsetX * (3 + i);
            int dz = z + dir.offsetZ * (3 + i);
            for (int l = 0; l <= 9; ++l) {
                for (int dh = 0; dh <= h; ++dh) {
                    Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                    int m = BlockStructureShield.BlockType.STONE.metadata;
                    if (dh != 0 && dh != h && l != 0 && l != 9 && l != 4) {
                        b = Blocks.field_150350_a;
                        m = 0;
                    }
                    world.setBlock(x + left.offsetX * l + dir.offsetX * (i + 3), y + dh, z + left.offsetZ * l + dir.offsetZ * (i + 3), b, m);
                }
            }
        }
    }
}

