/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Base.DynamicStructurePiece;
import Reika.ChromatiCraft.Block.BlockHoverBlock;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PistonTapeEntrance
extends DynamicStructurePiece<PistonTapeGenerator> {
    private final Coordinate start;
    private final ForgeDirection dir;

    public PistonTapeEntrance(PistonTapeGenerator s, Coordinate c, ForgeDirection d) {
        super(s);
        this.start = c;
        this.dir = d;
    }

    @Override
    public void generate(World world, int x, int z) {
        int y1 = this.start.yCoord - 2;
        int y2 = world.func_72825_h(x, z);
        for (int y = y1; y <= y2; ++y) {
            int r = this.getR(y, y1);
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    boolean wall;
                    int dx = x + i;
                    int dz = z + k;
                    boolean bl = wall = i == r || i == -r || k == -r || k == r || y == y1;
                    if (wall) {
                        int m;
                        int n = m = world.field_73012_v.nextInt(20) == 0 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata;
                        if (this.isEdge(y - 1, y1)) {
                            m = BlockStructureShield.BlockType.COBBLE.metadata;
                        }
                        world.func_147465_d(dx, y, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
                        continue;
                    }
                    if (this.isEdge(y, y1)) {
                        world.func_147465_d(dx, y, dz, ChromaBlocks.HOVER.getBlockInstance(), BlockHoverBlock.HoverType.DAMPER.getPermanentMeta(), 3);
                        continue;
                    }
                    world.func_147449_b(dx, y, dz, Blocks.field_150350_a);
                }
            }
        }
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.dir);
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                int dx = x + 3 * this.dir.offsetX + left.offsetX * i;
                int dz = z + 3 * this.dir.offsetZ + left.offsetZ * i;
                world.func_147449_b(dx, this.start.yCoord + k, dz, Blocks.field_150350_a);
            }
        }
    }

    private boolean isEdge(int y, int y1) {
        return y > y1 + 1 && this.getR(y, y1) != this.getR(y + 1, y1);
    }

    private int getR(int y, int y1) {
        return 4 - (int)(2.0 * Math.cos((double)(y - y1) / 4.0));
    }
}

