/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Dimension.Structure.PistonTape.BlockPistonController;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeArea;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeStage;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PistonTapeEntryArea
extends StructurePiece<PistonTapeGenerator> {
    public static final int DEPTH = 3;
    private final TapeArea tape;
    private final TapeStage level;

    public PistonTapeEntryArea(PistonTapeGenerator gen, TapeStage lvl, TapeArea t) {
        super(gen);
        this.level = lvl;
        this.tape = t;
    }

    public int getWidth() {
        return 7 + this.tape.tape.dimensions.totalDepth;
    }

    public int getHeight() {
        return 2 + this.tape.tape.dimensions.totalHeight;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        ForgeDirection dir = this.tape.hallDirection;
        ForgeDirection left = this.tape.tape.facing.getOpposite();
        int w = this.getWidth();
        int h = this.getHeight();
        for (int i = 0; i <= 3; ++i) {
            for (int k = 0; k <= w; ++k) {
                for (int j = 0; j <= h; ++j) {
                    int dx = x + i * dir.offsetX + k * left.offsetX;
                    int dz = z + i * dir.offsetZ + k * left.offsetZ;
                    int dy = y + j;
                    Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                    int m = BlockStructureShield.BlockType.STONE.metadata;
                    boolean air = k > 1 && k < w - 1 && i > 0 && i < 3 && j > 1 && j < h;
                    air |= (i == 0 || i == 3) && k >= 1 && k <= 3 && j >= 1 && j <= 3;
                    air |= k >= 1 && k <= 3 && j >= 1 && j < h && i > 0 && i < 3;
                    air |= i == 3 && k >= 5 && k < w - 1 && j > 1 && j < h;
                    if (air |= k > 0 && k <= 4 && j >= 2 && j < h && i == 3) {
                        b = Blocks.field_150350_a;
                        m = 0;
                    }
                    if (i == 2) {
                        if (k == 0 && j == Math.max(4, 4 + (h - 4) / 2)) {
                            m = BlockStructureShield.BlockType.LIGHT.metadata;
                        } else if (k == w - 1 && j == 3) {
                            m = BlockStructureShield.BlockType.LIGHT.metadata;
                        } else if (k == 4 && j == h) {
                            m = BlockStructureShield.BlockType.LIGHT.metadata;
                        }
                    }
                    if (i > 0 && i <= 3 && j == 1) {
                        if (k == 4) {
                            b = Blocks.field_150333_U;
                            m = ReikaItemHelper.stonebrickSlab.metadata;
                        } else if (k == 5) {
                            b = Blocks.field_150417_aV;
                            m = 0;
                        }
                    }
                    if (this.level.index == 0 && j == 3) {
                        if (i == 2 && k == w - 1) {
                            b = ChromaBlocks.DIMDATA.getBlockInstance();
                        } else if (i == 0 && k == w - 3) {
                            b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                            m = BlockStructureShield.BlockType.LIGHT.metadata;
                        }
                    }
                    if (b == ChromaBlocks.DIMDATA.getBlockInstance()) {
                        ((PistonTapeGenerator)this.parent).generatePasswordTile(dx, dy, dz);
                        continue;
                    }
                    world.setBlock(dx, dy, dz, b, m);
                }
            }
        }
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        int m = BlockStructureShield.BlockType.STONE.metadata;
        for (int k = 0; k <= 4; ++k) {
            for (int j = 4; j <= h; ++j) {
                int i = 4;
                int dx = x + i * dir.offsetX + k * left.offsetX;
                int dz = z + i * dir.offsetZ + k * left.offsetZ;
                int dy = y + j;
                world.setBlock(dx, dy, dz, b, m);
            }
        }
        int dx = x + this.tape.hallDirection.offsetX * 3;
        int dz = z + this.tape.hallDirection.offsetZ * 3;
        int dx2 = dx - this.tape.hallDirection.offsetX * 2;
        int dz2 = dz - this.tape.hallDirection.offsetZ * 2;
        world.setTileEntity(dx, y + 3, dz, ChromaBlocks.PISTONCONTROL.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new PistonControlCallback(this.level));
        world.setTileEntity(dx, y + 2, dz, ChromaBlocks.PISTONCONTROL.getBlockInstance(), 1, (ChunkSplicedGenerationCache.TileCallback)new PistonControlCallback(this.level));
        world.setTileEntity(dx, y + 1, dz, ChromaBlocks.PISTONCONTROL.getBlockInstance(), 2, (ChunkSplicedGenerationCache.TileCallback)new PistonControlCallback(this.level));
        world.setTileEntity(dx2, y + 2, dz2, ChromaBlocks.PISTONCONTROL.getBlockInstance(), 3, (ChunkSplicedGenerationCache.TileCallback)new PistonControlCallback(this.level));
    }

    private static class PistonControlCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID uid;
        private final int index;
        private final ForgeDirection direction;

        private PistonControlCallback(TapeStage t) {
            this.uid = t.getID();
            this.index = t.index;
            this.direction = ReikaDirectionHelper.getLeftBy90((ForgeDirection)t.mainDirection);
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            ((BlockPistonController.TilePistonController)te).setData(this.index, this.direction);
            ((BlockPistonController.TilePistonController)te).uid = this.uid;
        }
    }
}

