/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.PistonTapeSlice;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeStage;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.RGBColorData;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PistonTapeLoop
extends StructurePiece<PistonTapeGenerator> {
    public final ForgeDirection facing;
    public final int busWidth;
    public final LoopDimensions dimensions;
    final TapeStage level;
    private final PistonTapeSlice[] bits;

    protected PistonTapeLoop(PistonTapeGenerator s, ForgeDirection dir, TapeStage t) {
        super(s);
        this.level = t;
        this.facing = dir;
        this.busWidth = t.bitsPerDoor;
        this.bits = new PistonTapeSlice[this.busWidth];
        this.dimensions = LoopDimensions.createFor(this.level.doorCount);
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = new PistonTapeSlice(s, this.facing, i, this, this.dimensions);
        }
    }

    void randomize(Random rand) {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i].randomizeSolution(rand);
        }
    }

    RGBColorData getColor(int subBit, int pos) {
        return this.bits[subBit].getColor(pos);
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        ForgeDirection dir = ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.facing);
        for (int i = 0; i < this.bits.length; ++i) {
            PistonTapeSlice p = this.bits[i];
            p.generate(world, x + dir.offsetX * i, y, z + dir.offsetZ * i);
        }
    }

    public int doorCount() {
        return this.level.doorCount;
    }

    public boolean cycle(World world) {
        boolean flag = true;
        for (PistonTapeSlice s : this.bits) {
            flag &= s.cycle(world);
        }
        return flag;
    }

    public Coordinate getEmitter(int idx) {
        return this.bits[idx].emitter;
    }

    public Coordinate getTarget(int idx) {
        return this.bits[idx].target;
    }

    static class LoopDimensions {
        private static final int MIN_HEIGHT = 4;
        private static final int MAX_HEIGHT = 6;
        public final int totalHeight;
        public final int totalDepth;
        public final int bitLength;
        private final HashMap<Integer, PistonTapeSlice.LoopSliceDimensions> slices = new HashMap();

        protected LoopDimensions(int d, int h) {
            this.totalHeight = h;
            this.totalDepth = d;
            this.bitLength = (this.totalHeight - 1) * 2 + (this.totalDepth - 1) * 2 + 2;
        }

        public final String toString() {
            return this.totalDepth + "x" + this.totalHeight;
        }

        private static LoopDimensions createFor(int stages) {
            int l = stages * 2;
            int bestH = -1;
            int bestD = -1;
            int best = l + 5;
            for (int h = 4; h <= 6; ++h) {
                int d = MathHelper.func_76143_f((double)((float)l / (float)h));
                int excess = d * h - l;
                if (excess >= best) continue;
                bestH = h;
                bestD = d;
                best = excess;
            }
            return new LoopDimensions(bestD, bestH);
        }

        public final PistonTapeSlice.LoopSliceDimensions slice(int idx) {
            PistonTapeSlice.LoopSliceDimensions ret = new PistonTapeSlice.LoopSliceDimensions(idx, this.totalDepth, this.totalHeight);
            this.slices.put(idx, ret);
            return ret;
        }
    }
}

