/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureLootRoom;
import Reika.ChromatiCraft.Block.BlockEncrustedCrystal;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PistonTapeLootRoom
extends StructureLootRoom<PistonTapeGenerator> {
    private final ForgeDirection facing;
    private final Random rand;

    public PistonTapeLootRoom(PistonTapeGenerator s, ForgeDirection dir, Random r) {
        super(s);
        this.facing = dir;
        this.rand = r;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        int dz;
        int dx;
        int k;
        int i;
        int dy;
        int d = 7;
        int h = 2;
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.facing);
        for (int i2 = 0; i2 <= d; ++i2) {
            for (int j = -h; j <= h; ++j) {
                int w = i2 > 2 && i2 < d - 1 ? 3 : 2;
                for (int k2 = -w; k2 <= w; ++k2) {
                    int dx2 = x + i2 * this.facing.offsetX + k2 * left.offsetX;
                    dy = y + j;
                    int dz2 = z + i2 * this.facing.offsetZ + k2 * left.offsetZ;
                    boolean wall = j == -h || j == h || k2 == w || k2 == -w || i2 == d;
                    Block b = Blocks.field_150350_a;
                    int m = 0;
                    if (wall) {
                        b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                        m = BlockStructureShield.BlockType.STONE.metadata;
                        if (j == 0 && (i2 == 1 || i2 == 4)) {
                            m = BlockStructureShield.BlockType.LIGHT.metadata;
                        }
                    } else if (i2 == 1) {
                        b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                        int n = m = j == 0 && k2 == 0 ? BlockStructureShield.BlockType.CRACKS.metadata : BlockStructureShield.BlockType.GLASS.metadata;
                    }
                    if (!(!wall || i2 <= 2 || j != -h && j != h || i2 != 2 && i2 != d - 1 && k2 != w - 1 && k2 != -w + 1)) {
                        m = BlockStructureShield.BlockType.COBBLE.metadata;
                    }
                    if (b == Blocks.field_150350_a && i2 > 1) {
                        world.setTileEntity(dx2, dy, dz2, ChromaBlocks.ENCRUSTED.getBlockInstance(), ((PistonTapeGenerator)this.parent).getCoreColor().ordinal(), (ChunkSplicedGenerationCache.TileCallback)new EncrustedCrystalCallback(this.parent, this.rand));
                        continue;
                    }
                    world.setBlock(dx2, dy, dz2, b, m);
                }
            }
        }
        int l = 4;
        this.placeCore(x + this.facing.offsetX * l, y, z + this.facing.offsetZ * l);
        for (i = -1; i <= 1; ++i) {
            for (k = -1; k <= 1; ++k) {
                dx = x + this.facing.offsetX * (i + l) + left.offsetX * k;
                dz = z + this.facing.offsetZ * (i + l) + left.offsetZ * k;
                ((PistonTapeGenerator)this.parent).addBreakable(dx, y - h, dz);
                ((PistonTapeGenerator)this.parent).addBreakable(dx, y + h, dz);
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (k = 4; k <= 6; ++k) {
                dx = x + this.facing.offsetX * -1 + left.offsetX * k;
                dz = z + this.facing.offsetZ * -1 + left.offsetZ * k;
                dy = y + i;
                ((PistonTapeGenerator)this.parent).addBreakable(dx, dy, dz);
            }
        }
    }

    private static class EncrustedCrystalCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final CrystalElement color;
        private final Random rand;

        private EncrustedCrystalCallback(DimensionStructureGenerator p, Random r) {
            this.color = p.getCoreColor();
            this.rand = r;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity tile) {
            BlockEncrustedCrystal.TileCrystalEncrusted te = (BlockEncrustedCrystal.TileCrystalEncrusted)tile;
            if (te == null) {
                ReikaJavaLibrary.pConsole((Object)("No tile @ " + new Coordinate(x, y, z) + "?!"));
                return;
            }
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                if (!BlockEncrustedCrystal.CrystalGrowth.canExist(world, x, y, z, dir)) continue;
                te.addGrowth(dir, 3 + this.rand.nextInt(7));
            }
            world.func_147464_a(x, y, z, te.func_145838_q(), 100);
        }
    }
}

