/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Dimension.Structure.Laser.BlockLaserEffector;
import Reika.ChromatiCraft.Block.Dimension.Structure.PistonTape.BlockPistonTarget;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.PistonTapeLoop;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeStage;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.RGBColorData;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PistonTapeSlice
extends StructurePiece<PistonTapeGenerator> {
    private final ForgeDirection facing;
    public final int bitCount;
    private final PistonTapeLoop loop;
    private final LoopSliceDimensions dimensions;
    private final int busIndex;
    private final HashMap<ForgeDirection, Coordinate> pistons = new HashMap();
    Coordinate emitter;
    Coordinate target;
    Coordinate zeroBit;
    private final RGBColorData[] bitColors;
    private final RGBColorData[] netColors;
    private boolean firedVerticalLast;
    private boolean isHalfCycled = false;
    private long lastFire = -1L;

    protected PistonTapeSlice(PistonTapeGenerator g, ForgeDirection dir, int idx, PistonTapeLoop p, PistonTapeLoop.LoopDimensions size) {
        super(g);
        this.busIndex = idx;
        this.facing = dir;
        this.dimensions = size.slice(this.busIndex);
        this.bitCount = this.dimensions.bitLength;
        this.loop = p;
        this.bitColors = new RGBColorData[this.bitCount];
        this.netColors = new RGBColorData[this.bitCount];
    }

    public boolean cycle(World world) {
        long step = world.func_82737_E() - this.lastFire;
        if (step < 6L) {
            return false;
        }
        this.lastFire = world.func_82737_E();
        if (this.firedVerticalLast) {
            Coordinate c = this.pistons.get(this.facing);
            ReikaBlockHelper.extendPiston((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord);
            c = this.pistons.get(this.facing.getOpposite());
            ReikaBlockHelper.extendPiston((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord);
        } else {
            Coordinate c = this.pistons.get(ForgeDirection.UP);
            ReikaBlockHelper.extendPiston((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord);
            c = this.pistons.get(ForgeDirection.DOWN);
            ReikaBlockHelper.extendPiston((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord);
        }
        this.firedVerticalLast = !this.firedVerticalLast;
        this.isHalfCycled = !this.isHalfCycled;
        return !this.isHalfCycled;
    }

    void randomizeSolution(Random rand) {
        for (int i = 0; i < this.bitCount; ++i) {
            this.genRandomColor(i, rand);
        }
    }

    RGBColorData getColor(int pos) {
        return this.netColors[pos];
    }

    public Coordinate getNthBitBlock(int i) {
        return this.dimensions.getNthBitPosition(i);
    }

    private void genRandomColor(int i, Random rand) {
        RGBColorData c;
        int i2 = (i + this.getSecondFilterOffset()) % this.bitColors.length;
        RGBColorData net = RGBColorData.white();
        Collection optionsA = RGBColorData.getAllPossibilities();
        Collection optionsB = RGBColorData.getAllPossibilities();
        if (this.bitColors[i] != null || this.bitColors[i2] != null) {
            if (this.bitColors[i] == null) {
                optionsA = this.bitColors[i2].getReductiveChildren(true, false);
                optionsB = ReikaJavaLibrary.makeListFrom((Object)this.bitColors[i2]);
            } else if (this.bitColors[i2] == null) {
                optionsA = ReikaJavaLibrary.makeListFrom((Object)this.bitColors[i]);
                optionsB = this.bitColors[i].getReductiveChildren(true, false);
            } else {
                optionsA = ReikaJavaLibrary.makeListFrom((Object)this.bitColors[i]);
                optionsB = ReikaJavaLibrary.makeListFrom((Object)this.bitColors[i2]);
            }
        }
        Iterator it = optionsA.iterator();
        while (it.hasNext()) {
            c = (RGBColorData)it.next();
            if (!c.isBlack() && !c.isPrimary()) continue;
            it.remove();
        }
        it = optionsB.iterator();
        while (it.hasNext()) {
            c = (RGBColorData)it.next();
            if (!c.isBlack() && !c.isPrimary()) continue;
            it.remove();
        }
        this.bitColors[i] = (RGBColorData)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, (Collection)optionsA);
        this.bitColors[i2] = (RGBColorData)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, (Collection)optionsB);
        net = this.bitColors[i].copy();
        net.intersect(this.bitColors[i2]);
        this.netColors[i] = net;
    }

    private int getSecondFilterOffset() {
        return this.dimensions.totalDepth + 1;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        for (int d = -1; d <= this.dimensions.totalDepth + 2; ++d) {
            for (int h = -2; h <= this.dimensions.totalHeight + 2; ++h) {
                if (d == -1 && h < this.dimensions.totalHeight) continue;
                Block b = Blocks.field_150350_a;
                int m = 0;
                if (h >= this.dimensions.totalHeight) {
                    b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                    m = BlockStructureShield.BlockType.STONE.metadata;
                }
                if (h < 0) {
                    b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                    m = BlockStructureShield.BlockType.CLOAK.metadata;
                }
                if (d == -2 || d > this.dimensions.totalDepth) {
                    b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                    m = BlockStructureShield.BlockType.STONE.metadata;
                }
                if (d == -2 && h >= 0 && h <= this.dimensions.totalHeight - 1) {
                    b = ChromaBlocks.SPECIALSHIELD.getBlockInstance();
                    m = BlockStructureShield.BlockType.GLASS.metadata;
                }
                if (d == 0 && h == this.dimensions.totalHeight) {
                    b = Blocks.field_150350_a;
                    m = 0;
                }
                if (b == ChromaBlocks.STRUCTSHIELD.getBlockInstance() && d == this.dimensions.totalDepth / 2) {
                    m = BlockStructureShield.BlockType.LIGHT.metadata;
                }
                world.setBlock(x - d * this.facing.offsetX, y + h, z - d * this.facing.offsetZ, b, m);
            }
        }
        this.generateTape(world, x, y, z);
        this.placePiston(world, x, y - 1, z, ForgeDirection.UP);
        this.placePiston(world, x + this.facing.offsetX, y + this.dimensions.totalHeight, z + this.facing.offsetZ, this.facing.getOpposite());
        this.placePiston(world, x - this.facing.offsetX * this.dimensions.totalDepth, y + this.dimensions.totalHeight + 1, z - this.facing.offsetZ * this.dimensions.totalDepth, ForgeDirection.DOWN);
        this.placePiston(world, x - this.facing.offsetX * (this.dimensions.totalDepth + 1), y, z - this.facing.offsetZ * (this.dimensions.totalDepth + 1), this.facing);
        this.placeEmitter(world, x - this.facing.offsetX * (this.dimensions.totalDepth + 1), y + 1, z - this.facing.offsetZ * (this.dimensions.totalDepth + 1));
        this.placeTarget(world, x + this.facing.offsetX * 7, y + 1, z + this.facing.offsetZ * 7);
    }

    private void generateTape(ChunkSplicedGenerationCache world, int x, int y, int z) {
        this.zeroBit = new Coordinate(x, y, z);
        this.dimensions.calculatePositions(this.zeroBit.xCoord, this.zeroBit.yCoord, this.zeroBit.zCoord, 1, this.facing, true);
        PistonTapeGenerator cfr_ignored_0 = (PistonTapeGenerator)this.parent;
        for (int d = 0; d <= this.dimensions.totalDepth; ++d) {
            for (int h = 0; h <= this.dimensions.totalHeight; ++h) {
                if (d != 0 && d != this.dimensions.totalDepth && h != 0 && h != this.dimensions.totalHeight || d == 0 && h == this.dimensions.totalHeight || d == this.dimensions.totalDepth && h == 0) continue;
                this.placeBit(world, x - d * this.facing.offsetX, y + h, z - d * this.facing.offsetZ);
            }
        }
    }

    private void placeBit(ChunkSplicedGenerationCache world, int x, int y, int z) {
        world.setBlock(x, y, z, ChromaBlocks.PISTONBIT.getBlockInstance(), 0);
    }

    private void placePiston(ChunkSplicedGenerationCache world, int x, int y, int z, ForgeDirection dir) {
        this.pistons.put(dir, new Coordinate(x, y, z));
        world.setBlock(x, y, z, (Block)Blocks.field_150331_J, dir.ordinal());
    }

    private void placeEmitter(ChunkSplicedGenerationCache world, int x, int y, int z) {
        this.emitter = new Coordinate(x, y, z);
        world.setTileEntity(x, y, z, ChromaBlocks.LASEREFFECT.getBlockInstance(), BlockLaserEffector.LaserEffectType.EMITTER.ordinal(), (ChunkSplicedGenerationCache.TileCallback)new PistonEmitterCallback(this));
    }

    private void placeTarget(ChunkSplicedGenerationCache world, int x, int y, int z) {
        this.target = new Coordinate(x, y, z);
        world.setTileEntity(x, y, z, ChromaBlocks.PISTONTARGET.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new PistonTargetCallback(this, this.loop.level));
    }

    static class LoopSliceDimensions
    extends PistonTapeLoop.LoopDimensions {
        public final int index;
        private final Coordinate[] positions;
        private Coordinate rootPosition;

        LoopSliceDimensions(int idx, int d, int h) {
            super(d, h);
            this.index = idx;
            this.positions = new Coordinate[this.bitLength];
        }

        public void calculatePositions(int x, int y, int z, int initialBitIndex, ForgeDirection facing, boolean skipFirstAndThirdCorners) {
            int i;
            Coordinate c = this.rootPosition = new Coordinate(x, y, z);
            ForgeDirection dir = facing.getOpposite();
            int n = 0;
            for (i = 0; i < this.bitLength; ++i) {
                c = c.offset(dir, 1);
                if (++n == this.totalDepth) {
                    dir = ForgeDirection.UP;
                    if (skipFirstAndThirdCorners) {
                        --i;
                        continue;
                    }
                } else if (n == this.totalDepth + this.totalHeight) {
                    dir = facing;
                    if (!skipFirstAndThirdCorners) {
                        --i;
                        continue;
                    }
                } else if (n == this.totalDepth + this.totalHeight + this.totalDepth) {
                    dir = ForgeDirection.DOWN;
                    if (skipFirstAndThirdCorners) {
                        --i;
                        continue;
                    }
                } else if (n == this.totalDepth + this.totalHeight + this.totalDepth + this.totalHeight) {
                    dir = facing.getOpposite();
                    if (!skipFirstAndThirdCorners) {
                        --i;
                        continue;
                    }
                }
                this.positions[i] = c;
            }
            for (i = 0; i <= initialBitIndex; ++i) {
                ReikaArrayHelper.cycleArray((Object[])this.positions, (Object)this.positions[this.positions.length - 1]);
            }
        }

        public Coordinate getNthBitPosition(int n) {
            return this.positions[n];
        }
    }

    private static class PistonEmitterCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID uid;
        private final ForgeDirection facing;

        private PistonEmitterCallback(PistonTapeSlice p) {
            this.uid = ((PistonTapeGenerator)((PistonTapeSlice)p).parent).id;
            this.facing = p.facing;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            BlockLaserEffector.EmitterTile e = (BlockLaserEffector.EmitterTile)te;
            e.uid = this.uid;
            e.setDirection(ReikaDirectionHelper.CubeDirections.getFromForgeDirection((ForgeDirection)this.facing));
            e.setColor(new RGBColorData(true, true, true));
            e.speedFactor = 1.25;
            e.uid = this.uid;
            e.silent = true;
            e.renderAsFullBlock = true;
        }
    }

    private static class PistonTargetCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID uid;
        private final ForgeDirection facing;
        private final int index;
        private final int width;
        private final int stage;

        private PistonTargetCallback(PistonTapeSlice p, TapeStage s) {
            this.uid = ((PistonTapeGenerator)((PistonTapeSlice)p).parent).id;
            this.index = p.busIndex;
            this.facing = p.facing;
            this.width = ((PistonTapeSlice)p).loop.busWidth;
            this.stage = s.index;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            BlockPistonTarget.PistonEmitterTile e = (BlockPistonTarget.PistonEmitterTile)te;
            e.setData(this.facing, this.stage, -1, this.index, this.width);
            e.uid = this.uid;
        }
    }
}

