/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeStage;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class PistonTapeStaircase
extends StructurePiece<PistonTapeGenerator> {
    private static final int RADIUS = 2;
    private final Coordinate c1;
    private final Coordinate c2;
    private final Random rand;
    private final ForgeDirection main;

    public PistonTapeStaircase(PistonTapeGenerator gen, TapeStage s1, TapeStage s2, Random r) {
        super(gen);
        this.main = s1.mainDirection;
        this.c1 = s1.getExit().offset(this.main, 2);
        this.c2 = s2.getEntrance().offset(this.main, 2);
        this.rand = r;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        double lx = this.c2.xCoord - this.c1.xCoord;
        double ly = this.c2.yCoord - this.c1.yCoord;
        double lz = this.c2.zCoord - this.c1.zCoord;
        for (double d = 0.0; d <= 1.0; d += 0.0078125) {
            double dx = (double)this.c1.xCoord + lx * d;
            double dy = (double)this.c1.yCoord + ly * d;
            double dz = (double)this.c1.zCoord + lz * d;
            int mx = MathHelper.func_76128_c((double)(dx - 2.0));
            int my = MathHelper.func_76128_c((double)(dy - 2.0));
            int mz = MathHelper.func_76128_c((double)(dz - 2.0));
            int px = MathHelper.func_76128_c((double)(dx + 2.0));
            int py = MathHelper.func_76128_c((double)(dy + 2.0));
            int pz = MathHelper.func_76128_c((double)(dz + 2.0));
            for (int i = mx; i <= px; ++i) {
                for (int j = my; j <= py; ++j) {
                    for (int k = mz; k <= pz; ++k) {
                        set.add(new Coordinate(i, j, k));
                    }
                }
            }
        }
        for (Coordinate c : set) {
            Block b = Blocks.field_150350_a;
            int m = 0;
            for (Coordinate c2 : c.getAdjacentCoordinates()) {
                if (set.contains(c2)) continue;
                b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                m = this.rand.nextInt(12) == 0 && set.contains(c.offset(0, 1, 0)) && set.contains(c.offset(0, -1, 0)) ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata;
                break;
            }
            c.setBlock(world, b, m);
        }
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.main);
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                int dx = this.c1.xCoord + left.offsetX * i + this.main.offsetX * -2;
                int dz = this.c1.zCoord + left.offsetZ * i + this.main.offsetZ * -2;
                int dy = this.c1.yCoord + k;
                world.setBlock(dx, dy, dz, Blocks.field_150350_a);
                dx = this.c2.xCoord + left.offsetX * i + this.main.offsetX * -2;
                dz = this.c2.zCoord + left.offsetZ * i + this.main.offsetZ * -2;
                dy = this.c2.yCoord + k;
                world.setBlock(dx, dy, dz, Blocks.field_150350_a);
            }
        }
    }
}

