/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Dimension.Structure.Laser.BlockLaserEffector;
import Reika.ChromatiCraft.Block.Dimension.Structure.PistonTape.BlockPistonTarget;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.DoorKey;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.DoorSection;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.PistonTapeAccessHall;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.PistonTapeEntryArea;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.PistonTapeLoop;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeArea;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.RGBColorData;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TapeStage
extends StructurePiece<PistonTapeGenerator> {
    private static final int MIN_ID = 1;
    private final DoorSection[] doors;
    private final HashSet<Integer> generatedIDs = new HashSet();
    final TapeArea tape;
    public final ForgeDirection mainDirection;
    public final int index;
    public final int doorCount;
    public final int bitsPerDoor;
    public final int totalBitWidth;
    public final int height;
    private Coordinate exit;
    private Coordinate entrance;
    private boolean[] pings;

    public TapeStage(PistonTapeGenerator g, int idx, int bus, int n, ForgeDirection dir, Random rand) {
        super(g);
        this.index = idx;
        this.doorCount = n;
        this.bitsPerDoor = bus;
        this.totalBitWidth = bus * n;
        this.mainDirection = dir;
        this.tape = new TapeArea(g, this.mainDirection, new PistonTapeLoop(g, ReikaDirectionHelper.getRightBy90((ForgeDirection)this.mainDirection), this));
        this.tape.tape.randomize(rand);
        this.height = this.tape.tape.dimensions.totalHeight + 3;
        this.doors = new DoorSection[this.doorCount];
        for (int i = 0; i < this.doorCount; ++i) {
            DoorKey dk = new DoorKey(i, this.getColorList(i));
            this.doors[i] = new DoorSection(g, this, this.mainDirection, dk, i, i == this.doorCount - 1);
        }
        this.pings = new boolean[this.doorCount];
    }

    public ArrayList<DoorKey> getDisplayList() {
        ArrayList<DoorKey> li = new ArrayList<DoorKey>();
        for (DoorSection s : this.doors) {
            li.add(s.doorData);
        }
        return li;
    }

    public Coordinate getEntrance() {
        return this.entrance;
    }

    public Coordinate getExit() {
        return this.exit;
    }

    private RGBColorData[] getColorList(int i) {
        RGBColorData[] data = new RGBColorData[this.bitsPerDoor];
        for (int d = 0; d < data.length; ++d) {
            data[d] = this.tape.tape.getColor(d, i);
        }
        return data;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        int dx = x;
        int dz = z;
        this.entrance = new Coordinate(x - this.tape.tape.facing.offsetX * 3 - this.mainDirection.offsetX, y + 2, z - this.tape.tape.facing.offsetZ * 3 - this.mainDirection.offsetZ);
        new PistonTapeEntryArea((PistonTapeGenerator)this.parent, this, this.tape).generate(world, dx - this.tape.tape.facing.offsetX, y, dz - this.tape.tape.facing.offsetZ);
        this.tape.generate(world, (dx += 4 * this.mainDirection.offsetX) - this.tape.tape.facing.offsetX * 6, y, (dz += 4 * this.mainDirection.offsetZ) - this.tape.tape.facing.offsetZ * 6);
        new PistonTapeAccessHall((PistonTapeGenerator)this.parent, this.tape).generate(world, (dx += (2 + this.tape.tape.busWidth) * this.mainDirection.offsetX) - this.tape.tape.facing.offsetX, y, (dz += (2 + this.tape.tape.busWidth) * this.mainDirection.offsetZ) - this.tape.tape.facing.offsetZ);
        dx += (5 + this.tape.tape.busWidth / 2) * this.mainDirection.offsetX;
        dz += (5 + this.tape.tape.busWidth / 2) * this.mainDirection.offsetZ;
        for (DoorSection s : this.doors) {
            s.generate(world, dx, y, z);
            dx += (s.getLength() + 1) * this.mainDirection.offsetX;
            dz += (s.getLength() + 1) * this.mainDirection.offsetZ;
        }
        this.exit = new Coordinate(dx - this.tape.tape.facing.offsetX * 3, y + 2, dz - this.tape.tape.facing.offsetZ * 3);
    }

    public void fireEmitters(World world, int stage) {
        for (int i = 0; i < this.bitsPerDoor; ++i) {
            Coordinate c = this.tape.tape.getEmitter(i);
            BlockLaserEffector.EmitterTile te = (BlockLaserEffector.EmitterTile)c.getTileEntity((IBlockAccess)world);
            te.fire();
            c = this.tape.tape.getTarget(i);
            BlockPistonTarget.PistonEmitterTile pt = (BlockPistonTarget.PistonEmitterTile)c.getTileEntity((IBlockAccess)world);
            pt.setTarget(stage, this.doors[stage].doorData.getValue(i).getTargetLocation(), this.mainDirection, this.getHallSplinePoints(i));
        }
    }

    private ArrayList<Coordinate> getHallSplinePoints(int idx) {
        ArrayList<Coordinate> li = new ArrayList<Coordinate>();
        Coordinate c = this.tape.tape.getTarget(idx).offset(this.tape.tape.facing, -4);
        li.add(c);
        c = c.offset(this.mainDirection, 3);
        li.add(c);
        c = c.offset(this.tape.tape.facing, -5);
        li.add(c);
        return li;
    }

    public boolean cycle(World world) {
        return this.tape.tape.cycle(world);
    }

    public int getTotalLength() {
        return this.tape.tape.dimensions.bitLength;
    }

    public int getDirectionLength() {
        int base = 10 + this.tape.getWidth();
        for (DoorSection s : this.doors) {
            base += s.getLength() + 1;
        }
        return base;
    }

    public UUID getID() {
        return ((PistonTapeGenerator)this.parent).id;
    }

    public void openAllDoors(World world) {
        for (DoorSection s : this.doors) {
            s.forceOpenDoor(world);
        }
        this.pings = ReikaArrayHelper.getTrueArray((int)this.doorCount);
    }

    public void validate(int door) {
        this.pings[door] = true;
    }

    public void resetValidate() {
        this.pings = new boolean[this.doorCount];
    }

    public boolean isSolved() {
        return ReikaArrayHelper.isAllTrue((boolean[])this.pings);
    }
}

