/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.PistonTapeData;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.PistonTapeEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.PistonTapeLootRoom;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.PistonTapeStaircase;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeStage;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PistonTapeGenerator
extends DimensionStructureGenerator {
    public static final boolean DEBUG = false;
    private TapeStage[] stages;
    private boolean isActive = false;
    public static final ForgeDirection DIRECTION = ForgeDirection.EAST;

    @Override
    protected void calculate(int chunkX, int chunkZ, Random rand) {
        int i;
        int y;
        int x = chunkX;
        int z = chunkZ;
        this.posY = y = 60 + rand.nextInt(30);
        PistonTapeParameters[] arr = this.getTapes();
        this.stages = new TapeStage[arr.length];
        ForgeDirection dir = DIRECTION;
        for (i = 0; i < arr.length; ++i) {
            PistonTapeParameters p = arr[i];
            TapeStage s = new TapeStage(this, i, p.busWidth, p.doorCount, dir, rand);
            ForgeDirection dir2 = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
            int dx = x + dir2.offsetX * 12;
            int dz = z + dir2.offsetZ * 12;
            s.generate(this.world, dx, y, dz);
            this.stages[i] = s;
            x += dir.offsetX * s.getDirectionLength();
            z += dir.offsetZ * s.getDirectionLength();
            y -= Math.max(6, s.height);
            dir = dir.getOpposite();
        }
        for (i = 0; i < this.stages.length - 1; ++i) {
            TapeStage s1 = this.stages[i];
            TapeStage s2 = this.stages[i + 1];
            PistonTapeStaircase p = new PistonTapeStaircase(this, s1, s2, rand);
            p.generate(this.world, x, y, z);
        }
        TapeStage last = this.stages[this.stages.length - 1];
        Coordinate end = last.getExit();
        new PistonTapeLootRoom(this, dir.getOpposite(), rand).generate(this.world, end.xCoord, end.yCoord, end.zCoord);
        Coordinate start = this.stages[0].getEntrance().offset(DIRECTION.getOpposite(), 2);
        this.addDynamicStructure(new PistonTapeEntrance(this, start, DIRECTION), start.xCoord, start.zCoord);
    }

    @Override
    public StructureData createDataStorage() {
        return new PistonTapeData(this);
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    protected boolean hasBeenSolved(World world) {
        for (TapeStage s : this.stages) {
            if (s.isSolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void openStructure(World world) {
        for (TapeStage s : this.stages) {
            s.openAllDoors(world);
        }
    }

    @Override
    protected void clearCaches() {
        this.stages = null;
    }

    private PistonTapeParameters[] getTapes() {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return new PistonTapeParameters[]{new PistonTapeParameters(2, 5), new PistonTapeParameters(2, 8), new PistonTapeParameters(3, 6)};
            }
            case 2: {
                return new PistonTapeParameters[]{new PistonTapeParameters(2, 6), new PistonTapeParameters(3, 8), new PistonTapeParameters(3, 10)};
            }
        }
        return new PistonTapeParameters[]{new PistonTapeParameters(2, 8), new PistonTapeParameters(3, 9), new PistonTapeParameters(3, 12), new PistonTapeParameters(4, 12)};
    }

    public TapeStage getStage(int i) {
        return this.stages[i];
    }

    public int stageCount() {
        return this.stages.length;
    }

    private static class PistonTapeParameters {
        private final int busWidth;
        private final int doorCount;

        private PistonTapeParameters(int w, int l) {
            this.busWidth = w;
            this.doorCount = l;
        }
    }
}

