/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.RayBlend;

import Reika.ChromatiCraft.Base.DynamicStructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.RayBlendGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RayBlendEntrance
extends DynamicStructurePiece<RayBlendGenerator> {
    public RayBlendEntrance(RayBlendGenerator s) {
        super(s);
    }

    @Override
    public void generate(World world, int x, int z) {
        int m;
        int i;
        int y1 = ((RayBlendGenerator)this.parent).getPosY() + 2;
        Random rand = new Random();
        int y2 = world.func_72825_h(x -= 6, z);
        int y = y1;
        EntranceLevel last = null;
        int dx = 0;
        int dz = 0;
        int floor = 0;
        while (y + 5 + 3 < y2) {
            int sX = last != null ? last.shaftUp.x : Integer.MIN_VALUE;
            int sZ = last != null ? last.shaftUp.y : Integer.MIN_VALUE;
            EntranceLevel el = new EntranceLevel(rand, floor, x, z, sX, sZ);
            ++floor;
            el.generate(world, x, y, z);
            y += 8;
            last = el;
            dx = x + last.getUpperShaftXCenterOffset();
            dz = z + last.getUpperShaftZCenterOffset();
        }
        while (y <= y2) {
            EntranceLevel.generateShaft(world, dx, y, dz);
            ++y;
        }
        for (i = -3; i <= 3; ++i) {
            for (int k = -3; k <= 3; ++k) {
                if (Math.abs(i) != 3 && Math.abs(k) != 3) continue;
                world.func_147465_d(dx + i, y2 - 1, dz + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata, 3);
            }
        }
        for (i = 0; i <= 4; ++i) {
            m = i == 4 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata;
            world.func_147465_d(dx - 1 - 1, y2 + i, dz + 1 + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
            world.func_147465_d(dx - 1 - 1, y2 + i, dz - 1 - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
            world.func_147465_d(dx + 1 + 1, y2 + i, dz + 1 + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
            world.func_147465_d(dx + 1 + 1, y2 + i, dz - 1 - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
        }
        for (i = -1; i <= 2; ++i) {
            m = i == 2 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.COBBLE.metadata;
            world.func_147465_d(dx - 4 - 1, y2 + i, dz + 4 + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
            world.func_147465_d(dx - 4 - 1, y2 + i, dz - 4 - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
            world.func_147465_d(dx + 4 + 1, y2 + i, dz + 4 + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
            world.func_147465_d(dx + 4 + 1, y2 + i, dz - 4 - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
            if (i != -1) continue;
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a != 0 && b != 0) continue;
                    world.func_147465_d(dx - 4 - 1 + a, y2 + i, dz + 4 + 1 + b, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                    world.func_147465_d(dx - 4 - 1 + a, y2 + i, dz - 4 - 1 + b, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                    world.func_147465_d(dx + 4 + 1 + a, y2 + i, dz + 4 + 1 + b, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                    world.func_147465_d(dx + 4 + 1 + a, y2 + i, dz - 4 - 1 + b, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                }
            }
        }
        for (i = 0; i < 8; ++i) {
            int dy;
            double ang;
            int r = ReikaRandomHelper.getRandomBetween((int)6, (int)16);
            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)r, (double)0.0, (double)(ang = rand.nextDouble() * 360.0));
            dx = x + MathHelper.func_76128_c((double)xyz[0]);
            if (world.func_147439_a(dx, dy = world.func_72825_h(dx, dz = z + MathHelper.func_76128_c((double)xyz[2])) - 1, dz) != Blocks.field_150349_c) continue;
            CrystalDeposit cry = new CrystalDeposit(dx, dy, dz);
            cry.calculate(world);
            cry.generate(world);
        }
    }

    private static class Cell {
        private static final int HOLE_RADIUS = 1;
        private static final int TOTAL_RADIUS = 2;
        private final int xPos;
        private final int zPos;
        private final int rootX;
        private final int rootZ;
        private boolean openCeiling;
        private boolean openFloor;
        private boolean hasLoot;
        private boolean[] sides = new boolean[4];

        private Cell(int x, int z, int rx, int rz) {
            this.xPos = x;
            this.zPos = z;
            this.rootX = rx;
            this.rootZ = rz;
        }

        public boolean canHaveLoot() {
            return !this.openCeiling && !this.openFloor && this.countWalls() == 3;
        }

        private int countWalls() {
            return 4 - ReikaArrayHelper.countTrue((boolean[])this.sides);
        }

        private Cell getNeighbor(EntranceLevel el, ForgeDirection dir) {
            int dx = this.xPos + dir.offsetX;
            int dz = this.zPos + dir.offsetZ;
            return (Cell)el.cells.get(new Point(dx, dz));
        }

        private void generate(World world, int y) {
            int dz;
            int dx;
            int r = 1;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    dx = this.getCenterX(true) + i;
                    dz = this.getCenterZ(true) + k;
                    if (Math.abs(i) <= 1 && Math.abs(k) <= 1) {
                        if (this.openFloor) {
                            world.func_147449_b(dx, y, dz, Blocks.field_150350_a);
                        } else {
                            world.func_147465_d(dx, y, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, 3);
                        }
                        if (this.openCeiling) {
                            world.func_147449_b(dx, y + 5, dz, Blocks.field_150350_a);
                            continue;
                        }
                        world.func_147465_d(dx, y + 5, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, 3);
                        continue;
                    }
                    world.func_147465_d(dx, y, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata, 3);
                }
            }
            for (int d = 0; d < 4; ++d) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[2 + d];
                dx = this.getCenterX(true) + dir.offsetX * 2;
                dz = this.getCenterZ(true) + dir.offsetZ * 2;
                for (int h = 1; h < 5; ++h) {
                    for (int a = -1; a <= 1; ++a) {
                        int m;
                        boolean air = this.sides[d] || Math.abs(this.xPos + dir.offsetX) > 1 || Math.abs(this.zPos + dir.offsetZ) > 1;
                        Block b = air ? Blocks.field_150350_a : ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                        int n = m = air ? 0 : BlockStructureShield.BlockType.GLASS.metadata;
                        if (dir.offsetX == 0) {
                            world.func_147465_d(dx + a, y + h, dz, b, m, 3);
                            continue;
                        }
                        world.func_147465_d(dx, y + h, dz + a, b, m, 3);
                    }
                }
            }
            if (this.hasLoot) {
                int x = this.getCenterX(true);
                int z = this.getCenterZ(true);
                for (int i = -1; i <= 1; ++i) {
                    for (int k = -1; k <= 1; ++k) {
                        int m = i == 0 && k == 0 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.CLOAK.metadata;
                        world.func_147465_d(x + i, y, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
                    }
                }
                ForgeDirection dir = ForgeDirection.UNKNOWN;
                for (int i = 0; i < this.sides.length; ++i) {
                    if (!this.sides[i]) continue;
                    dir = ForgeDirection.VALID_DIRECTIONS[2 + i];
                    break;
                }
                this.generateLootChest(world, x, y + 1, z, dir);
            }
        }

        private void generateLootChest(World world, int x, int y, int z, ForgeDirection dir) {
            world.func_147465_d(x, y, z, ChromaBlocks.LOOTCHEST.getBlockInstance(), BlockLootChest.getMeta(dir), 3);
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof BlockLootChest.TileEntityLootChest) {
                BlockLootChest.TileEntityLootChest tc = (BlockLootChest.TileEntityLootChest)te;
                tc.populateChest("strongholdCrossing", null, 0, world.field_73012_v);
            }
        }

        private int getCenterX(boolean real) {
            return real ? this.rootX : this.xPos * 5;
        }

        private int getCenterZ(boolean real) {
            return real ? this.rootZ : this.zPos * 5;
        }
    }

    private static class EntranceLevel {
        private static final int HEIGHT = 5;
        private static final int SEP = 3;
        private static final int GRID_RADIUS = 1;
        private static final int CELL_SPACING = 4;
        private final HashMap<Point, Cell> cells = new HashMap();
        private final Point shaftDown;
        private final Point shaftUp;
        private final int floorIndex;
        private final ArrayList<Point> path = new ArrayList();

        private EntranceLevel(Random rand, int fn, int rx, int rz, int xd, int zd) {
            this.floorIndex = fn;
            this.shaftDown = xd != Integer.MIN_VALUE ? new Point(xd, zd) : null;
            Point p = new Point(EntranceLevel.rand(), EntranceLevel.rand());
            while (p.equals(this.shaftDown)) {
                p = new Point(EntranceLevel.rand(), EntranceLevel.rand());
            }
            this.shaftUp = p;
            for (int i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    int x = rx + i * 4;
                    int z = rz + k * 4;
                    this.cells.put(new Point(i, k), new Cell(i, k, x, z));
                }
            }
            this.calculatePath(rand);
            if (this.shaftDown != null) {
                this.cells.get(this.shaftDown).openFloor = true;
            }
            this.cells.get(this.shaftUp).openCeiling = true;
            int n1 = 0;
            int n2 = Math.max(1, 0);
            int n = ReikaRandomHelper.getRandomBetween((int)n1, (int)n2);
            int amt = 0;
            for (Cell c : this.cells.values()) {
                if (c.canHaveLoot() && (this.floorIndex != 0 || c.xPos != 1 || c.zPos != 0)) {
                    c.hasLoot = true;
                    ++amt;
                }
                if (amt < n) continue;
                break;
            }
            for (Point pt : this.path) {
                Cell c = this.cells.get(pt);
                ArrayList<ForgeDirection> li = new ArrayList<ForgeDirection>();
                for (int i = 0; i < c.sides.length; ++i) {
                    if (!c.sides[i]) continue;
                    li.add(ForgeDirection.VALID_DIRECTIONS[2 + i]);
                }
                Collections.sort(li);
            }
        }

        private void calculatePath(Random rand) {
            Point p = this.shaftUp;
            Point end = this.shaftDown != null ? this.shaftDown : new Point(1, 0);
            int dx = p.x - end.x;
            int dz = p.y - end.y;
            while (dx != 0 || dz != 0) {
                this.path.add(p);
                boolean moveX = dx != 0 && dz != 0 ? rand.nextBoolean() : dx != 0;
                int sx = moveX ? -((int)Math.signum(dx)) : 0;
                int sz = moveX ? 0 : -((int)Math.signum(dz));
                p = new Point(p.x + sx, p.y + sz);
                dx = p.x - end.x;
                dz = p.y - end.y;
            }
            if (!p.equals(end)) {
                throw new RuntimeException("Path " + this.path + " ended early at " + p + ", before " + end);
            }
            this.path.add(end);
            for (int i = 1; i < this.path.size(); ++i) {
                Point p0 = this.path.get(i - 1);
                Point p1 = this.path.get(i);
                this.connect(p0, p1);
            }
            HashSet<Point> unconnected = new HashSet<Point>(this.cells.keySet());
            unconnected.removeAll(this.path);
            while (!unconnected.isEmpty()) {
                Point pr = (Point)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, unconnected);
                ArrayList<Point> subpath = new ArrayList<Point>();
                boolean pathed = false;
                while (!pathed) {
                    Point next = this.getValidRandomNeighbor(pr, rand);
                    subpath.add(pr);
                    if (!unconnected.contains(next)) {
                        subpath.add(next);
                        unconnected.removeAll(subpath);
                        pathed = true;
                        for (int i = 1; i < subpath.size(); ++i) {
                            Point p0 = (Point)subpath.get(i - 1);
                            Point p1 = (Point)subpath.get(i);
                            this.connect(p0, p1);
                        }
                        continue;
                    }
                    pr = next;
                }
            }
        }

        private Point getValidRandomNeighbor(Point pr, Random rand) {
            ArrayList li = ReikaDirectionHelper.getRandomOrderedDirections((boolean)false);
            while (!li.isEmpty()) {
                int idx = rand.nextInt(li.size());
                ForgeDirection dir = (ForgeDirection)li.remove(idx);
                Point p2 = new Point(pr.x + dir.offsetX, pr.y + dir.offsetZ);
                if (!this.isInGrid(p2)) continue;
                return p2;
            }
            return null;
        }

        private boolean isInGrid(Point p) {
            return Math.abs(p.x) <= 1 && Math.abs(p.y) <= 1;
        }

        private void connect(Point p1, Point p2) {
            ForgeDirection side = ReikaDirectionHelper.getDirectionBetween((Point)p1, (Point)p2);
            if (side == null) {
                throw new IllegalArgumentException("You cannot link two non-adjacent points " + p1 + ", " + p2 + " from " + this.path);
            }
            Cell c1 = this.cells.get(p1);
            Cell c2 = this.cells.get(p2);
            ((Cell)c1).sides[side.ordinal() - 2] = true;
            ((Cell)c2).sides[side.getOpposite().ordinal() - 2] = true;
        }

        private void generate(World world, int x, int y, int z) {
            int r = 7;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    int dx = x + i;
                    int dz = z + k;
                    world.func_147465_d(dx, y, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata, 3);
                    world.func_147465_d(dx, y + 5, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata, 3);
                    for (int h = 1; h < 5; ++h) {
                        world.func_147449_b(dx, y + h, dz, Blocks.field_150350_a);
                    }
                }
            }
            for (Cell c : this.cells.values()) {
                c.generate(world, y);
            }
            for (int h = 1; h < 5; ++h) {
                int i;
                for (int d = -r; d <= r; ++d) {
                    world.func_147465_d(x + d, y + h, z - r, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), world.field_73012_v.nextInt(12) == 0 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata, 3);
                    world.func_147465_d(x + d, y + h, z + r, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), world.field_73012_v.nextInt(12) == 0 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata, 3);
                    world.func_147465_d(x - r, y + h, z + d, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), world.field_73012_v.nextInt(12) == 0 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata, 3);
                    world.func_147465_d(x + r, y + h, z + d, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), world.field_73012_v.nextInt(12) == 0 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata, 3);
                }
                if (this.floorIndex == 0) {
                    for (i = -1; i <= 1; ++i) {
                        for (int d = 1; d <= 3; ++d) {
                            world.func_147449_b(x + r, y + d, z + i, Blocks.field_150350_a);
                        }
                        world.func_147465_d(x + r - 1, y + 4, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata, 3);
                    }
                }
                for (i = -2; i <= 1; ++i) {
                    for (int k = -2; k <= 1; ++k) {
                        world.func_147465_d(x + i * 4 + 2, y + h, z + k * 4 + 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata, 3);
                    }
                }
            }
            world.func_147465_d(x + 1 + 1, y + 2, z + 1 + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata, 3);
            world.func_147465_d(x + 1 + 1, y + 2, z - 1 - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata, 3);
            world.func_147465_d(x - 1 - 1, y + 2, z + 1 + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata, 3);
            world.func_147465_d(x - 1 - 1, y + 2, z - 1 - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata, 3);
            for (int i = 6; i <= 8; ++i) {
                EntranceLevel.generateShaft(world, x + this.getUpperShaftXCenterOffset(), y + i, z + this.getUpperShaftZCenterOffset());
            }
        }

        private int getLowerShaftXCenterOffset() {
            return this.shaftDown.x * 4;
        }

        private int getLowerShaftZCenterOffset() {
            return this.shaftDown.y * 4;
        }

        private int getUpperShaftXCenterOffset() {
            return this.shaftUp.x * 4;
        }

        private int getUpperShaftZCenterOffset() {
            return this.shaftUp.y * 4;
        }

        private static int rand() {
            return ReikaRandomHelper.getRandomPlusMinus((int)0, (int)1);
        }

        private static void generateShaft(World world, int x, int y, int z) {
            int r = 2;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    if (Math.abs(i) == r || Math.abs(k) == r) {
                        world.func_147465_d(x + i, y, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, 3);
                        continue;
                    }
                    world.func_147449_b(x + i, y, z + k, Blocks.field_150350_a);
                }
            }
        }
    }

    private static class CrystalDeposit {
        private final Coordinate origin;
        private final Random rand = new Random();
        private final HashSet<Coordinate> crystals = new HashSet();
        private final HashSet<Coordinate> edge = new HashSet();

        private CrystalDeposit(int x, int y, int z) {
            this.origin = new Coordinate(x, y, z);
        }

        private void calculate(World world) {
            int arms = 2 + this.rand.nextInt(4);
            for (int i = 0; i < arms; ++i) {
                this.calculateArm(world);
            }
            for (Coordinate c : this.crystals) {
                for (Coordinate c2 : c.getAdjacentCoordinates()) {
                    for (int i = 0; i <= 3; ++i) {
                        Coordinate c3 = c2.offset(0, i, 0);
                        this.edge.add(c3);
                    }
                }
            }
            this.edge.removeAll(this.crystals);
        }

        private void calculateArm(World world) {
            ForgeDirection dir = ReikaDirectionHelper.getRandomDirection((boolean)false, (Random)this.rand);
            int maxl = 6 + this.rand.nextInt(15);
            Coordinate c = this.origin;
            for (int d = 0; d < maxl; ++d) {
                this.crystals.add(c);
                c = c.offset(dir, 1);
                if (c.getBlock((IBlockAccess)world) != Blocks.field_150349_c) break;
                if (this.rand.nextInt(3) != 0) continue;
                dir = ReikaDirectionHelper.getRandomDirection((boolean)false, (Random)this.rand);
            }
        }

        private void generate(World world) {
            for (Coordinate c : this.edge) {
                if (c.yCoord > this.origin.yCoord) {
                    c.setBlock(world, Blocks.field_150350_a);
                    continue;
                }
                c.setBlock(world, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
            }
            for (Coordinate c : this.crystals) {
                c.setBlock(world, ChromaBlocks.CRYSTAL.getBlockInstance(), this.rand.nextInt(16), 3);
            }
        }
    }
}

