/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.RayBlend;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.OverlayColor;
import Reika.ChromatiCraft.Base.CrystalTypeBlock;
import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Dimension.Structure.BlockRayblendFloor;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Magic.ElementMixer;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.World.Dimension.Structure.RayBlend.PuzzleProfile;
import Reika.ChromatiCraft.World.Dimension.Structure.RayBlendGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RayBlendPuzzle
extends StructurePiece<RayBlendGenerator> {
    public final int roomIndex;
    private final int gridSize;
    private final float initialFillFraction;
    private final HashMap<Point, Subgrid> grids = new HashMap();
    private final HashMap<Point, GridCage> cages = new HashMap();
    private final HashMap<Point, CrystalMix> mixPoints = new HashMap();
    private final HashSet<Point> unGriddedPoints = new HashSet();
    private final HashSet<Subgrid> unfinished = new HashSet();
    private final HashSet<GridSlot> uncaged = new HashSet();
    private final HashSet<GridSlot> candidateStarts = new HashSet();
    private final HashSet<Coordinate> doors = new HashSet();
    private Coordinate generatorOrigin;
    private boolean isComplete;
    private final int edgeLength;
    private final int totalCellCount;
    private final int cellsPerSubgrid;
    public final UUID ID = UUID.randomUUID();
    private static boolean GENERATE_SOLVED = false;
    public static final int PADDING_LOWER = 3;
    public static final int STEP_HEIGHT = 1;
    public static final int PADDING_UPPER = 4;
    private BlockBox generationBounds = BlockBox.nothing();
    private Coordinate bypassCoord;

    public RayBlendPuzzle(RayBlendGenerator s, int i, int sz, float f, Random rand) {
        super(s);
        this.roomIndex = i;
        this.gridSize = sz;
        this.initialFillFraction = f;
        this.edgeLength = this.gridSize * this.gridSize;
        this.totalCellCount = this.edgeLength * this.edgeLength;
        this.cellsPerSubgrid = this.edgeLength;
    }

    public boolean prepare(PuzzleProfile p, Random rand) {
        Subgrid.CURRENTINDEX = 0;
        for (int i = 0; i < this.edgeLength; ++i) {
            for (int k = 0; k < this.edgeLength; ++k) {
                this.unGriddedPoints.add(new Point(i, k));
            }
        }
        boolean flag = this.generateGrids(rand);
        if (flag) {
            this.randomize(p, rand);
        }
        return flag;
    }

    public void addDoor(Coordinate c) {
        this.doors.add(c);
    }

    private void debugPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.edgeLength; ++i) {
            sb.append("[");
            for (int k = 0; k < this.edgeLength; ++k) {
                Subgrid gs = this.grids.get(new Point(i, k));
                if (gs == null) {
                    sb.append("0");
                    continue;
                }
                char c = (char)(65 + gs.index);
                sb.append(c);
            }
            sb.append("]\n");
        }
        sb.append("}\n");
        ReikaJavaLibrary.pConsole((Object)sb.toString());
    }

    private Subgrid getOrCreateSubgridFor(int x, int z) {
        Subgrid sg = this.grids.get(new Point(x, z));
        if (sg == null) {
            sg = new Subgrid(this);
        }
        sg.createSlot(x, z);
        return sg;
    }

    private boolean generateGrids(Random rand) {
        while (!this.unGriddedPoints.isEmpty()) {
            Subgrid sg = new Subgrid(this);
            if (!this.populate(sg, rand)) {
                return false;
            }
            this.uncaged.addAll(sg.slots.values());
            this.unfinished.add(sg);
            for (GridSlot gs : sg.slots.values()) {
                this.grids.put(gs.positionKey(), sg);
            }
        }
        return this.isNotUniform(rand);
    }

    private boolean isNotUniform(Random rand) {
        Subgrid g1 = (Subgrid)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, this.grids.values());
        for (Subgrid g : this.grids.values()) {
            if (g1.isCongruent(g)) continue;
            return true;
        }
        return false;
    }

    private boolean populate(Subgrid sg, Random rand) {
        HashSet<Point> starts = new HashSet<Point>(this.unGriddedPoints);
        for (int attempts0 = 0; attempts0 < 80; ++attempts0) {
            boolean valid;
            Point start = this.getWeightedRandomStart(rand, starts);
            starts.remove(start);
            if (start == null) {
                return false;
            }
            boolean bl = valid = this.unGriddedPoints.size() == this.totalCellCount || this.canExpandInto(sg, start);
            if (!valid) continue;
            sg.createSlot(start.x, start.y);
            break;
        }
        int attempts = 0;
        while (attempts < 80) {
            ++attempts;
            while (sg.size() < this.cellsPerSubgrid) {
                Point p = this.getCandidateNextPoint(sg, rand);
                if (p == null) {
                    sg.clear();
                    break;
                }
                sg.createSlot(p.x, p.y);
            }
            if (sg.size() != this.cellsPerSubgrid || !(sg.getStringiness() <= this.getMaxAllowedStringiness())) continue;
            return true;
        }
        return false;
    }

    private double getMaxAllowedStringiness() {
        switch (this.gridSize) {
            case 1: 
            case 2: {
                return 1.0;
            }
            case 3: {
                return 0.9;
            }
            case 4: {
                return 0.7;
            }
            case 5: {
                return 0.55;
            }
            case 6: {
                return 0.4;
            }
        }
        return Math.max(0.1, 0.4 - 0.05 * (double)(this.gridSize - 6));
    }

    private Point getWeightedRandomStart(Random rand, HashSet<Point> starts) {
        if (starts.isEmpty()) {
            return null;
        }
        WeightedRandom wr = new WeightedRandom();
        for (Point p : starts) {
            wr.addEntry((Object)p, (double)this.getFilledNeighbors(p));
        }
        return wr.isEmpty() ? null : (Point)wr.getRandomEntry();
    }

    private int getFilledNeighbors(Point p) {
        Collection<Point> c = this.getNeighbors(p);
        int ret = c.size();
        for (Point p2 : c) {
            if (!this.unGriddedPoints.contains(p2)) continue;
            --ret;
        }
        if (p.x == 0) {
            ++ret;
        }
        if (p.y == 0) {
            ++ret;
        }
        if (p.x == this.edgeLength - 1) {
            ++ret;
        }
        if (p.y == this.edgeLength - 1) {
            ++ret;
        }
        return ret;
    }

    private Collection<Point> getNeighbors(Point p) {
        ArrayList<Point> c = new ArrayList<Point>();
        if (p.x > 0) {
            c.add(new Point(p.x - 1, p.y));
        }
        if (p.x < this.edgeLength - 1) {
            c.add(new Point(p.x + 1, p.y));
        }
        if (p.y > 0) {
            c.add(new Point(p.x, p.y - 1));
        }
        if (p.y < this.edgeLength - 1) {
            c.add(new Point(p.x, p.y + 1));
        }
        return c;
    }

    private Point getCandidateNextPoint(Subgrid sg, Random rand) {
        HashSet<Point> set = new HashSet<Point>();
        for (Object p : sg.slots.keySet()) {
            set.addAll(this.getNeighbors((Point)p));
        }
        set.retainAll(this.unGriddedPoints);
        if (set.isEmpty()) {
            return null;
        }
        WeightedRandom wr = new WeightedRandom();
        for (Point p : set) {
            HashSet<Point> points = new HashSet<Point>(set);
            points.add(p);
            wr.addEntry((Object)p, 100.0 - 100.0 * this.calcStringiness(points));
        }
        while (!set.isEmpty()) {
            Object p;
            p = (Point)wr.getRandomEntry();
            if (this.canExpandInto(sg, (Point)p)) {
                return p;
            }
            set.remove(p);
            wr.remove(p);
        }
        return null;
    }

    private boolean canExpandInto(Subgrid sg, Point p) {
        Collection<Point> c = this.getNeighbors(p);
        c.retainAll(this.unGriddedPoints);
        if (c.isEmpty()) {
            return true;
        }
        HashSet<Point> visited = new HashSet<Point>();
        visited.add(p);
        ArrayList<LinkedList> groups = new ArrayList<LinkedList>();
        for (Point p2 : this.unGriddedPoints) {
            if (visited.contains(p2)) continue;
            LinkedList li = new LinkedList();
            LinkedList<Point> li2 = new LinkedList<Point>();
            groups.add(li);
            li2.add(p2);
            while (!li2.isEmpty()) {
                Point p3 = (Point)li2.removeLast();
                if (visited.contains(p3)) continue;
                visited.add(p3);
                li.add(p3);
                for (Point np3 : this.getNeighbors(p3)) {
                    if (visited.contains(np3) || !this.unGriddedPoints.contains(np3)) continue;
                    li2.add(np3);
                }
            }
        }
        if (groups.size() == 1) {
            return true;
        }
        Collections.sort(groups, new Comparator<LinkedList>(){

            @Override
            public int compare(LinkedList o1, LinkedList o2) {
                return Integer.compare(o1.size(), o2.size());
            }
        });
        groups.remove(groups.size() - 1);
        ArrayList merge = new ArrayList();
        for (LinkedList li : groups) {
            merge.addAll(li);
        }
        if (this.cellsPerSubgrid - sg.size() > merge.size()) {
            for (Point in : merge) {
                sg.createSlot(in.x, in.y);
            }
            return true;
        }
        return false;
    }

    private double calcStringiness(Set<Point> points) {
        int stringy = 0;
        for (Point p : points) {
            Collection<Point> c = this.getNeighbors(p);
            c.retainAll(points);
            if (c.size() > 2) continue;
            ++stringy;
        }
        return (double)stringy / (double)points.size();
    }

    private void createNewSlot(GridSlot gs, Subgrid g) {
        this.uncaged.add(gs);
        this.grids.put(gs.positionKey(), g);
        this.unGriddedPoints.remove(gs.positionKey());
    }

    private void randomize(PuzzleProfile p, Random rand) {
        GridSlot gs;
        while (!this.unfinished.isEmpty()) {
            Subgrid g = (Subgrid)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, this.unfinished);
            if (g.unpopulated.isEmpty()) {
                this.unfinished.remove(g);
                continue;
            }
            GridSlot slot = (GridSlot)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, (Collection)g.unpopulated);
            if (!this.pickRandomColorForSlot(rand, slot)) continue;
            g.unpopulated.remove(slot);
        }
        if (p.allowCaging) {
            while (!this.uncaged.isEmpty()) {
                GridSlot slot = (GridSlot)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, this.uncaged);
                if (slot.isBlocked || slot.color == CrystalElement.BROWN) {
                    this.uncaged.remove(slot);
                    continue;
                }
                HashSet dirs = ReikaDirectionHelper.setDirections((boolean)false);
                boolean flag = false;
                while (!dirs.isEmpty()) {
                    ForgeDirection dir = (ForgeDirection)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, (Collection)dirs);
                    dirs.remove(dir);
                    GridSlot slot2 = slot.getNeighbor(dir);
                    if (slot2 == null || !this.uncaged.contains(slot2) || !this.canCage(slot, slot2)) continue;
                    this.uncaged.remove(slot);
                    this.uncaged.remove(slot2);
                    this.cage(slot, slot2);
                    flag = true;
                    break;
                }
                if (!dirs.isEmpty() || flag) continue;
                this.uncaged.remove(slot);
            }
            block3: for (GridCage g : new ArrayList<GridCage>(this.cages.values())) {
                HashSet<GridSlot> set = g.getNeighbors();
                while (!set.isEmpty()) {
                    GridSlot gs2 = (GridSlot)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, set);
                    set.remove(gs2);
                    if (!g.canAbsorb(gs2) || this.cages.get(gs2.positionKey()) != null) continue;
                    g.addSlot(gs2);
                    this.cages.put(gs2.positionKey(), g);
                    continue block3;
                }
            }
            if (!this.cages.isEmpty()) {
                GridCage cage = (GridCage)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, this.cages.values());
                gs = (GridSlot)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, (Collection)cage.slots);
                gs.appearsAtStart = true;
            }
        }
        if (p.markIntersections) {
            HashSet<Point> set = new HashSet<Point>(this.grids.keySet());
            while (!set.isEmpty() && this.mixPoints.size() < this.gridSize) {
                Point mix = (Point)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, set);
                set.remove(mix);
                CrystalMix e = this.getValidMix(mix, rand);
                if (e == null) continue;
                this.mixPoints.put(mix, e);
            }
        }
        for (int n = (int)(this.initialFillFraction * (float)this.totalCellCount); n > 0 && !this.candidateStarts.isEmpty(); --n) {
            gs = (GridSlot)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, this.candidateStarts);
            this.candidateStarts.remove(gs);
            gs.appearsAtStart = true;
        }
    }

    private CrystalMix getValidMix(Point p, Random rand) {
        return null;
    }

    private GridSlot getRandomSlotExcluding(Random rand, Point ... pts) {
        Point p = (Point)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, this.grids.keySet());
        while (ReikaArrayHelper.contains((Object[])pts, (Object)p)) {
            p = (Point)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, this.grids.keySet());
        }
        return this.getAt(p.x, p.y);
    }

    private CrystalMix getValidMix(Point p, CrystalElement base, GridSlot g1, GridSlot g2) {
        if (g1.color == null || g2.color == null) {
            return null;
        }
        CrystalElement e = g1.color.mixWith(g2.color);
        return e == base ? new CrystalMix(e, p, g1, g2) : null;
    }

    private void cage(GridSlot slot, GridSlot slot2) {
        GridCage g = new GridCage(ElementMixer.instance.getMix(slot.color, slot2.color));
        g.slots.add(slot);
        g.slots.add(slot2);
        this.cages.put(slot.positionKey(), g);
        this.cages.put(slot2.positionKey(), g);
    }

    private boolean canCage(GridSlot slot, GridSlot slot2) {
        return slot.color != null && slot2.color != null && ElementMixer.instance.isMixable(slot.color, slot2.color);
    }

    private boolean pickRandomColorForSlot(Random rand, GridSlot gs) {
        HashSet set = ReikaJavaLibrary.makeSetFromArray((Object[])CrystalElement.elements);
        for (GridSlot gs2 : gs.parent.slots.values()) {
            set.remove(gs2.color);
        }
        int x = gs.xPos;
        int z = gs.zPos;
        for (int p = 0; p < this.edgeLength; ++p) {
            GridSlot g1 = this.getAt(x, p);
            GridSlot g2 = this.getAt(p, z);
            if (g1 != null && g1 != gs) {
                set.remove(g1.color);
            }
            if (g2 == null || g2 == gs) continue;
            set.remove(g2.color);
        }
        if (set.isEmpty()) {
            gs.isBlocked = true;
        } else {
            gs.color = (CrystalElement)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, (Collection)set);
            gs.isGoal = false;
            if (!gs.isGoal) {
                this.candidateStarts.add(gs);
            }
        }
        return true;
    }

    private GridSlot getAt(int x, int z) {
        if (x < 0 || z < 0 || x >= this.edgeLength || z >= this.edgeLength) {
            return null;
        }
        return (GridSlot)this.grids.get(new Point(x, z)).slots.get(new Point(x, z));
    }

    public void updateDoors(World world) {
        for (Coordinate c : this.doors) {
            BlockChromaDoor.setOpen(world, c.xCoord, c.yCoord, c.zCoord, this.isComplete);
        }
    }

    public void addCrystal(World world, CrystalElement e, int x, int z) {
        GridSlot gs = this.getAt(x, z);
        if (gs == null) {
            return;
        }
        gs.setCrystal(world, e);
        this.ping(world, x, z);
        this.isComplete = this.isValid(world);
    }

    public void removeCrystal(World world, int x, int z) {
        GridSlot gs = this.getAt(x, z);
        if (gs == null) {
            return;
        }
        gs.setCrystal(world, null);
    }

    public void ping(World world, int x, int z) {
        GridSlot gs = this.getAt(x, z);
        HashSet<GridSlot> pinged = new HashSet<GridSlot>();
        if (gs != null && gs.currentCrystal != null) {
            double f = CrystalMusicManager.instance.getDingPitchScale(gs.currentCrystal);
            ChromaSounds.DING.playSoundAtBlock(world, gs.getWorldX(), this.generatorOrigin.yCoord + 2, gs.getWorldZ(), 1.0f, (float)f);
            for (GridSlot gs2 : gs.parent.slots.values()) {
                if (gs == gs2 || pinged.contains(gs2)) continue;
                this.colorExclusionPing(world, gs.currentCrystal, gs2);
                pinged.add(gs2);
            }
            for (int p = 0; p < this.edgeLength; ++p) {
                GridSlot g1 = this.getAt(x, p);
                GridSlot g2 = this.getAt(p, z);
                if (g1 != null && g1 != gs && !pinged.contains(g1)) {
                    this.colorExclusionPing(world, gs.currentCrystal, g1);
                    pinged.add(g1);
                }
                if (g2 == null || g2 == gs || pinged.contains(g2)) continue;
                this.colorExclusionPing(world, gs.currentCrystal, g2);
                pinged.add(g2);
            }
        }
    }

    private void colorExclusionPing(World world, CrystalElement e, GridSlot gs) {
        RayBlendPuzzle.spawnPingParticle(world, e, gs.getWorldX(), this.generatorOrigin.yCoord + 2, gs.getWorldZ());
    }

    public static void spawnPingParticle(World world, CrystalElement e, int x, int y, int z) {
        if (world.field_72995_K) {
            RayBlendPuzzle.doPingParticle(world, e, x, y, z);
        } else {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.RAYBLENDPING.ordinal(), (World)world, (int)x, (int)y, (int)z, (PacketTarget)new PacketTarget.RadiusTarget(world, (double)x, (double)y, (double)z, 32.0), (int[])new int[]{e.ordinal()});
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void doPingParticle(World world, CrystalElement e, int x, int y, int z) {
        for (double i = 0.25; i <= 0.75; i += 0.25) {
            for (double k = 0.25; k <= 0.75; k += 0.25) {
                EntityCCBlurFX fx = new EntityCCBlurFX(world, (double)x + i, (double)y + 0.5, (double)z + k);
                fx.setIcon(ChromaIcons.CENTER).setColor(e.getColor()).setScale(5.0f).setLife(60).setRapidExpand().setAlphaFading();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    public void tick(World world) {
        for (CrystalMix mix : this.mixPoints.values()) {
            mix.sendParticles(world, this.generatorOrigin.xCoord, this.generatorOrigin.yCoord + 2, this.generatorOrigin.zCoord);
        }
    }

    public boolean allowsCrystalAt(World world, int x, int z, CrystalElement e) {
        if (!((RayBlendGenerator)this.parent).isChunkGenerated(x, z)) {
            return true;
        }
        int dx = x - this.generatorOrigin.xCoord;
        int dz = z - this.generatorOrigin.zCoord;
        GridSlot gs = this.getAt(dx, dz);
        return gs.parent.countColorPresence(world, e) == 0 && !this.rowOrColHas(dx, dz, e);
    }

    private boolean rowOrColHas(int x, int z, CrystalElement e) {
        for (int i = 0; i < this.edgeLength; ++i) {
            GridSlot g1 = this.getAt(x, i);
            GridSlot g2 = this.getAt(i, z);
            if (g1 != null && g1.currentCrystal != null && g1.currentCrystal == e) {
                return true;
            }
            if (g2 == null || g2.currentCrystal == null || g2.currentCrystal != e) continue;
            return true;
        }
        return false;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        int d;
        int m;
        int dz;
        int dx;
        int k;
        int i;
        this.generatorOrigin = new Coordinate(x, y, z);
        float midX = (float)x + (float)this.edgeLength / 2.0f;
        float midZ = (float)z + (float)this.edgeLength / 2.0f;
        int h = 8;
        int min1 = -4;
        int max1 = this.edgeLength + 3;
        int min2 = -8;
        int max2 = this.edgeLength + 3 + 4;
        if (!RayBlendGenerator.DEBUG) {
            for (i = min2; i < max2; ++i) {
                for (k = min2; k < max2; ++k) {
                    dx = x + i;
                    dz = z + k;
                    for (int d2 = 0; d2 < h; ++d2) {
                        world.setBlock(dx, y + d2, dz, Blocks.field_150350_a);
                    }
                }
            }
            for (i = min1; i < max1; ++i) {
                for (k = min1; k < max1; ++k) {
                    dx = x + i;
                    dz = z + k;
                    m = BlockStructureShield.BlockType.CLOAK.metadata;
                    if (i >= -1 && i <= this.edgeLength && k >= -1 && k <= this.edgeLength) {
                        m = BlockStructureShield.BlockType.STONE.metadata;
                    }
                    world.setBlock(dx, y - 1, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(dx, y, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(dx, y + 1, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m);
                }
                for (d = 0; d < 1; ++d) {
                    world.setBlock(x + min1, y + 1 + d, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + max1, y + 1 + d, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + i, y + 1 + d, z + min1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + i, y + 1 + d, z + max1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                }
            }
        }
        if (!RayBlendGenerator.DEBUG) {
            for (i = min2; i < max2; ++i) {
                for (k = min2; k < max2; ++k) {
                    dx = x + i;
                    dz = z + k;
                    if (i <= min1 || i >= max1 || k <= min1 || k >= max1) {
                        boolean edgeK;
                        m = BlockStructureShield.BlockType.STONE.metadata;
                        if (i > min2 + 1 && i < max2 - 1 && k > min2 + 1 && k < max2 - 1 && (i > max1 || i < min1 || k > max1 || k < min1)) {
                            m = BlockStructureShield.BlockType.CLOAK.metadata;
                        }
                        boolean edgeI = i == min1 || i == max1 || i == max2 - 1 || i == min2 + 1;
                        boolean bl = edgeK = k == min1 || k == max1 || k == max2 - 1 || k == min2 + 1;
                        if (edgeI && edgeK || dx == MathHelper.func_76141_d((float)midX) && edgeK || dz == MathHelper.func_76141_d((float)midZ) && edgeI && m == BlockStructureShield.BlockType.STONE.metadata) {
                            m = BlockStructureShield.BlockType.LIGHT.metadata;
                        }
                        world.setBlock(dx, y + 1 + 1, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m);
                    }
                    world.setBlock(dx, y + h - 1, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                }
                for (d = 0; d < h; ++d) {
                    world.setBlock(x + min2, y - 1 + d, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + max2, y - 1 + d, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + i, y - 1 + d, z + min2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + i + 1, y - 1 + d, z + max2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                }
            }
        }
        for (i = 0; i < this.edgeLength; ++i) {
            for (k = 0; k < this.edgeLength; ++k) {
                boolean light;
                dx = x + i;
                dz = z + k;
                boolean bl = light = (i / this.gridSize + k / this.gridSize) % 2 == 0;
                if (!RayBlendGenerator.DEBUG) {
                    world.setBlock(dx, y, dz, ChromaBlocks.SPECIALSHIELD.getBlockInstance(), light ? 1 : 0);
                }
                GridSlot gs = this.getAt(i, k);
                if (RayBlendGenerator.DEBUG) {
                    world.setTileEntity(dx, y + 1, dz, ChromaBlocks.RAYBLEND.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new RayblendFloorCallback(((RayBlendGenerator)this.parent).id, this.ID, gs.parent.ID, gs.xPos, gs.zPos, false, this.cages.get(gs.positionKey())));
                    continue;
                }
                if (gs.isBlocked) {
                    world.setBlock(dx, y, dz, ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.LIFEWATER.ordinal());
                    world.setTileEntity(dx, y + 1, dz, ChromaBlocks.RAYBLEND.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new RayblendFloorCallback(((RayBlendGenerator)this.parent).id, this.ID, gs.parent.ID, gs.xPos, gs.zPos, true, this.cages.get(gs.positionKey())));
                    continue;
                }
                if (gs.color != null) {
                    if (gs.appearsAtStart || GENERATE_SOLVED) {
                        world.setBlock(dx, y + 2, dz, ChromaBlocks.CRYSTAL.getBlockInstance(), gs.color.ordinal());
                    } else {
                        world.setBlock(dx, y + 2, dz, Blocks.field_150350_a);
                    }
                    world.setTileEntity(dx, y + 1, dz, ChromaBlocks.RAYBLEND.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new RayblendFloorCallback(((RayBlendGenerator)this.parent).id, this.ID, gs.parent.ID, gs.xPos, gs.zPos, false, this.cages.get(gs.positionKey())));
                    continue;
                }
                world.setBlock(dx, y + 1, dz, Blocks.field_150336_V);
            }
        }
        this.generationBounds = this.generationBounds.addCoordinate(x + min2, y - 1, z + min2);
        this.generationBounds = this.generationBounds.addCoordinate(x + max2, y + h, z + max2);
        if (this.roomIndex == 0) {
            int dx2 = this.generationBounds.minX + 1;
            int dz2 = z + 2;
            int dy = y + 2;
            this.bypassCoord = new Coordinate(dx2, dy, dz2);
        }
    }

    public void generateBypass(ChunkSplicedGenerationCache world) {
        if (this.bypassCoord != null) {
            int i;
            for (i = 1; i <= 4; ++i) {
                world.setBlock(this.bypassCoord.xCoord, this.bypassCoord.yCoord + i, this.bypassCoord.zCoord - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                world.setBlock(this.bypassCoord.xCoord, this.bypassCoord.yCoord + i, this.bypassCoord.zCoord + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                Block bc = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                int mc = BlockStructureShield.BlockType.STONE.metadata;
                if (i == 1) {
                    mc = BlockStructureShield.BlockType.LIGHT.metadata;
                } else if (i == 2) {
                    bc = ChromaBlocks.DIMDATA.getBlockInstance();
                    mc = 1;
                }
                if (bc == ChromaBlocks.DIMDATA.getBlockInstance()) {
                    ((RayBlendGenerator)this.parent).generatePasswordTile(this.bypassCoord.xCoord, this.bypassCoord.yCoord + i, this.bypassCoord.zCoord);
                    continue;
                }
                world.setBlock(this.bypassCoord.xCoord, this.bypassCoord.yCoord + i, this.bypassCoord.zCoord, bc, mc);
            }
            for (i = 1; i <= 4; ++i) {
                Block b = i == 4 ? ChromaBlocks.STRUCTSHIELD.getBlockInstance() : Blocks.field_150350_a;
                int m = i == 4 ? BlockStructureShield.BlockType.STONE.metadata : 0;
                for (int d = -3; d <= 3; ++d) {
                    world.setBlock(this.bypassCoord.xCoord - 1, this.bypassCoord.yCoord + i, this.bypassCoord.zCoord + d, b, m);
                }
            }
        }
    }

    public BlockBox getGenerationBounds() {
        return this.generationBounds;
    }

    public boolean isValid(World world) {
        for (Subgrid subgrid : this.grids.values()) {
            if (subgrid.isValid(world)) continue;
            return false;
        }
        for (Map.Entry entry : this.mixPoints.entrySet()) {
            Point p = (Point)entry.getKey();
            GridSlot gs = this.getAt(p.x, p.y);
            if (gs.currentCrystal == ((CrystalMix)entry.getValue()).color) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean containsCrystalPosition(int x, int y, int z) {
        return y == this.generatorOrigin.yCoord + 2 && this.getAt(x - this.generatorOrigin.xCoord, z - this.generatorOrigin.zCoord) != null;
    }

    public OverlayColor getCageColor(int x, int z) {
        if (RayBlendGenerator.DEBUG) {
            int idx = this.getAt(x, z).parent.index;
            float hue = (float)idx / (float)(this.totalCellCount / this.cellsPerSubgrid);
            return new OverlayColor.IntOverlayColor(Color.HSBtoRGB(hue, 1.0f, 1.0f));
        }
        GridCage gc = this.cages.get(new Point(x, z));
        return gc != null ? gc.blendedColor : null;
    }

    public void forceOpen(World world) {
        this.isComplete = true;
        this.updateDoors(world);
    }

    private static class RayblendFloorCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID parent;
        private final UUID uid;
        private final UUID grid;
        private final int xPos;
        private final int zPos;
        private final boolean isBlocked;
        private final CrystalElement color;

        public RayblendFloorCallback(UUID p, UUID id, UUID grid, int x, int z, boolean blocked, GridCage gc) {
            this.parent = p;
            this.uid = id;
            this.grid = grid;
            this.xPos = x;
            this.zPos = z;
            this.isBlocked = blocked;
            this.color = gc != null ? gc.blendedColor : null;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            ((BlockRayblendFloor.TileEntityRayblendFloor)te).uid = this.parent;
            ((BlockRayblendFloor.TileEntityRayblendFloor)te).populate(this.uid, this.grid, this.xPos, this.zPos, this.isBlocked, this.color);
        }
    }

    public static class CrystalMix {
        private final CrystalElement color;
        private final Point position;
        private final GridSlot pos1;
        private final GridSlot pos2;

        public CrystalMix(CrystalElement e, Point p, GridSlot g1, GridSlot g2) {
            this.color = e;
            this.position = p;
            this.pos1 = g1;
            this.pos2 = g2;
        }

        public void sendParticles(World world, int x0, int y0, int z0) {
            if (world.field_73012_v.nextInt(5) == 0) {
                ReikaPacketHelper.sendPositionPacket((String)"ChromaData", (int)ChromaPackets.RAYBLENDMIX.ordinal(), (World)world, (double)((double)(this.position.x + x0) + 0.5), (double)((double)y0 + 0.5), (double)((double)(this.position.y + z0) + 0.5), (PacketTarget)new PacketTarget.RadiusTarget(world, (double)x0, (double)y0, (double)z0, 32.0), (int[])new int[]{this.color.ordinal(), 1});
            }
            if (world.field_73012_v.nextInt(5) == 0) {
                ReikaPacketHelper.sendPositionPacket((String)"ChromaData", (int)ChromaPackets.RAYBLENDMIX.ordinal(), (World)world, (double)((double)(this.pos1.xPos + x0) + 0.5), (double)((double)y0 + 0.5), (double)((double)(this.pos1.zPos + z0) + 0.5), (PacketTarget)new PacketTarget.RadiusTarget(world, (double)x0, (double)y0, (double)z0, 32.0), (int[])new int[]{this.color.ordinal(), 0});
            }
            if (world.field_73012_v.nextInt(5) == 0) {
                ReikaPacketHelper.sendPositionPacket((String)"ChromaData", (int)ChromaPackets.RAYBLENDMIX.ordinal(), (World)world, (double)((double)(this.pos2.xPos + x0) + 0.5), (double)((double)y0 + 0.5), (double)((double)(this.pos2.zPos + z0) + 0.5), (PacketTarget)new PacketTarget.RadiusTarget(world, (double)x0, (double)y0, (double)z0, 32.0), (int[])new int[]{this.color.ordinal(), 0});
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static void doParticle(World world, double x, double y, double z, CrystalElement e, boolean mix) {
            if (mix) {
                EntityCCBlurFX fx = new EntityCCBlurFX(world, x, y, z);
                fx.setIcon(ChromaIcons.FADE).setColor(e.getColor()).setScale(3.0f).setLife(60).setRapidExpand().setAlphaFading();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            } else {
                EntityCCBlurFX fx = new EntityCCBlurFX(world, x, y, z);
                fx.setIcon(ChromaIcons.FADE).setColor(e.getColor()).setScale(2.0f).setLife(60).setRapidExpand().setAlphaFading();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    private static class GridSlot {
        private final Subgrid parent;
        public final int xPos;
        public final int zPos;
        private boolean isGoal;
        private boolean appearsAtStart;
        private boolean isBlocked;
        private CrystalElement color;
        private CrystalElement currentCrystal;

        public GridSlot(Subgrid s, int x, int z) {
            this.parent = s;
            this.xPos = x;
            this.zPos = z;
        }

        private void setCrystal(World world, CrystalElement e) {
            if (e != null) {
                this.parent.addColorPresence(world, e, this);
            } else if (this.currentCrystal != null) {
                this.parent.removeColorPresence(world, this.currentCrystal, this);
            }
            this.currentCrystal = e;
        }

        public HashSet<GridSlot> getNeighbors() {
            HashSet<GridSlot> set = new HashSet<GridSlot>();
            set.add(this.getNeighbor(ForgeDirection.EAST));
            set.add(this.getNeighbor(ForgeDirection.WEST));
            set.add(this.getNeighbor(ForgeDirection.NORTH));
            set.add(this.getNeighbor(ForgeDirection.SOUTH));
            set.remove(null);
            return set;
        }

        public Point positionKey() {
            return new Point(this.xPos, this.zPos);
        }

        private GridSlot getNeighbor(ForgeDirection dir) {
            return this.parent.parent.getAt(this.xPos + dir.offsetX, this.zPos + dir.offsetZ);
        }

        public boolean isValid(World world) {
            if (this.isBlocked) {
                return true;
            }
            if (this.currentCrystal == null) {
                return false;
            }
            if (this.parent.countColorPresence(world, this.currentCrystal) > 1) {
                return false;
            }
            boolean flag = true;
            CrystalElement e = this.currentCrystal;
            this.currentCrystal = null;
            boolean row = this.parent.parent.rowOrColHas(this.xPos, this.zPos, e);
            this.currentCrystal = e;
            return !row;
        }

        public int getWorldX() {
            return ((RayBlendPuzzle)((Subgrid)this.parent).parent).generatorOrigin.xCoord + this.xPos;
        }

        public int getWorldZ() {
            return ((RayBlendPuzzle)((Subgrid)this.parent).parent).generatorOrigin.zCoord + this.zPos;
        }

        public String toString() {
            return "[" + this.xPos + ", " + this.zPos + "]; " + this.color + "/" + this.currentCrystal + "; " + this.isBlocked + "/" + this.isGoal + "/" + this.appearsAtStart;
        }
    }

    private static class GridCage {
        private final Collection<GridSlot> slots = new ArrayList<GridSlot>();
        private CrystalElement blendedColor;

        private GridCage(CrystalElement e) {
            this.blendedColor = e;
        }

        public HashSet<GridSlot> getNeighbors() {
            HashSet<GridSlot> set = new HashSet<GridSlot>();
            for (GridSlot gs : this.slots) {
                set.addAll(gs.getNeighbors());
            }
            set.removeAll(this.slots);
            set.remove(null);
            return set;
        }

        public boolean isExpandable() {
            return ElementMixer.instance.getChildrenOf(this.blendedColor) != null;
        }

        public boolean canAbsorb(GridSlot gs) {
            return gs.color != null && !gs.isBlocked && ElementMixer.instance.isMixable(this.blendedColor, gs.color);
        }

        private void addSlot(GridSlot gs) {
            this.blendedColor = ElementMixer.instance.getMix(this.blendedColor, gs.color);
            this.slots.add(gs);
        }
    }

    private static class Subgrid
    implements ReikaJavaLibrary.CloneCallback<Point> {
        private final UUID ID = UUID.randomUUID();
        private final RayBlendPuzzle parent;
        private final HashMap<Point, GridSlot> slots = new HashMap();
        private final EnumMap<CrystalElement, HashSet<Point>> presentColors = new EnumMap(CrystalElement.class);
        private long hash;
        private final HashSet<GridSlot> unpopulated = new HashSet();
        private final int index;
        private static int CURRENTINDEX = 0;

        private Subgrid(RayBlendPuzzle p) {
            this.parent = p;
            this.parent.unfinished.add(this);
            this.index = CURRENTINDEX++;
            this.hash = this.calculateHash();
        }

        public boolean isCongruent(Subgrid g) {
            if (g == this) {
                return true;
            }
            if (g.slots.size() != this.slots.size()) {
                return false;
            }
            ArrayList<Point> set1 = new ArrayList<Point>(ReikaJavaLibrary.cloneCollectionObjects(this.slots.keySet(), (ReikaJavaLibrary.CloneCallback)this));
            ArrayList<Point> set2 = new ArrayList<Point>(ReikaJavaLibrary.cloneCollectionObjects(g.slots.keySet(), (ReikaJavaLibrary.CloneCallback)this));
            this.normalizePoints(set1);
            this.normalizePoints(set2);
            if (ReikaJavaLibrary.collectionsHaveSameValues(set1, set2)) {
                return true;
            }
            for (int i = 0; i < 3; ++i) {
                this.rotatePoints(set2);
                this.normalizePoints(set2);
                if (!ReikaJavaLibrary.collectionsHaveSameValues(set1, set2)) continue;
                return true;
            }
            return false;
        }

        private void rotatePoints(Collection<Point> set) {
            for (Point p : set) {
                Vec3 r = ReikaVectorHelper.rotateVector((Vec3)Vec3.func_72443_a((double)p.x, (double)0.0, (double)p.y), (double)0.0, (double)90.0, (double)0.0);
                p.x = MathHelper.func_76128_c((double)r.field_72450_a);
                p.y = MathHelper.func_76128_c((double)r.field_72449_c);
            }
        }

        private void normalizePoints(Collection<Point> set) {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            for (Point p : set) {
                minX = Math.min(minX, p.x);
                minY = Math.min(minY, p.y);
            }
            for (Point p : set) {
                p.x -= minX;
                p.y -= minY;
            }
        }

        public int countColorPresence(World world, CrystalElement e) {
            return this.getOrCreateSet(world, e).size();
        }

        private void addColorPresence(World world, CrystalElement e, GridSlot c) {
            this.getOrCreateSet(world, e).add(c.positionKey());
        }

        private void removeColorPresence(World world, CrystalElement e, GridSlot c) {
            this.getOrCreateSet(world, e).remove(c.positionKey());
        }

        private HashSet<Point> getOrCreateSet(World world, CrystalElement e) {
            HashSet<Point> set = this.presentColors.get(e);
            if (set == null) {
                set = new HashSet();
                this.presentColors.put(e, set);
            } else {
                Iterator<Point> it = set.iterator();
                while (it.hasNext()) {
                    int z;
                    GridSlot gs = this.slots.get(it.next());
                    int x = gs.getWorldX();
                    Block b = world.func_147439_a(x, ((RayBlendPuzzle)this.parent).generatorOrigin.yCoord + 2, z = gs.getWorldZ());
                    if (!(b instanceof CrystalTypeBlock)) {
                        it.remove();
                        continue;
                    }
                    if (world.func_72805_g(x, ((RayBlendPuzzle)this.parent).generatorOrigin.yCoord + 2, z) == e.ordinal()) continue;
                    it.remove();
                }
            }
            return set;
        }

        public double getStringiness() {
            return this.parent.calcStringiness(this.slots.keySet());
        }

        public void clear() {
            this.slots.clear();
            this.presentColors.clear();
            this.unpopulated.clear();
            this.hash = this.calculateHash();
        }

        public int size() {
            return this.slots.size();
        }

        private void createSlot(int x, int z) {
            GridSlot gs = new GridSlot(this, x, z);
            this.slots.put(gs.positionKey(), gs);
            this.unpopulated.add(gs);
            this.parent.createNewSlot(gs, this);
            this.hash = this.calculateHash();
        }

        private long calculateHash() {
            long ret = 0L;
            for (GridSlot gs : this.slots.values()) {
                ret += (long)gs.xPos + 1000000L * (long)gs.zPos;
            }
            return ret;
        }

        public boolean isValid(World world) {
            for (GridSlot gs : this.slots.values()) {
                if (gs.isValid(world)) continue;
                return false;
            }
            return true;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "Subgrid #" + this.index + " of size " + this.size();
        }

        public Point clone(Point o) {
            return new Point(o.x, o.y);
        }
    }
}

