/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Auxiliary.OverlayColor;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.Structure.RayBlend.PuzzleProfile;
import Reika.ChromatiCraft.World.Dimension.Structure.RayBlend.RayBlendEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.RayBlend.RayBlendLoot;
import Reika.ChromatiCraft.World.Dimension.Structure.RayBlend.RayBlendPuzzle;
import Reika.DragonAPI.Instantiable.Data.GappedRange;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class RayBlendGenerator
extends DimensionStructureGenerator {
    public static boolean DEBUG = false;
    private final HashMap<UUID, RayBlendPuzzle> puzzles = new HashMap();

    @Override
    public void updateTick(World world) {
        if (!world.field_72995_K) {
            for (RayBlendPuzzle p : this.puzzles.values()) {
                p.tick(world);
            }
        }
    }

    @Override
    protected void calculate(int chunkX, int chunkZ, Random rand) {
        int y;
        int x = chunkX;
        int z = chunkZ;
        this.posY = y = 10 + rand.nextInt(70);
        PuzzleProfile[] sz = this.getProfileList();
        int extra = 19;
        HashMap<Integer, UUID> doors = new HashMap<Integer, UUID>();
        int len = 0;
        for (PuzzleProfile p : sz) {
            len += p.gridSize * p.gridSize + extra;
        }
        GappedRange gr = new GappedRange();
        int dx = x;
        for (int i = 0; i < sz.length; ++i) {
            PuzzleProfile p;
            p = sz[i];
            RayBlendPuzzle rb = this.createPuzzle(rand, p, i);
            if (rb == null) continue;
            int sizePre = i == 0 ? 0 : sz[i - 1].gridSize;
            this.puzzles.put(rb.ID, rb);
            int n = DEBUG ? 7 : extra + sizePre * sizePre;
            int dz = z - p.gridSize * p.gridSize / 2;
            rb.generate(this.world, dx += n, y, dz);
            gr.addGap(rb.getGenerationBounds().minX + 1, rb.getGenerationBounds().maxX - 1);
            doors.put(rb.getGenerationBounds().maxX + 2, rb.ID);
        }
        gr.addEndpoint(x - 6, true);
        gr.addEndpoint(x + (len += 7) + 2, true);
        if (!DEBUG) {
            int h = 4;
            for (int d = -2; d < len + 4; ++d) {
                int odx = x + d;
                if (gr.isInGap(odx)) continue;
                int w = 3;
                for (int i = -w; i <= w; ++i) {
                    for (int dh = -1; dh <= h; ++dh) {
                        if (Math.abs(i) == w || dh == -1 || dh == h) {
                            this.world.setBlock(odx, y + 3 + dh, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                            continue;
                        }
                        if (doors.containsKey(odx)) {
                            this.world.setBlock(odx, y + 3 + dh, z + i, ChromaBlocks.DOOR.getBlockInstance());
                            UUID id = (UUID)doors.get(odx);
                            this.puzzles.get(id).addDoor(new Coordinate(odx, y + 3 + dh, z + i));
                            continue;
                        }
                        this.world.setBlock(odx, y + 3 + dh, z + i, Blocks.field_150350_a);
                    }
                }
            }
        }
        for (RayBlendPuzzle rp : this.puzzles.values()) {
            rp.generateBypass(this.world);
        }
        new RayBlendLoot(this).generate(this.world, x + len + 3, y + 2, z - 7);
        this.addDynamicStructure(new RayBlendEntrance(this), x - 4, z);
    }

    private RayBlendPuzzle createPuzzle(Random rand, PuzzleProfile p, int idx) {
        int attempts = 1;
        RayBlendPuzzle ret = new RayBlendPuzzle(this, idx, p.gridSize, p.initialFill, rand);
        while (!ret.prepare(p, rand)) {
            ret = new RayBlendPuzzle(this, idx, p.gridSize, p.initialFill, rand);
            if (++attempts <= 40) continue;
            ChromatiCraft.logger.logError((Object)("Failed to generate a " + p + " puzzle in a reasonable time!"));
            return null;
        }
        return ret;
    }

    private PuzzleProfile[] getProfileList() {
        if (DEBUG) {
            return new PuzzleProfile[]{new PuzzleProfile(2, 0.0f), new PuzzleProfile(2, 0.0f), new PuzzleProfile(2, 0.0f), new PuzzleProfile(2, 0.0f), new PuzzleProfile(2, 0.0f), new PuzzleProfile(2, 0.0f), new PuzzleProfile(2, 0.0f), new PuzzleProfile(2, 0.0f), new PuzzleProfile(2, 0.0f), new PuzzleProfile(2, 0.0f)};
        }
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return new PuzzleProfile[]{new PuzzleProfile(2, 0.5f), new PuzzleProfile(2, 0.4f, true, false), new PuzzleProfile(3, 0.4f), new PuzzleProfile(3, 0.3f, true, true), new PuzzleProfile(4, 0.3f, true, false)};
            }
            case 2: {
                return new PuzzleProfile[]{new PuzzleProfile(2, 0.5f), new PuzzleProfile(2, 0.4f, true, false), new PuzzleProfile(2, 0.25f, true, true), new PuzzleProfile(3, 0.25f), new PuzzleProfile(3, 0.2f, true, false), new PuzzleProfile(4, 0.2f, true, true)};
            }
        }
        return new PuzzleProfile[]{new PuzzleProfile(2, 0.5f), new PuzzleProfile(2, 0.4f, true, false), new PuzzleProfile(2, 0.3f, true, true), new PuzzleProfile(2, 0.2f, true, true), new PuzzleProfile(3, 0.2f), new PuzzleProfile(3, 0.15f, true, false), new PuzzleProfile(3, 0.1f, true, true), new PuzzleProfile(4, 0.2f, true, false), new PuzzleProfile(4, 0.1f, true, true)};
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    protected boolean hasBeenSolved(World world) {
        for (RayBlendPuzzle rb : this.puzzles.values()) {
            if (rb.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void openStructure(World world) {
        for (RayBlendPuzzle rb : this.puzzles.values()) {
            rb.forceOpen(world);
        }
    }

    @Override
    protected void clearCaches() {
        this.puzzles.clear();
    }

    public boolean allowsCrystalAt(World world, UUID id, int x, int z, CrystalElement e) {
        RayBlendPuzzle p = this.puzzles.get(id);
        if (p != null) {
            return p.allowsCrystalAt(world, x, z, e);
        }
        return true;
    }

    public void setCrystal(World world, UUID id, int x, int z, CrystalElement e) {
        RayBlendPuzzle p = this.puzzles.get(id);
        if (p != null) {
            if (e != null) {
                p.addCrystal(world, e, x, z);
            } else {
                p.removeCrystal(world, x, z);
            }
            p.updateDoors(world);
        }
    }

    public OverlayColor getCageColor(UUID id, int x, int z) {
        RayBlendPuzzle p = this.puzzles.get(id);
        return p != null ? p.getCageColor(x, z) : null;
    }
}

