/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation;

import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.MazeCalculator;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.SegmentRestriction;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.MazeGrid;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;

public class BacktrackDiscoverer {
    private final Random seededRand;
    private Point reachedPoint = null;
    private List<Point> deadEndList = null;
    private List<Point> visited = null;
    private SegmentRestriction restriction;
    private int maxSteps = Integer.MAX_VALUE;
    private boolean sortHorizontal = false;

    public BacktrackDiscoverer(Random rand) {
        this.seededRand = rand;
    }

    public void reset() {
        this.reachedPoint = null;
        this.deadEndList = null;
        this.visited = null;
        this.restriction = null;
        this.sortHorizontal = false;
        this.maxSteps = Integer.MAX_VALUE;
    }

    public Point getReachedPoint() {
        return this.reachedPoint;
    }

    public void appendDeadEndsTo(List<Point> points) {
        this.deadEndList = points;
    }

    public void appendVisitedPointsTo(List<Point> points) {
        this.visited = points;
    }

    public void capSteps(int maxSteps) {
        this.maxSteps = maxSteps;
    }

    public void setSegmentRestriction(SegmentRestriction restriction) {
        this.restriction = restriction;
    }

    public void sortHorizontally() {
        this.sortHorizontal = true;
    }

    public boolean doStep(MazeGrid grid, int sX, int sZ, boolean markPassedNodes, boolean lockNodes, GridSearchCondition condition) {
        if (condition.isMet(grid, sX, sZ)) {
            this.reachedPoint = new Point(sX, sZ);
            return true;
        }
        --this.maxSteps;
        if (this.maxSteps <= 0) {
            this.reachedPoint = new Point(sX, sZ);
            return true;
        }
        List<ForgeDirection> dirs = this.sortDirections();
        boolean isFlatDeadEnd = true;
        for (ForgeDirection dir : dirs) {
            int tX = sX + dir.offsetX;
            int tZ = sZ + dir.offsetZ;
            if (!(this.restriction == null ? grid.isInBounds(tX, tZ) : this.restriction.isInBounds(tX, tZ)) || !grid.isFree(tX, tZ)) continue;
            isFlatDeadEnd = false;
            MazeGrid.MazeSegment seg = grid.getSegment(tX, tZ);
            seg.addConnection(dir.getOpposite());
            if (markPassedNodes) {
                seg.markVisited();
            }
            if (lockNodes) {
                seg.specialLock = true;
            }
            if (this.visited != null) {
                this.visited.add(new Point(tX, tZ));
            }
            if (!this.doStep(grid, tX, tZ, markPassedNodes, lockNodes, condition.copyNext())) continue;
            return true;
        }
        if (isFlatDeadEnd && this.deadEndList != null) {
            this.deadEndList.add(new Point(sX, sZ));
        }
        return false;
    }

    private List<ForgeDirection> sortDirections() {
        LinkedList<ForgeDirection> dirs = new LinkedList<ForgeDirection>();
        if (this.sortHorizontal) {
            if (this.seededRand.nextBoolean()) {
                dirs.add(ForgeDirection.NORTH);
                dirs.add(ForgeDirection.SOUTH);
            } else {
                dirs.add(ForgeDirection.SOUTH);
                dirs.add(ForgeDirection.NORTH);
            }
            dirs.add(ForgeDirection.WEST);
        } else {
            int rIndex;
            for (int i = rIndex = this.seededRand.nextInt(4); i < rIndex + 4; ++i) {
                dirs.add(MazeGrid.MazeSegment.VALID_CONNECTIONS.get(i % 4));
            }
        }
        return dirs;
    }

    public static class GenerateDoorAfterStepCondition
    implements GridSearchCondition {
        private final int steps;
        private final int dstBorders;

        public GenerateDoorAfterStepCondition(int count, int dstBorders) {
            this.steps = count;
            this.dstBorders = dstBorders;
        }

        @Override
        public boolean isMet(MazeGrid grid, int sX, int sZ) {
            if (this.steps <= 0) {
                for (ForgeDirection dir : MazeGrid.MazeSegment.VALID_CONNECTIONS) {
                    if (!MazeCalculator.canGenerateDoor(grid, sX, sZ, dir, this.dstBorders)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public GridSearchCondition copyNext() {
            return new GenerateDoorAfterStepCondition(this.steps - 1, this.dstBorders);
        }
    }

    public static class MatchCoordCondition
    implements GridSearchCondition {
        private final int matchX;
        private final int matchZ;

        public MatchCoordCondition(int matchX, int matchZ) {
            this.matchZ = matchZ;
            this.matchX = matchX;
        }

        @Override
        public boolean isMet(MazeGrid grid, int sX, int sZ) {
            return sX == this.matchX && sZ == this.matchZ;
        }

        @Override
        public GridSearchCondition copyNext() {
            return this;
        }
    }

    public static interface GridSearchCondition {
        public boolean isMet(MazeGrid var1, int var2, int var3);

        public GridSearchCondition copyNext();
    }
}

