/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation;

import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.BacktrackDiscoverer;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.GraphBacktrackDiscoverer;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.GridSegment;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.MazeSegmentGraph;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.MazeSegmentNode;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.SegmentDiscoverer;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.MazeGrid;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.ShiftMazeState;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMazeGenerator;
import com.google.common.collect.Lists;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraftforge.common.util.ForgeDirection;

public class MazeCalculator {
    private final MazeGrid grid;
    private final Random seededRand;
    private final BacktrackDiscoverer backtrackStepper;
    private Map<Point, Point> generationGoals = new HashMap<Point, Point>();
    public Map<Integer, List<Point>> segmentPoints = new HashMap<Integer, List<Point>>();
    public Map<Integer, Point> segmentIds = new HashMap<Integer, Point>();
    private Map<Point, ShiftMazeState> bufferedStates = new HashMap<Point, ShiftMazeState>();
    public MazeSegmentGraph segmentGraph;
    private Point genGoalEndDoor;

    public MazeCalculator(MazeGrid grid, Random rand) {
        this.grid = grid;
        this.seededRand = rand;
        this.backtrackStepper = new BacktrackDiscoverer(rand);
    }

    public Collection<Point> getGenerationGoals() {
        return Collections.unmodifiableCollection(this.generationGoals.keySet());
    }

    public Collection<Point> getPlayerGoals() {
        return Collections.unmodifiableCollection(this.generationGoals.values());
    }

    public boolean verifySolvability(ShiftMazeGenerator gen) {
        SegmentDiscoverer disc = new SegmentDiscoverer(this.grid);
        Point start = this.grid.getStartSegmentPos();
        LinkedList<Point> reachableOriginAnchors = new LinkedList<Point>();
        disc.reset();
        disc.runCalc(Lists.newArrayList((Object[])new Point[]{start}), null, true);
        for (Point origin : this.generationGoals.values()) {
            if (reachableOriginAnchors.contains(origin) || !disc.hasFound(origin)) continue;
            reachableOriginAnchors.add(origin);
        }
        for (Point origin : this.generationGoals.values()) {
            if (reachableOriginAnchors.contains(origin)) continue;
            return false;
        }
        return true;
    }

    public void pushDoorsToGrid() {
        LinkedList<MazeGrid.ShiftMazeDoor> pushedDoors = new LinkedList<MazeGrid.ShiftMazeDoor>();
        Collection<Integer> ids = this.segmentGraph.getAllKnownNodeIDs();
        for (int id : ids) {
            MazeSegmentNode node = this.segmentGraph.getNode(id);
            for (MazeSegmentNode other : node.connectionDoors.keySet()) {
                for (MazeGrid.ShiftMazeDoor door : node.connectionDoors.get(other)) {
                    if (pushedDoors.contains(door)) continue;
                    this.grid.appendDoor((Point)door.pointDirFrom, (Point)door.pointDirTo, (ForgeDirection)door.dir).doorStates.addAll(door.doorStates);
                    pushedDoors.add(door);
                }
            }
        }
    }

    public void calcGraphPaths() {
        int startId = this.getContainingSegmentId(this.grid.getStartSegmentPos());
        MazeSegmentNode start = this.segmentGraph.getNode(startId);
        if (start == null) {
            throw new IllegalStateException("Could not find start segment!");
        }
        for (Point genGoal : this.generationGoals.keySet()) {
            int segGoal = this.getContainingSegmentId(genGoal);
            MazeSegmentNode toConnectTo = this.segmentGraph.getNode(segGoal);
            if (toConnectTo == null) {
                throw new IllegalStateException("Could not find segment for a genGoal!");
            }
            ShiftMazeState state = this.bufferedStates.get(genGoal);
            ArrayDeque<MazeSegmentNode> nodePath = GraphBacktrackDiscoverer.getNodePath(start, toConnectTo, 2);
            while (nodePath.size() > 1) {
                MazeSegmentNode to = nodePath.pop();
                MazeSegmentNode from = nodePath.pop();
                from.addStateForConnection(to, this.seededRand, state);
                nodePath.push(from);
            }
        }
    }

    public void calcSegmentGraph() {
        MazeSegmentNode node;
        this.segmentGraph = new MazeSegmentGraph();
        LinkedList<BufferedDoorState> prePotentialDoorPoints = new LinkedList<BufferedDoorState>();
        for (Integer segId : this.segmentPoints.keySet()) {
            MazeSegmentNode node2 = this.segmentGraph.createOrGetNode(segId);
            List<Point> segmentContents = this.segmentPoints.get(segId);
            for (Point point : segmentContents) {
                if (this.grid.getSegment((int)point.x, (int)point.y).specialLock) continue;
                for (ForgeDirection dir : MazeGrid.MazeSegment.VALID_CONNECTIONS) {
                    int otherId;
                    MazeSegmentNode otherNode;
                    BufferedDoorState state;
                    Point other = new Point(point.x + dir.offsetX, point.y + dir.offsetZ);
                    if (!this.grid.isInBounds(other.x, other.y) || segmentContents.contains(other) || this.grid.getSegment((int)other.x, (int)other.y).specialLock || prePotentialDoorPoints.contains(state = new BufferedDoorState(point, other, dir, node2, otherNode = this.segmentGraph.createOrGetNode(otherId = this.getContainingSegmentId(other))))) continue;
                    prePotentialDoorPoints.add(state);
                }
            }
        }
        Collection<Integer> knownIDs = this.segmentGraph.getAllKnownNodeIDs();
        for (Integer id : knownIDs) {
            node = this.segmentGraph.getNode(id);
            HashMap sortedDoors = new HashMap();
            for (Integer otherId : new ArrayList<Integer>(knownIDs)) {
                if (id.equals(otherId)) continue;
                LinkedList<BufferedDoorState> potentialDoors = new LinkedList<BufferedDoorState>();
                MazeSegmentNode otherNode = this.segmentGraph.getNode(otherId);
                boolean hasDoors = false;
                Iterator preBuf = prePotentialDoorPoints.iterator();
                while (preBuf.hasNext()) {
                    BufferedDoorState door = (BufferedDoorState)preBuf.next();
                    if ((!door.toNode.equals(otherNode) || !door.fromNode.equals(node)) && (!door.fromNode.equals(otherNode) || !door.toNode.equals(node))) continue;
                    preBuf.remove();
                    potentialDoors.add(door);
                    hasDoors = true;
                }
                if (hasDoors) {
                    this.segmentGraph.connect(node, otherNode);
                }
                sortedDoors.put(otherNode, potentialDoors);
            }
            for (MazeSegmentNode conNode : sortedDoors.keySet()) {
                List doors = (List)sortedDoors.get(conNode);
                if (doors.size() > 0) {
                    this.segmentGraph.pushNewDoor((BufferedDoorState)doors.remove(this.seededRand.nextInt(doors.size())));
                }
                if (doors.size() <= 8 || this.seededRand.nextInt(3) != 0) continue;
                this.segmentGraph.pushNewDoor((BufferedDoorState)doors.remove(this.seededRand.nextInt(doors.size())));
            }
        }
        for (Integer id : knownIDs) {
            node = this.segmentGraph.getNode(id);
            for (Integer n : knownIDs) {
                if (id.equals(n)) continue;
                MazeSegmentNode other = this.segmentGraph.getNode(n);
                this.segmentGraph.checkAndDisconnect(node, other);
            }
        }
    }

    private int getContainingSegmentId(Point p) {
        for (Integer segId : this.segmentPoints.keySet()) {
            if (!this.segmentPoints.get(segId).contains(p)) continue;
            return segId;
        }
        throw new IllegalArgumentException("Searching ID for Point out of bounds!");
    }

    public void calcSegmentInternalMazes() {
        LinkedList<Point> deadEndPoints = new LinkedList<Point>();
        for (int segId : this.segmentIds.keySet()) {
            Point goal = this.segmentIds.get(segId);
            List<Point> segmentElements = this.segmentPoints.get(segId);
            GridSegment segment = new GridSegment(this.grid, segmentElements, segId);
            this.backtrackStepper.reset();
            this.backtrackStepper.setSegmentRestriction(segment);
            this.backtrackStepper.appendDeadEndsTo(deadEndPoints);
            this.backtrackStepper.doStep(this.grid, goal.x, goal.y, true, false, new BacktrackDiscoverer.MatchCoordCondition(-1, -1));
            block1: for (Point de : deadEndPoints) {
                int rIndex;
                if (this.seededRand.nextBoolean()) continue;
                int pX = de.x;
                int pZ = de.y;
                for (int i = rIndex = this.seededRand.nextInt(4); i < rIndex + 4; ++i) {
                    ForgeDirection dir = MazeGrid.MazeSegment.VALID_CONNECTIONS.get(i % 4);
                    int tX = pX + dir.offsetX;
                    int tZ = pZ + dir.offsetZ;
                    if (!segment.isInBounds(tX, tZ)) continue;
                    MazeGrid.MazeSegment tSeg = this.grid.getSegment(tX, tZ);
                    if (tSeg.specialLock) continue;
                    this.grid.getSegment(pX, pZ).addConnection(dir);
                    continue block1;
                }
            }
            deadEndPoints.clear();
        }
    }

    public void calcMazeSegments() {
        Point start = this.grid.getStartSegmentPos();
        Point center = this.grid.getCentralSegment();
        this.segmentPoints = new HashMap<Integer, List<Point>>();
        this.segmentIds = new HashMap<Integer, Point>();
        LinkedList<Point> goals = new LinkedList<Point>();
        goals.addAll(this.generationGoals.keySet());
        goals.remove(this.genGoalEndDoor);
        this.grid.getSegment(this.genGoalEndDoor.x, this.genGoalEndDoor.y).markNonVisited();
        this.grid.getSegment(start.x, start.y).markNonVisited();
        for (Point p : goals) {
            this.grid.getSegment(p.x, p.y).markNonVisited();
        }
        Collections.sort(goals, new ComparatorGridDistance(this.genGoalEndDoor));
        goals.addFirst(this.genGoalEndDoor);
        goals.addLast(start);
        int forcedZFlip = this.grid.getZSize() / 5;
        int highestId = -1;
        boolean fromZeroZ = this.seededRand.nextBoolean();
        for (int i = 0; i < goals.size() - 1; ++i) {
            boolean contains;
            Point at;
            int xx;
            int zToPass;
            int zBuf;
            int dirStep;
            int offset;
            if (i > highestId) {
                highestId = i;
            }
            Point to = (Point)goals.get(i);
            Point plGoal = this.generationGoals.get(to);
            Point from = (Point)goals.get(i + 1);
            LinkedList<Point> containing = new LinkedList<Point>();
            Point divPoint = new Point(to.x + (from.x - to.x) / 2, center.y);
            if (to.y < forcedZFlip) {
                offset = 0;
                dirStep = 1;
                zBuf = to.y < plGoal.y ? plGoal.y : to.y;
                zToPass = center.y < zBuf ? zBuf : center.y;
                fromZeroZ = false;
            } else if (to.y > this.grid.getZSize() - forcedZFlip - 1) {
                offset = this.grid.getZSize() - 1;
                dirStep = -1;
                zBuf = to.y < plGoal.y ? to.y : plGoal.y;
                zToPass = center.y < zBuf ? center.y : zBuf;
                fromZeroZ = true;
            } else if (fromZeroZ) {
                offset = 0;
                dirStep = 1;
                zBuf = to.y < plGoal.y ? plGoal.y : to.y;
                zToPass = center.y < zBuf ? zBuf : center.y;
                fromZeroZ = !fromZeroZ;
            } else {
                offset = this.grid.getZSize() - 1;
                dirStep = -1;
                zBuf = to.y < plGoal.y ? to.y : plGoal.y;
                zToPass = center.y < zBuf ? center.y : zBuf;
                fromZeroZ = !fromZeroZ;
            }
            int step = offset - dirStep;
            do {
                step += dirStep;
                for (xx = 0; xx < divPoint.x; ++xx) {
                    at = new Point(xx, step);
                    contains = false;
                    for (List<Point> pList : this.segmentPoints.values()) {
                        if (!pList.contains(at)) continue;
                        contains = true;
                    }
                    if (contains || this.grid.getSegment((int)xx, (int)step).specialLock) continue;
                    containing.add(at);
                }
            } while (step != zToPass);
            step += dirStep;
            for (xx = 0; xx < divPoint.x; ++xx) {
                at = new Point(xx, step);
                contains = false;
                for (List<Point> pList : this.segmentPoints.values()) {
                    if (!pList.contains(at)) continue;
                    contains = true;
                }
                if (contains || this.grid.getSegment((int)xx, (int)step).specialLock) continue;
                containing.add(at);
            }
            containing.add(to);
            this.segmentPoints.put(i, containing);
            this.segmentIds.put(i, to);
        }
        ++highestId;
        LinkedList<Point> startSegment = new LinkedList<Point>();
        for (int xx = 0; xx < this.grid.getXSize(); ++xx) {
            for (int zz = 0; zz < this.grid.getZSize(); ++zz) {
                Point at = new Point(xx, zz);
                if (this.grid.getSegment((int)xx, (int)zz).specialLock) continue;
                boolean contains = false;
                for (List<Point> pList : this.segmentPoints.values()) {
                    if (!pList.contains(at)) continue;
                    contains = true;
                }
                if (contains) continue;
                startSegment.add(at);
            }
        }
        startSegment.add(start);
        this.segmentIds.put(highestId, start);
        this.segmentPoints.put(highestId, startSegment);
    }

    public void genFixedAnchors(ShiftMazeGenerator gen, int amtChests) {
        Point end = this.grid.getEndSegmentPos();
        Point start = this.grid.getStartSegmentPos();
        Point center = this.grid.getCentralSegment();
        MazeGrid.MazeSegment endSeg = this.grid.getSegment(end.x, end.y);
        endSeg.markVisited();
        endSeg.specialLock = true;
        ShiftMazeState stateEndDoor = gen.createNewMazeState();
        this.grid.getSegment(start.x, start.y).markVisited();
        this.backtrackStepper.reset();
        this.backtrackStepper.sortHorizontally();
        this.backtrackStepper.doStep(this.grid, end.x, end.y, true, true, new BacktrackDiscoverer.GenerateDoorAfterStepCondition(0, 0));
        Point reached = this.backtrackStepper.getReachedPoint();
        if (reached != null) {
            int rIndex;
            boolean gennedDoor = false;
            for (int t = rIndex = this.seededRand.nextInt(4); t < rIndex + 4; ++t) {
                ForgeDirection dir = MazeGrid.MazeSegment.VALID_CONNECTIONS.get(t % 4);
                if (!MazeCalculator.canGenerateDoor(this.grid, reached.x, reached.y, dir, 0)) continue;
                this.genGoalEndDoor = this.genDoorUnsafe(reached.x, reached.y, dir, stateEndDoor);
                gennedDoor = true;
                this.generationGoals.put(this.genGoalEndDoor, end);
                this.bufferedStates.put(this.genGoalEndDoor, stateEndDoor);
                break;
            }
            if (!gennedDoor) {
                throw new IllegalStateException("Could not generate end door.");
            }
        } else {
            throw new IllegalStateException("Maze too small.");
        }
        int startXLayer = start.x - 2;
        int endXLayer = 6;
        int xDst = (startXLayer - endXLayer) / amtChests;
        for (int i = 0; i < amtChests; ++i) {
            Point chest = this.getRandomPos(endXLayer + xDst * i);
            MazeGrid.MazeSegment seg = this.grid.getSegment(chest.x, chest.y);
            UUID key = gen.createNewDoorKeyId();
            seg.setTypeKeyChest(key);
            seg.specialLock = true;
            seg.markVisited();
            this.backtrackStepper.reset();
            this.backtrackStepper.sortHorizontally();
            this.backtrackStepper.doStep(this.grid, chest.x, chest.y, true, true, new BacktrackDiscoverer.GenerateDoorAfterStepCondition(1 + this.seededRand.nextInt(2), 2));
            reached = this.backtrackStepper.getReachedPoint();
            ShiftMazeState chestState = gen.createNewMazeState();
            if (reached != null) {
                boolean gennedDoor = false;
                List<ForgeDirection> dirs = this.sortDirections(reached, new Point(reached.x, center.y));
                for (ForgeDirection dir : dirs) {
                    if (!MazeCalculator.canGenerateDoor(this.grid, reached.x, reached.y, dir, 2)) continue;
                    Point genGoal = this.genDoorUnsafe(reached.x, reached.y, dir, chestState);
                    this.generationGoals.put(genGoal, chest);
                    this.bufferedStates.put(genGoal, chestState);
                    gennedDoor = true;
                    break;
                }
                if (gennedDoor) continue;
                throw new IllegalStateException("Could not generate a chest door.");
            }
            throw new IllegalStateException("Maze too small.");
        }
    }

    public static boolean canGenerateDoor(MazeGrid grid, int sX, int sZ, ForgeDirection dir, int dstToBorders) {
        Point doorE = new Point(sX + dir.offsetX, sZ + dir.offsetZ);
        return grid.isFree(doorE.x, doorE.y) && !MazeCalculator.violatesAnchors(doorE, grid, null, null, dstToBorders);
    }

    private Point genDoorUnsafe(int sX, int sZ, ForgeDirection dir, ShiftMazeState ... doorStates) {
        MazeGrid.MazeSegment seg = this.grid.getSegment(sX, sZ);
        seg.specialLock = true;
        seg.addConnection(dir);
        seg.markVisited();
        Point to = new Point(sX + dir.offsetX, sZ + dir.offsetZ);
        seg = this.grid.getSegment(to.x, to.y);
        seg.specialLock = true;
        seg.markVisited();
        MazeGrid.ShiftMazeDoor door = this.grid.appendDoor(new Point(sX, sZ), to, dir);
        Collections.addAll(door.doorStates, doorStates);
        return to;
    }

    private List<ForgeDirection> sortDirections(Point current, Point aim) {
        LinkedList<ForgeDirection> dirs = new LinkedList<ForgeDirection>();
        if (this.seededRand.nextBoolean()) {
            dirs.add(ForgeDirection.NORTH);
            dirs.add(ForgeDirection.SOUTH);
        } else {
            dirs.add(ForgeDirection.SOUTH);
            dirs.add(ForgeDirection.NORTH);
        }
        dirs.add(ForgeDirection.WEST);
        return dirs;
    }

    private Point getRandomPos(int xLayer) {
        int rZOffset = this.seededRand.nextInt(this.grid.getZSize());
        for (int zz = 0; zz < this.grid.getZSize(); ++zz) {
            int pZ = (zz + rZOffset) % this.grid.getZSize();
            Point p = new Point(xLayer, pZ);
            if (!this.grid.isFree(xLayer, pZ) || MazeCalculator.violatesAnchors(p, this.grid, this.getGenerationGoals(), this.getPlayerGoals(), 2)) continue;
            return p;
        }
        throw new IllegalStateException("Cannot get random position that's far enough away from all current anchors. Maze too small?");
    }

    private static boolean violatesAnchors(Point p, MazeGrid grid, Collection<Point> genGoals, Collection<Point> plGoals, int dstToBorders) {
        int zDiff;
        int xDiff;
        if (p.x < dstToBorders || p.y < dstToBorders || p.x > grid.getXSize() - dstToBorders - 1 || p.y > grid.getZSize() - dstToBorders - 1) {
            return true;
        }
        if (Math.abs(grid.getXSize() - p.x) < 2 && Math.abs(grid.getZSize() / 2 - p.y) < 2) {
            return true;
        }
        if (Math.abs(p.x) < 2 && Math.abs(grid.getZSize() / 2 - p.y) < 2) {
            return true;
        }
        if (genGoals != null) {
            for (Point other : genGoals) {
                xDiff = Math.abs(other.x - p.x);
                zDiff = Math.abs(other.y - p.y);
                if (xDiff == 0 || zDiff == 0) {
                    return true;
                }
                if (xDiff + zDiff >= 3) continue;
                return true;
            }
        }
        if (plGoals != null) {
            for (Point other : plGoals) {
                xDiff = Math.abs(other.x - p.x);
                zDiff = Math.abs(other.y - p.y);
                if (xDiff == 0 || zDiff == 0) {
                    return true;
                }
                if (xDiff + zDiff >= 3) continue;
                return true;
            }
        }
        return false;
    }

    public static class ComparatorGridDistance
    implements Comparator<Point> {
        private final Point toCompareTo;

        public ComparatorGridDistance(Point toCompareTo) {
            this.toCompareTo = toCompareTo;
        }

        @Override
        public int compare(Point o1, Point o2) {
            int x1Diff = Math.abs(this.toCompareTo.x - o1.x);
            int x2Diff = Math.abs(this.toCompareTo.x - o2.x);
            return x1Diff - x2Diff;
        }
    }

    public static class BufferedDoorState {
        public final Point from;
        public final Point to;
        public final ForgeDirection dir;
        public final MazeSegmentNode fromNode;
        public final MazeSegmentNode toNode;

        private BufferedDoorState(Point from, Point to, ForgeDirection dir, MazeSegmentNode fromNode, MazeSegmentNode toNode) {
            this.from = from;
            this.to = to;
            this.dir = dir;
            this.fromNode = fromNode;
            this.toNode = toNode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BufferedDoorState that = (BufferedDoorState)o;
            return this.from.equals(that.from) && this.to.equals(that.to) && this.fromNode.equals(that.fromNode) && this.toNode.equals(that.toNode) || this.from.equals(that.to) && this.to.equals(that.from) && this.fromNode.equals(that.toNode) && this.toNode.equals(that.fromNode);
        }
    }
}

