/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation;

import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.MazeCalculator;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.MazeSegmentNode;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.MazeGrid;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MazeSegmentGraph {
    private Map<Integer, MazeSegmentNode> segmentNodes = new HashMap<Integer, MazeSegmentNode>();

    public MazeSegmentNode createOrGetNode(int id) {
        if (this.segmentNodes.containsKey(id)) {
            return this.segmentNodes.get(id);
        }
        MazeSegmentNode node = new MazeSegmentNode(id);
        this.segmentNodes.put(id, node);
        return node;
    }

    public void connect(MazeSegmentNode segNode, MazeSegmentNode otherNode) {
        if (!segNode.connectionDoors.containsKey(otherNode)) {
            segNode.connectionDoors.put(otherNode, new LinkedList());
        }
        if (!otherNode.connectionDoors.containsKey(segNode)) {
            otherNode.connectionDoors.put(segNode, new LinkedList());
        }
    }

    public void checkAndDisconnect(MazeSegmentNode segNode, MazeSegmentNode otherNode) {
        if (segNode.connectionDoors.containsKey(otherNode)) {
            if (segNode.connectionDoors.get(otherNode).isEmpty()) {
                segNode.connectionDoors.remove(otherNode);
                otherNode.connectionDoors.remove(segNode);
            }
        } else if (otherNode.connectionDoors.containsKey(segNode) && otherNode.connectionDoors.get(segNode).isEmpty()) {
            otherNode.connectionDoors.remove(segNode);
            segNode.connectionDoors.remove(otherNode);
        }
    }

    public MazeSegmentNode getNode(int id) {
        return this.segmentNodes.get(id);
    }

    public Collection<Integer> getAllKnownNodeIDs() {
        return Collections.unmodifiableCollection(this.segmentNodes.keySet());
    }

    public void pushNewDoor(MazeCalculator.BufferedDoorState emptyDoor) {
        MazeGrid.ShiftMazeDoor door = new MazeGrid.ShiftMazeDoor(emptyDoor.from, emptyDoor.to, emptyDoor.dir);
        emptyDoor.fromNode.connectionDoors.get(emptyDoor.toNode).add(door);
        emptyDoor.toNode.connectionDoors.get(emptyDoor.fromNode).add(door);
    }
}

