/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze;

import Reika.ChromatiCraft.Block.Dimension.Structure.ShiftMaze.BlockShiftLock;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.MazeBaseBuilder;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.MazeGrid;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Part.MazePartEndCore;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Part.MazePartEndDoor;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Part.MazePartEndDoorConnector;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.ShiftMazeState;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMazeGenerator;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;

public class MazeBuilder {
    private final ChunkSplicedGenerationCache world;
    private final int offsetX;
    private final int offsetZ;
    private final int posY;

    public MazeBuilder(ChunkSplicedGenerationCache world, int offsetX, int posY, int offsetZ) {
        this.world = world;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
        this.posY = posY;
    }

    public void placeControllerTile(ShiftMazeGenerator gen, int x, int y, int z) {
        gen.generateDataTile(x, y, z, new Object[0]);
        gen.generatePasswordTile(x, y - 1, z);
    }

    public void build(ShiftMazeGenerator gen, MazeGrid finishedGrid) {
        int translatedZ;
        int translatedX;
        int zz;
        int xx;
        for (xx = 0; xx < finishedGrid.getXSize(); ++xx) {
            for (zz = 0; zz < finishedGrid.getZSize(); ++zz) {
                translatedX = this.offsetX + (xx * 4 - 1);
                translatedZ = this.offsetZ + (zz * 4 - 1);
                MazeBaseBuilder.doBasicGen(this.world, translatedX, this.posY, translatedZ);
            }
        }
        for (xx = 0; xx < finishedGrid.getXSize(); ++xx) {
            for (zz = 0; zz < finishedGrid.getZSize(); ++zz) {
                translatedX = this.offsetX + (xx * 4 - 1);
                translatedZ = this.offsetZ + (zz * 4 - 1);
                MazeGrid.MazeSegment segment = finishedGrid.getSegment(xx, zz);
                MazeBaseBuilder.build(gen, this.world, translatedX, this.posY, translatedZ, segment);
            }
        }
        for (MazeGrid.ShiftMazeDoor door : finishedGrid.getSplittingDoors()) {
            int trX = this.offsetX + (door.pointDirFrom.x * 4 - 1);
            int trZ = this.offsetZ + (door.pointDirFrom.y * 4 - 1);
            List<ShiftMazeState> states = door.doorStates;
            switch (door.dir) {
                case NORTH: {
                    this.setDoor(gen, this.world, trX + 1, this.posY + 1, trZ, states);
                    this.setDoor(gen, this.world, trX + 1, this.posY + 2, trZ, states);
                    this.setDoor(gen, this.world, trX + 1, this.posY + 3, trZ, states);
                    this.setDoor(gen, this.world, trX + 2, this.posY + 1, trZ, states);
                    this.setDoor(gen, this.world, trX + 2, this.posY + 2, trZ, states);
                    this.setDoor(gen, this.world, trX + 2, this.posY + 3, trZ, states);
                    this.setDoor(gen, this.world, trX + 3, this.posY + 1, trZ, states);
                    this.setDoor(gen, this.world, trX + 3, this.posY + 2, trZ, states);
                    this.setDoor(gen, this.world, trX + 3, this.posY + 3, trZ, states);
                    break;
                }
                case SOUTH: {
                    this.setDoor(gen, this.world, trX + 1, this.posY + 1, trZ + 4, states);
                    this.setDoor(gen, this.world, trX + 1, this.posY + 2, trZ + 4, states);
                    this.setDoor(gen, this.world, trX + 1, this.posY + 3, trZ + 4, states);
                    this.setDoor(gen, this.world, trX + 2, this.posY + 1, trZ + 4, states);
                    this.setDoor(gen, this.world, trX + 2, this.posY + 2, trZ + 4, states);
                    this.setDoor(gen, this.world, trX + 2, this.posY + 3, trZ + 4, states);
                    this.setDoor(gen, this.world, trX + 3, this.posY + 1, trZ + 4, states);
                    this.setDoor(gen, this.world, trX + 3, this.posY + 2, trZ + 4, states);
                    this.setDoor(gen, this.world, trX + 3, this.posY + 3, trZ + 4, states);
                    break;
                }
                case WEST: {
                    this.setDoor(gen, this.world, trX, this.posY + 1, trZ + 1, states);
                    this.setDoor(gen, this.world, trX, this.posY + 2, trZ + 1, states);
                    this.setDoor(gen, this.world, trX, this.posY + 3, trZ + 1, states);
                    this.setDoor(gen, this.world, trX, this.posY + 1, trZ + 2, states);
                    this.setDoor(gen, this.world, trX, this.posY + 2, trZ + 2, states);
                    this.setDoor(gen, this.world, trX, this.posY + 3, trZ + 2, states);
                    this.setDoor(gen, this.world, trX, this.posY + 1, trZ + 3, states);
                    this.setDoor(gen, this.world, trX, this.posY + 2, trZ + 3, states);
                    this.setDoor(gen, this.world, trX, this.posY + 3, trZ + 3, states);
                    break;
                }
                case EAST: {
                    this.setDoor(gen, this.world, trX + 4, this.posY + 1, trZ + 1, states);
                    this.setDoor(gen, this.world, trX + 4, this.posY + 2, trZ + 1, states);
                    this.setDoor(gen, this.world, trX + 4, this.posY + 3, trZ + 1, states);
                    this.setDoor(gen, this.world, trX + 4, this.posY + 1, trZ + 2, states);
                    this.setDoor(gen, this.world, trX + 4, this.posY + 2, trZ + 2, states);
                    this.setDoor(gen, this.world, trX + 4, this.posY + 3, trZ + 2, states);
                    this.setDoor(gen, this.world, trX + 4, this.posY + 1, trZ + 3, states);
                    this.setDoor(gen, this.world, trX + 4, this.posY + 2, trZ + 3, states);
                    this.setDoor(gen, this.world, trX + 4, this.posY + 3, trZ + 3, states);
                }
            }
        }
    }

    private void setDoor(ShiftMazeGenerator gen, ChunkSplicedGenerationCache world, int x, int y, int z, List<ShiftMazeState> states) {
        world.setBlock(x, y, z, ChromaBlocks.SHIFTLOCK.getBlockInstance(), states.contains(gen.getActiveState()) ? BlockShiftLock.Passability.OPEN.ordinal() : BlockShiftLock.Passability.CLOSED.ordinal());
        gen.addToggleDoor(x, y, z, states);
    }

    public void buildMazeBase(MazeGrid grid) {
        int yy;
        int zz;
        int xx;
        Block sh = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        int ms = BlockStructureShield.BlockType.STONE.metadata;
        int mg = BlockStructureShield.BlockType.GLASS.metadata;
        int maxX = grid.getXSize() * 4;
        int maxZ = grid.getZSize() * 4;
        Block gl = ChromaBlocks.SPECIALSHIELD.getBlockInstance();
        for (xx = -1; xx < maxX; ++xx) {
            for (zz = -1; zz < maxZ; ++zz) {
                for (int yy2 = 0; yy2 < 9; ++yy2) {
                    this.world.setAir(this.offsetX + xx, this.posY + yy2, this.offsetZ + zz);
                }
            }
        }
        for (xx = -1; xx < maxX; ++xx) {
            for (zz = -1; zz < maxZ; ++zz) {
                this.world.setBlock(this.offsetX + xx, this.posY, this.offsetZ + zz, sh, ms);
                this.world.setBlock(this.offsetX + xx, this.posY + 4, this.offsetZ + zz, gl, mg);
                this.world.setBlock(this.offsetX + xx, this.posY + 8, this.offsetZ + zz, sh, ms);
            }
        }
        for (xx = -1; xx < maxX; ++xx) {
            for (yy = 0; yy < 9; ++yy) {
                this.world.setBlock(this.offsetX + xx, this.posY + yy, this.offsetZ - 1, sh, ms);
                this.world.setBlock(this.offsetX + xx, this.posY + yy, this.offsetZ + maxZ - 1, sh, ms);
            }
        }
        for (int zz2 = -1; zz2 < maxZ; ++zz2) {
            for (yy = 0; yy < 9; ++yy) {
                this.world.setBlock(this.offsetX - 1, this.posY + yy, this.offsetZ + zz2, sh, ms);
                this.world.setBlock(this.offsetX + maxX - 1, this.posY + yy, this.offsetZ + zz2, sh, ms);
            }
        }
    }

    public void buildEntrance(int centerX, int lowestY, int centerZ) {
        this.cleanCorridor(centerX, lowestY - 1, centerZ);
        Block sh = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        int ms = BlockStructureShield.BlockType.STONE.metadata;
        this.world.setBlock(centerX, lowestY + 2, centerZ, sh, ms);
        this.world.setBlock(centerX, lowestY + 2, centerZ + 1, sh, ms);
        this.world.setBlock(centerX, lowestY + 2, centerZ - 1, sh, ms);
        this.world.setAir(centerX, lowestY + 3, centerZ + 3);
        this.world.setAir(centerX, lowestY + 3, centerZ + 4);
        this.world.setAir(centerX, lowestY + 4, centerZ + 3);
        this.world.setAir(centerX, lowestY + 4, centerZ + 4);
        this.world.setAir(centerX, lowestY + 5, centerZ + 3);
        this.world.setAir(centerX, lowestY + 5, centerZ + 4);
        this.world.setAir(centerX, lowestY + 3, centerZ - 3);
        this.world.setAir(centerX, lowestY + 3, centerZ - 4);
        this.world.setAir(centerX, lowestY + 4, centerZ - 3);
        this.world.setAir(centerX, lowestY + 4, centerZ - 4);
        this.world.setAir(centerX, lowestY + 5, centerZ - 3);
        this.world.setAir(centerX, lowestY + 5, centerZ - 4);
    }

    public void buildExit(ShiftMazeGenerator gen, int endX, int posY, int endZ, List<UUID> createdKeys) {
        int xCursor = endX;
        this.cleanCorridor(xCursor, posY + 1, endZ);
        this.buildTransitionRing(--xCursor, posY, endZ);
        MazePartEndDoorConnector partCon = new MazePartEndDoorConnector(gen);
        MazePartEndCore partEnd = new MazePartEndCore(gen);
        --xCursor;
        for (UUID key : createdKeys) {
            xCursor = partCon.generateAndMoveCursor(this.world, xCursor, posY, endZ, xCursor);
            MazePartEndDoor door = new MazePartEndDoor(gen, key);
            xCursor = door.generateAndMoveCursor(this.world, xCursor, posY, endZ, xCursor);
        }
        partEnd.generate(this.world, xCursor, posY, endZ);
    }

    private void cleanCorridor(int posX, int posY, int posZ) {
        this.world.setAir(posX, posY, posZ);
        this.world.setAir(posX, posY, posZ + 1);
        this.world.setAir(posX, posY, posZ - 1);
        this.world.setAir(posX, posY + 1, posZ);
        this.world.setAir(posX, posY + 1, posZ + 1);
        this.world.setAir(posX, posY + 1, posZ - 1);
        this.world.setAir(posX, posY + 2, posZ);
        this.world.setAir(posX, posY + 2, posZ + 1);
        this.world.setAir(posX, posY + 2, posZ - 1);
    }

    private void buildTransitionRing(int posX, int posY, int posZ) {
        Block sh = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        int ms = BlockStructureShield.BlockType.STONE.metadata;
        this.world.setBlock(posX, posY, posZ, sh, ms);
        this.world.setBlock(posX, posY, posZ + 1, sh, ms);
        this.world.setBlock(posX, posY, posZ + 2, sh, ms);
        this.world.setBlock(posX, posY, posZ - 1, sh, ms);
        this.world.setBlock(posX, posY, posZ - 2, sh, ms);
        this.world.setBlock(posX, posY + 1, posZ + 2, sh, ms);
        this.world.setBlock(posX, posY + 1, posZ - 2, sh, ms);
        this.world.setBlock(posX, posY + 2, posZ + 2, sh, ms);
        this.world.setBlock(posX, posY + 2, posZ - 2, sh, ms);
        this.world.setBlock(posX, posY + 3, posZ + 2, sh, ms);
        this.world.setBlock(posX, posY + 3, posZ - 2, sh, ms);
        this.world.setBlock(posX, posY + 4, posZ, sh, ms);
        this.world.setBlock(posX, posY + 4, posZ + 1, sh, ms);
        this.world.setBlock(posX, posY + 4, posZ + 2, sh, ms);
        this.world.setBlock(posX, posY + 4, posZ - 1, sh, ms);
        this.world.setBlock(posX, posY + 4, posZ - 2, sh, ms);
        this.cleanCorridor(posX, posY + 1, posZ);
    }
}

