/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze;

import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.SegmentRestriction;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.MazePartGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.ShiftMazeState;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.util.ForgeDirection;

public class MazeGrid
implements SegmentRestriction {
    private final Map<Point, MazeSegment> segmentMap;
    private final int xSize;
    private final int zSize;
    private List<ShiftMazeDoor> splittingDoors = new LinkedList<ShiftMazeDoor>();

    public MazeGrid(int xSize, int zSize) {
        this.segmentMap = new HashMap<Point, MazeSegment>();
        for (int xx = 0; xx < xSize; ++xx) {
            for (int zz = 0; zz < zSize; ++zz) {
                this.segmentMap.put(new Point(xx, zz), new MazeSegment());
            }
        }
        this.xSize = xSize;
        this.zSize = zSize;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getZSize() {
        return this.zSize;
    }

    public Point getCentralSegment() {
        return new Point(this.getXSize() / 2, this.getZSize() / 2);
    }

    public Point getStartSegmentPos() {
        return new Point(this.getXSize() - 1, this.getZSize() / 2);
    }

    public Point getEndSegmentPos() {
        return new Point(0, this.getZSize() / 2);
    }

    @Override
    public boolean isInBounds(int x, int z) {
        return x >= 0 && z >= 0 && x < this.xSize && z < this.zSize;
    }

    public MazeSegment getSegment(int x, int z) {
        Point p = new Point(x, z);
        if (!this.segmentMap.containsKey(p)) {
            throw new ArrayIndexOutOfBoundsException("Point out of bounds: x=" + x + ", z=" + z + " - Bounds: xSize=" + this.xSize + ", zSize=" + this.zSize);
        }
        return this.segmentMap.get(new Point(x, z));
    }

    public boolean isFree(int x, int z) {
        if (!this.isInBounds(x, z)) {
            return false;
        }
        MazeSegment seg = this.getSegment(x, z);
        return seg.getType().equals((Object)SegmentType.CORRIDOR) && !seg.wasVisited();
    }

    public MazeGrid subGrid(int offsetX, int offsetZ, int sizeX, int sizeZ) {
        if (!this.isInBounds(offsetX, offsetZ) || !this.isInBounds(offsetX + sizeX, offsetZ + sizeZ)) {
            throw new IllegalArgumentException("Out Of Bounds subGrid creation");
        }
        return new SubGrid(this, offsetX, offsetZ, sizeX, sizeZ);
    }

    public ShiftMazeDoor appendDoor(Point p1, Point p2, ForgeDirection dir) {
        if (this.getDoor(p1, p2) != null) {
            return null;
        }
        ShiftMazeDoor door = new ShiftMazeDoor(p1, p2, dir);
        this.splittingDoors.add(door);
        return door;
    }

    public ShiftMazeDoor getDoor(Point p1, Point p2) {
        if (!this.isInBounds(p1.x, p2.x) || !this.isInBounds(p2.x, p2.y)) {
            return null;
        }
        for (ShiftMazeDoor door : this.splittingDoors) {
            if (!door.pointDirFrom.equals(p1) || !door.pointDirTo.equals(p2) || !door.pointDirFrom.equals(p2) || !door.pointDirTo.equals(p1)) continue;
            return door;
        }
        return null;
    }

    public Collection<ShiftMazeDoor> getSplittingDoors() {
        return Collections.unmodifiableCollection(this.splittingDoors);
    }

    public static class ShiftMazeDoor {
        private static int dCounter = 0;
        private final int id;
        public final Point pointDirFrom;
        public final Point pointDirTo;
        public final ForgeDirection dir;
        public final List<ShiftMazeState> doorStates = new LinkedList<ShiftMazeState>();

        public ShiftMazeDoor(Point p1, Point p2, ForgeDirection dir) {
            this.id = dCounter++;
            this.pointDirFrom = p1;
            this.pointDirTo = p2;
            this.dir = dir;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShiftMazeDoor that = (ShiftMazeDoor)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static class SubGrid
    extends MazeGrid {
        private final MazeGrid parent;
        private final int offsetX;
        private final int offsetZ;

        private SubGrid(MazeGrid parent, int offsetSubX, int offsetSubZ, int sizeX, int sizeZ) {
            super(sizeX, sizeZ);
            this.parent = parent;
            this.offsetX = offsetSubX;
            this.offsetZ = offsetSubZ;
        }

        @Override
        public Point getStartSegmentPos() {
            throw new IllegalStateException("SubGrid doesn't have a start necessarily.");
        }

        @Override
        public Point getEndSegmentPos() {
            throw new IllegalStateException("SubGrid doesn't have a end necessarily.");
        }

        @Override
        public Point getCentralSegment() {
            Point center = this.parent.getCentralSegment();
            return new Point(this.offsetX + center.x, this.offsetZ + center.y);
        }

        @Override
        public boolean isInBounds(int x, int z) {
            return this.parent.isInBounds(this.offsetX + x, this.offsetZ + z);
        }

        @Override
        public ShiftMazeDoor appendDoor(Point p1, Point p2, ForgeDirection dir) {
            return this.parent.appendDoor(p1, p2, dir);
        }

        @Override
        public ShiftMazeDoor getDoor(Point p1, Point p2) {
            return this.parent.getDoor(p1, p2);
        }

        @Override
        public boolean isFree(int x, int z) {
            return this.parent.isFree(this.offsetX + x, this.offsetZ + z);
        }

        @Override
        public MazeSegment getSegment(int x, int z) {
            return this.parent.getSegment(this.offsetX + x, this.offsetZ + z);
        }

        @Override
        public MazeGrid subGrid(int offsetX, int offsetZ, int sizeX, int sizeZ) {
            return super.subGrid(this.offsetX + offsetX, this.offsetZ + offsetZ, sizeX, sizeZ);
        }
    }

    public static enum SegmentType {
        CORRIDOR(new MazePartGenerator()),
        CHEST(new MazePartGenerator.ChestGenerator());

        private MazePartGenerator extraGen;

        private SegmentType(MazePartGenerator extraGen) {
            this.extraGen = extraGen;
        }

        public MazePartGenerator getExtraGen() {
            return this.extraGen;
        }
    }

    public static class MazeSegment {
        public static final List<ForgeDirection> VALID_CONNECTIONS = new LinkedList<ForgeDirection>();
        private SegmentType type = SegmentType.CORRIDOR;
        private List<ForgeDirection> connections = new LinkedList<ForgeDirection>();
        private boolean visited = false;
        public boolean specialLock = false;
        protected UUID keyUUID;

        public SegmentType getType() {
            return this.type;
        }

        public void setTypeKeyChest(UUID keyUUID) {
            this.keyUUID = keyUUID;
            this.type = SegmentType.CHEST;
        }

        public void addConnection(ForgeDirection dir) {
            if (this.isValid(dir)) {
                this.connections.add(dir);
            }
        }

        public void markVisited() {
            this.visited = true;
        }

        public void markNonVisited() {
            this.visited = false;
        }

        public boolean wasVisited() {
            return this.visited;
        }

        private boolean isValid(ForgeDirection dir) {
            return VALID_CONNECTIONS.contains(dir);
        }

        public List<ForgeDirection> getConnections() {
            return this.connections;
        }

        static {
            VALID_CONNECTIONS.add(ForgeDirection.NORTH);
            VALID_CONNECTIONS.add(ForgeDirection.SOUTH);
            VALID_CONNECTIONS.add(ForgeDirection.WEST);
            VALID_CONNECTIONS.add(ForgeDirection.EAST);
        }
    }
}

