/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze;

import Reika.ChromatiCraft.Base.DynamicStructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMazeGenerator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class ShiftMazeEntrance
extends DynamicStructurePiece<ShiftMazeGenerator> {
    public ShiftMazeEntrance(ShiftMazeGenerator s) {
        super(s);
    }

    @Override
    public void generate(World world, int x, int z) {
        int y = ((ShiftMazeGenerator)this.parent).getPosY();
        this.generatePrefab(world, x, y, z - 5);
        int top = world.func_72825_h(x, z) - 1;
        ((ShiftMazeGenerator)this.parent).offsetEntry(9, 0);
        int dx = this.generateEntrance(world, x += 9, y += 5, z, top);
        ((ShiftMazeGenerator)this.parent).offsetEntry(dx, 0);
        this.generateSurface(world, (x += dx) - 2, top, z);
    }

    private void generateSurface(World world, int x, int y, int z) {
        for (int h = 0; h <= 4; ++h) {
            int r = 11 - h * 2;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    boolean wall;
                    int dx = x + i;
                    int dz = z + k;
                    int dy = y + h;
                    boolean bl = wall = Math.abs(i) >= 2 || Math.abs(k) >= 2;
                    if (wall) {
                        world.func_147465_d(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, 3);
                        continue;
                    }
                    world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                }
            }
        }
    }

    private int generateEntrance(World world, int x, int y, int z, int top) {
        int d = 0;
        int dy = top - y + 1;
        int h = y;
        while (dy > 0) {
            int step = dy < 12 ? dy : 8;
            this.generateShaft(world, x, h, z, step + 3, (dy -= step) == 0);
            x += 5;
            d += 5;
            h += step;
            if (dy <= 0) continue;
            int l = 8;
            this.generateTunnel(world, x, h, z, l);
            x += l - 1;
            d += l - 1;
        }
        return d;
    }

    private void generateTunnel(World world, int x, int y, int z, int l) {
        for (int i = -2; i <= 2; ++i) {
            int dz = z + i;
            for (int k = -2; k <= 2; ++k) {
                int dy = y + k;
                boolean wall = Math.abs(i) == 2 || Math.abs(k) == 2;
                for (int d = 0; d < l; ++d) {
                    int dx = x + d;
                    if (wall) {
                        world.func_147465_d(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, 3);
                        continue;
                    }
                    world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                }
            }
        }
    }

    private void generateShaft(World world, int x, int y, int z, int h, boolean top) {
        int i;
        for (i = -2; i <= 2; ++i) {
            int dx = x + i + 3;
            for (int k = -2; k <= 2; ++k) {
                int dz = z + k;
                for (int n = -3; n < h; ++n) {
                    boolean wall;
                    int dy = y + n;
                    boolean bl = wall = Math.abs(i) == 2 || Math.abs(k) == 2 || n == -3 || n == h - 1 && !top;
                    if (wall) {
                        int m = i == 0 && k == 0 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata;
                        world.func_147465_d(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m, 3);
                        continue;
                    }
                    if (n == -2) {
                        world.func_147449_b(dx, dy, dz, Blocks.field_150355_j);
                        continue;
                    }
                    world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                }
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (int k = -1; k < 2; ++k) {
                int dz = z + i;
                int dy = y + k;
                world.func_147449_b(x + 1, dy, dz, Blocks.field_150350_a);
            }
        }
    }

    private void generatePrefab(World world, int x, int y, int z) {
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        int ms = BlockStructureShield.BlockType.STONE.metadata;
        world.func_147465_d(x + 0, y + 0, z + 3, b, ms, 3);
        world.func_147465_d(x + 0, y + 0, z + 4, b, ms, 3);
        world.func_147465_d(x + 0, y + 0, z + 5, b, ms, 3);
        world.func_147465_d(x + 0, y + 0, z + 6, b, ms, 3);
        world.func_147465_d(x + 0, y + 0, z + 7, b, ms, 3);
        world.func_147465_d(x + 0, y + 1, z + 3, b, ms, 3);
        world.func_147465_d(x + 0, y + 1, z + 7, b, ms, 3);
        world.func_147465_d(x + 0, y + 2, z + 3, b, ms, 3);
        world.func_147465_d(x + 0, y + 2, z + 7, b, ms, 3);
        world.func_147465_d(x + 0, y + 3, z + 0, b, ms, 3);
        world.func_147465_d(x + 0, y + 3, z + 1, b, ms, 3);
        world.func_147465_d(x + 0, y + 3, z + 2, b, ms, 3);
        world.func_147465_d(x + 0, y + 3, z + 3, b, ms, 3);
        world.func_147465_d(x + 0, y + 3, z + 7, b, ms, 3);
        world.func_147465_d(x + 0, y + 3, z + 8, b, ms, 3);
        world.func_147465_d(x + 0, y + 3, z + 9, b, ms, 3);
        world.func_147465_d(x + 0, y + 3, z + 10, b, ms, 3);
        world.func_147465_d(x + 0, y + 4, z + 0, b, ms, 3);
        world.func_147465_d(x + 0, y + 4, z + 10, b, ms, 3);
        world.func_147465_d(x + 0, y + 5, z + 0, b, ms, 3);
        world.func_147465_d(x + 0, y + 5, z + 10, b, ms, 3);
        world.func_147465_d(x + 0, y + 6, z + 0, b, ms, 3);
        world.func_147465_d(x + 0, y + 6, z + 10, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 0, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 1, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 2, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 3, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 4, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 5, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 6, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 7, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 8, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 9, b, ms, 3);
        world.func_147465_d(x + 0, y + 7, z + 10, b, ms, 3);
        world.func_147465_d(x + 1, y + 0, z + 3, b, ms, 3);
        world.func_147465_d(x + 1, y + 0, z + 4, b, ms, 3);
        world.func_147465_d(x + 1, y + 0, z + 5, b, ms, 3);
        world.func_147465_d(x + 1, y + 0, z + 6, b, ms, 3);
        world.func_147465_d(x + 1, y + 0, z + 7, b, ms, 3);
        world.func_147465_d(x + 1, y + 1, z + 3, b, ms, 3);
        world.func_147465_d(x + 1, y + 1, z + 7, b, ms, 3);
        world.func_147465_d(x + 1, y + 2, z + 3, b, ms, 3);
        world.func_147465_d(x + 1, y + 2, z + 7, b, ms, 3);
        world.func_147465_d(x + 1, y + 3, z + 0, b, ms, 3);
        world.func_147465_d(x + 1, y + 3, z + 1, b, ms, 3);
        world.func_147465_d(x + 1, y + 3, z + 2, b, ms, 3);
        world.func_147465_d(x + 1, y + 3, z + 3, b, ms, 3);
        world.func_147465_d(x + 1, y + 3, z + 7, b, ms, 3);
        world.func_147465_d(x + 1, y + 3, z + 8, b, ms, 3);
        world.func_147465_d(x + 1, y + 3, z + 9, b, ms, 3);
        world.func_147465_d(x + 1, y + 3, z + 10, b, ms, 3);
        world.func_147465_d(x + 1, y + 4, z + 0, b, ms, 3);
        world.func_147465_d(x + 1, y + 4, z + 10, b, ms, 3);
        world.func_147465_d(x + 1, y + 5, z + 0, b, ms, 3);
        world.func_147465_d(x + 1, y + 5, z + 10, b, ms, 3);
        world.func_147465_d(x + 1, y + 6, z + 0, b, ms, 3);
        world.func_147465_d(x + 1, y + 6, z + 10, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 0, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 1, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 2, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 3, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 4, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 5, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 6, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 7, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 8, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 9, b, ms, 3);
        world.func_147465_d(x + 1, y + 7, z + 10, b, ms, 3);
        world.func_147465_d(x + 2, y + 0, z + 3, b, ms, 3);
        world.func_147465_d(x + 2, y + 0, z + 4, b, ms, 3);
        world.func_147465_d(x + 2, y + 0, z + 5, b, ms, 3);
        world.func_147465_d(x + 2, y + 0, z + 6, b, ms, 3);
        world.func_147465_d(x + 2, y + 0, z + 7, b, ms, 3);
        world.func_147465_d(x + 2, y + 1, z + 3, b, ms, 3);
        world.func_147465_d(x + 2, y + 1, z + 7, b, ms, 3);
        world.func_147465_d(x + 2, y + 2, z + 3, b, ms, 3);
        world.func_147465_d(x + 2, y + 2, z + 7, b, ms, 3);
        world.func_147465_d(x + 2, y + 3, z + 0, b, ms, 3);
        world.func_147465_d(x + 2, y + 3, z + 1, b, ms, 3);
        world.func_147465_d(x + 2, y + 3, z + 2, b, ms, 3);
        world.func_147465_d(x + 2, y + 3, z + 3, b, ms, 3);
        world.func_147465_d(x + 2, y + 3, z + 7, b, ms, 3);
        world.func_147465_d(x + 2, y + 3, z + 8, b, ms, 3);
        world.func_147465_d(x + 2, y + 3, z + 9, b, ms, 3);
        world.func_147465_d(x + 2, y + 3, z + 10, b, ms, 3);
        world.func_147465_d(x + 2, y + 4, z + 0, b, ms, 3);
        world.func_147465_d(x + 2, y + 4, z + 10, b, ms, 3);
        world.func_147465_d(x + 2, y + 5, z + 0, b, ms, 3);
        world.func_147465_d(x + 2, y + 5, z + 10, b, ms, 3);
        world.func_147465_d(x + 2, y + 6, z + 0, b, ms, 3);
        world.func_147465_d(x + 2, y + 6, z + 10, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 0, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 1, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 2, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 3, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 4, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 5, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 6, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 7, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 8, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 9, b, ms, 3);
        world.func_147465_d(x + 2, y + 7, z + 10, b, ms, 3);
        world.func_147465_d(x + 3, y + 1, z + 3, b, ms, 3);
        world.func_147465_d(x + 3, y + 1, z + 4, b, ms, 3);
        world.func_147465_d(x + 3, y + 1, z + 5, b, ms, 3);
        world.func_147465_d(x + 3, y + 1, z + 6, b, ms, 3);
        world.func_147465_d(x + 3, y + 1, z + 7, b, ms, 3);
        world.func_147465_d(x + 3, y + 2, z + 3, b, ms, 3);
        world.func_147465_d(x + 3, y + 2, z + 7, b, ms, 3);
        world.func_147465_d(x + 3, y + 3, z + 0, b, ms, 3);
        world.func_147465_d(x + 3, y + 3, z + 1, b, ms, 3);
        world.func_147465_d(x + 3, y + 3, z + 2, b, ms, 3);
        world.func_147465_d(x + 3, y + 3, z + 3, b, ms, 3);
        world.func_147465_d(x + 3, y + 3, z + 7, b, ms, 3);
        world.func_147465_d(x + 3, y + 3, z + 8, b, ms, 3);
        world.func_147465_d(x + 3, y + 3, z + 9, b, ms, 3);
        world.func_147465_d(x + 3, y + 3, z + 10, b, ms, 3);
        world.func_147465_d(x + 3, y + 4, z + 0, b, ms, 3);
        world.func_147465_d(x + 3, y + 4, z + 10, b, ms, 3);
        world.func_147465_d(x + 3, y + 5, z + 0, b, ms, 3);
        world.func_147465_d(x + 3, y + 5, z + 10, b, ms, 3);
        world.func_147465_d(x + 3, y + 6, z + 0, b, ms, 3);
        world.func_147465_d(x + 3, y + 6, z + 10, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 0, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 1, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 2, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 3, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 4, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 5, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 6, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 7, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 8, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 9, b, ms, 3);
        world.func_147465_d(x + 3, y + 7, z + 10, b, ms, 3);
        world.func_147465_d(x + 4, y + 2, z + 3, b, ms, 3);
        world.func_147465_d(x + 4, y + 2, z + 4, b, ms, 3);
        world.func_147465_d(x + 4, y + 2, z + 5, b, ms, 3);
        world.func_147465_d(x + 4, y + 2, z + 6, b, ms, 3);
        world.func_147465_d(x + 4, y + 2, z + 7, b, ms, 3);
        world.func_147465_d(x + 4, y + 3, z + 0, b, ms, 3);
        world.func_147465_d(x + 4, y + 3, z + 1, b, ms, 3);
        world.func_147465_d(x + 4, y + 3, z + 2, b, ms, 3);
        world.func_147465_d(x + 4, y + 3, z + 3, b, ms, 3);
        world.func_147465_d(x + 4, y + 3, z + 7, b, ms, 3);
        world.func_147465_d(x + 4, y + 3, z + 8, b, ms, 3);
        world.func_147465_d(x + 4, y + 3, z + 9, b, ms, 3);
        world.func_147465_d(x + 4, y + 3, z + 10, b, ms, 3);
        world.func_147465_d(x + 4, y + 4, z + 0, b, ms, 3);
        world.func_147465_d(x + 4, y + 4, z + 10, b, ms, 3);
        world.func_147465_d(x + 4, y + 5, z + 0, b, ms, 3);
        world.func_147465_d(x + 4, y + 5, z + 10, b, ms, 3);
        world.func_147465_d(x + 4, y + 6, z + 0, b, ms, 3);
        world.func_147465_d(x + 4, y + 6, z + 10, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 0, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 1, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 2, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 3, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 4, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 5, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 6, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 7, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 8, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 9, b, ms, 3);
        world.func_147465_d(x + 4, y + 7, z + 10, b, ms, 3);
        world.func_147465_d(x + 5, y + 3, z + 0, b, ms, 3);
        world.func_147465_d(x + 5, y + 3, z + 1, b, ms, 3);
        world.func_147465_d(x + 5, y + 3, z + 2, b, ms, 3);
        world.func_147465_d(x + 5, y + 3, z + 4, b, ms, 3);
        world.func_147465_d(x + 5, y + 3, z + 5, b, ms, 3);
        world.func_147465_d(x + 5, y + 3, z + 6, b, ms, 3);
        world.func_147465_d(x + 5, y + 3, z + 8, b, ms, 3);
        world.func_147465_d(x + 5, y + 3, z + 9, b, ms, 3);
        world.func_147465_d(x + 5, y + 3, z + 10, b, ms, 3);
        world.func_147465_d(x + 5, y + 4, z + 0, b, ms, 3);
        world.func_147465_d(x + 5, y + 4, z + 10, b, ms, 3);
        world.func_147465_d(x + 5, y + 5, z + 0, b, ms, 3);
        world.func_147465_d(x + 5, y + 5, z + 10, b, ms, 3);
        world.func_147465_d(x + 5, y + 6, z + 0, b, ms, 3);
        world.func_147465_d(x + 5, y + 6, z + 10, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 0, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 1, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 2, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 3, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 4, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 5, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 6, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 7, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 8, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 9, b, ms, 3);
        world.func_147465_d(x + 5, y + 7, z + 10, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 0, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 1, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 2, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 3, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 4, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 5, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 6, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 7, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 8, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 9, b, ms, 3);
        world.func_147465_d(x + 6, y + 3, z + 10, b, ms, 3);
        world.func_147465_d(x + 6, y + 4, z + 0, b, ms, 3);
        world.func_147465_d(x + 6, y + 4, z + 1, b, ms, 3);
        world.func_147465_d(x + 6, y + 4, z + 9, b, ms, 3);
        world.func_147465_d(x + 6, y + 4, z + 10, b, ms, 3);
        world.func_147465_d(x + 6, y + 5, z + 0, b, ms, 3);
        world.func_147465_d(x + 6, y + 5, z + 1, b, ms, 3);
        world.func_147465_d(x + 6, y + 5, z + 9, b, ms, 3);
        world.func_147465_d(x + 6, y + 5, z + 10, b, ms, 3);
        world.func_147465_d(x + 6, y + 6, z + 0, b, ms, 3);
        world.func_147465_d(x + 6, y + 6, z + 1, b, ms, 3);
        world.func_147465_d(x + 6, y + 6, z + 9, b, ms, 3);
        world.func_147465_d(x + 6, y + 6, z + 10, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 0, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 1, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 2, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 3, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 4, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 5, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 6, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 7, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 8, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 9, b, ms, 3);
        world.func_147465_d(x + 6, y + 7, z + 10, b, ms, 3);
        world.func_147465_d(x + 7, y + 3, z + 1, b, ms, 3);
        world.func_147465_d(x + 7, y + 3, z + 2, b, ms, 3);
        world.func_147465_d(x + 7, y + 3, z + 3, b, ms, 3);
        world.func_147465_d(x + 7, y + 3, z + 4, b, ms, 3);
        world.func_147465_d(x + 7, y + 3, z + 5, b, ms, 3);
        world.func_147465_d(x + 7, y + 3, z + 6, b, ms, 3);
        world.func_147465_d(x + 7, y + 3, z + 7, b, ms, 3);
        world.func_147465_d(x + 7, y + 3, z + 8, b, ms, 3);
        world.func_147465_d(x + 7, y + 3, z + 9, b, ms, 3);
        world.func_147465_d(x + 7, y + 4, z + 1, b, ms, 3);
        world.func_147465_d(x + 7, y + 4, z + 2, b, ms, 3);
        world.func_147465_d(x + 7, y + 4, z + 8, b, ms, 3);
        world.func_147465_d(x + 7, y + 4, z + 9, b, ms, 3);
        world.func_147465_d(x + 7, y + 5, z + 1, b, ms, 3);
        world.func_147465_d(x + 7, y + 5, z + 2, b, ms, 3);
        world.func_147465_d(x + 7, y + 5, z + 8, b, ms, 3);
        world.func_147465_d(x + 7, y + 5, z + 9, b, ms, 3);
        world.func_147465_d(x + 7, y + 6, z + 1, b, ms, 3);
        world.func_147465_d(x + 7, y + 6, z + 2, b, ms, 3);
        world.func_147465_d(x + 7, y + 6, z + 8, b, ms, 3);
        world.func_147465_d(x + 7, y + 6, z + 9, b, ms, 3);
        world.func_147465_d(x + 7, y + 7, z + 1, b, ms, 3);
        world.func_147465_d(x + 7, y + 7, z + 2, b, ms, 3);
        world.func_147465_d(x + 7, y + 7, z + 3, b, ms, 3);
        world.func_147465_d(x + 7, y + 7, z + 4, b, ms, 3);
        world.func_147465_d(x + 7, y + 7, z + 5, b, ms, 3);
        world.func_147465_d(x + 7, y + 7, z + 6, b, ms, 3);
        world.func_147465_d(x + 7, y + 7, z + 7, b, ms, 3);
        world.func_147465_d(x + 7, y + 7, z + 8, b, ms, 3);
        world.func_147465_d(x + 7, y + 7, z + 9, b, ms, 3);
        world.func_147465_d(x + 8, y + 3, z + 2, b, ms, 3);
        world.func_147465_d(x + 8, y + 3, z + 3, b, ms, 3);
        world.func_147465_d(x + 8, y + 3, z + 4, b, ms, 3);
        world.func_147465_d(x + 8, y + 3, z + 5, b, ms, 3);
        world.func_147465_d(x + 8, y + 3, z + 6, b, ms, 3);
        world.func_147465_d(x + 8, y + 3, z + 7, b, ms, 3);
        world.func_147465_d(x + 8, y + 3, z + 8, b, ms, 3);
        world.func_147465_d(x + 8, y + 4, z + 2, b, ms, 3);
        world.func_147465_d(x + 8, y + 4, z + 3, b, ms, 3);
        world.func_147465_d(x + 8, y + 4, z + 7, b, ms, 3);
        world.func_147465_d(x + 8, y + 4, z + 8, b, ms, 3);
        world.func_147465_d(x + 8, y + 5, z + 2, b, ms, 3);
        world.func_147465_d(x + 8, y + 5, z + 3, b, ms, 3);
        world.func_147465_d(x + 8, y + 5, z + 7, b, ms, 3);
        world.func_147465_d(x + 8, y + 5, z + 8, b, ms, 3);
        world.func_147465_d(x + 8, y + 6, z + 2, b, ms, 3);
        world.func_147465_d(x + 8, y + 6, z + 3, b, ms, 3);
        world.func_147465_d(x + 8, y + 6, z + 7, b, ms, 3);
        world.func_147465_d(x + 8, y + 6, z + 8, b, ms, 3);
        world.func_147465_d(x + 8, y + 7, z + 2, b, ms, 3);
        world.func_147465_d(x + 8, y + 7, z + 3, b, ms, 3);
        world.func_147465_d(x + 8, y + 7, z + 4, b, ms, 3);
        world.func_147465_d(x + 8, y + 7, z + 5, b, ms, 3);
        world.func_147465_d(x + 8, y + 7, z + 6, b, ms, 3);
        world.func_147465_d(x + 8, y + 7, z + 7, b, ms, 3);
        world.func_147465_d(x + 8, y + 7, z + 8, b, ms, 3);
        world.func_147465_d(x + 9, y + 3, z + 3, b, ms, 3);
        world.func_147465_d(x + 9, y + 3, z + 4, b, ms, 3);
        world.func_147465_d(x + 9, y + 3, z + 5, b, ms, 3);
        world.func_147465_d(x + 9, y + 3, z + 6, b, ms, 3);
        world.func_147465_d(x + 9, y + 3, z + 7, b, ms, 3);
        world.func_147465_d(x + 9, y + 4, z + 3, b, ms, 3);
        world.func_147465_d(x + 9, y + 4, z + 7, b, ms, 3);
        world.func_147465_d(x + 9, y + 5, z + 3, b, ms, 3);
        world.func_147465_d(x + 9, y + 5, z + 7, b, ms, 3);
        world.func_147465_d(x + 9, y + 6, z + 3, b, ms, 3);
        world.func_147465_d(x + 9, y + 6, z + 7, b, ms, 3);
        world.func_147465_d(x + 9, y + 7, z + 3, b, ms, 3);
        world.func_147465_d(x + 9, y + 7, z + 4, b, ms, 3);
        world.func_147465_d(x + 9, y + 7, z + 5, b, ms, 3);
        world.func_147465_d(x + 9, y + 7, z + 6, b, ms, 3);
        world.func_147465_d(x + 9, y + 7, z + 7, b, ms, 3);
        world.func_147465_d(x + 5, y + 3, z + 3, b, BlockStructureShield.BlockType.LIGHT.metadata, 3);
        world.func_147465_d(x + 5, y + 3, z + 7, b, BlockStructureShield.BlockType.LIGHT.metadata, 3);
        Block d = ChromaBlocks.DOOR.getBlockInstance();
        world.func_147449_b(x + 4, y + 4, z + 3, d);
        world.func_147449_b(x + 4, y + 4, z + 7, d);
        world.func_147449_b(x + 3, y + 4, z + 3, d);
        world.func_147449_b(x + 3, y + 4, z + 7, d);
        world.func_147449_b(x + 2, y + 4, z + 3, d);
        world.func_147449_b(x + 2, y + 4, z + 7, d);
        world.func_147449_b(x + 1, y + 4, z + 3, d);
        world.func_147449_b(x + 1, y + 4, z + 7, d);
        world.func_147449_b(x + 0, y + 4, z + 3, d);
        world.func_147449_b(x + 0, y + 4, z + 7, d);
        world.func_147449_b(x + 0, y + 1, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 1, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 1, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 2, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 2, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 2, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 3, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 3, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 3, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 4, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 4, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 4, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 4, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 4, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 4, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 4, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 5, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 5, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 5, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 5, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 5, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 5, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 5, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 5, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 5, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 6, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 6, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 6, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 6, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 6, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 6, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 6, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 6, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 0, y + 6, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 1, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 1, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 1, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 2, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 2, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 2, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 3, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 3, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 3, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 4, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 4, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 4, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 4, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 4, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 4, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 4, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 5, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 5, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 5, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 5, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 5, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 5, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 5, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 5, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 5, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 6, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 6, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 6, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 6, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 6, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 6, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 6, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 6, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 1, y + 6, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 1, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 1, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 1, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 2, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 2, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 2, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 3, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 3, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 3, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 4, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 4, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 4, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 4, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 4, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 4, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 4, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 5, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 5, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 5, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 5, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 5, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 5, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 5, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 5, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 5, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 6, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 6, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 6, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 6, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 6, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 6, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 6, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 6, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 2, y + 6, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 2, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 2, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 2, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 3, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 3, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 3, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 4, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 4, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 4, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 4, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 4, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 4, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 4, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 5, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 5, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 5, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 5, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 5, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 5, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 5, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 5, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 5, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 6, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 6, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 6, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 6, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 6, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 6, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 6, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 6, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 3, y + 6, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 3, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 3, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 3, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 4, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 4, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 4, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 4, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 4, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 4, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 4, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 5, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 5, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 5, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 5, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 5, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 5, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 5, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 5, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 5, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 6, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 6, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 6, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 6, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 6, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 6, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 6, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 6, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 4, y + 6, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 4, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 4, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 4, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 4, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 4, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 4, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 4, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 4, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 4, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 5, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 5, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 5, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 5, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 5, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 5, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 5, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 5, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 5, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 6, z + 1, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 6, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 6, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 6, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 6, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 6, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 6, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 6, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 5, y + 6, z + 9, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 4, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 4, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 4, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 4, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 4, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 4, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 4, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 5, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 5, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 5, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 5, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 5, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 5, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 5, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 6, z + 2, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 6, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 6, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 6, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 6, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 6, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 6, y + 6, z + 8, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 4, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 4, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 4, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 4, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 4, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 5, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 5, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 5, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 5, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 5, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 6, z + 3, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 6, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 6, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 6, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 7, y + 6, z + 7, Blocks.field_150350_a);
        world.func_147449_b(x + 8, y + 4, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 8, y + 4, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 8, y + 4, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 8, y + 5, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 8, y + 5, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 8, y + 5, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 8, y + 6, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 8, y + 6, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 8, y + 6, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 9, y + 4, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 9, y + 4, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 9, y + 4, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 9, y + 5, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 9, y + 5, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 9, y + 5, z + 6, Blocks.field_150350_a);
        world.func_147449_b(x + 9, y + 6, z + 4, Blocks.field_150350_a);
        world.func_147449_b(x + 9, y + 6, z + 5, Blocks.field_150350_a);
        world.func_147449_b(x + 9, y + 6, z + 6, Blocks.field_150350_a);
    }
}

