/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.Dimension.Structure.DataStorage.ShiftMazeData;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.Generation.MazeCalculator;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.MazeBuilder;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.MazeGrid;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.ShiftMazeEntrance;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMaze.ShiftMazeState;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ShiftMazeGenerator
extends DimensionStructureGenerator {
    private MazeGrid grid = null;
    private List<Coordinate> endDoorCoords = new LinkedList<Coordinate>();
    private List<Coordinate> toggleDoors = new LinkedList<Coordinate>();
    private List<UUID> requestedKeys = new LinkedList<UUID>();
    private List<ShiftMazeState> states = new ArrayList<ShiftMazeState>();
    private int indexActiveState = 0;

    @Override
    protected void calculate(int x, int z, Random rand) {
        this.posY = 20 + rand.nextInt(40);
        int rdX = this.calcSizeX(rand);
        int rdZ = this.calcSizeZ(rand);
        this.grid = new MazeGrid(rdX, rdZ);
        this.entryX = x + rdX * 4;
        this.entryZ = z + (rdZ / 2 * 4 + 1);
        int startSegX = x + rdX * 4 - 3;
        int startSegZ = z + (rdZ / 2 * 4 + 1);
        int endSegX = x + 1;
        int endSegZ = z + (rdZ / 2 * 4 + 1);
        int chestCount = this.getChestAmount();
        MazeCalculator calc = new MazeCalculator(this.grid, rand);
        calc.genFixedAnchors(this, chestCount);
        calc.calcMazeSegments();
        calc.calcSegmentInternalMazes();
        calc.calcSegmentGraph();
        calc.calcGraphPaths();
        calc.pushDoorsToGrid();
        this.indexActiveState = rand.nextInt(this.states.size());
        MazeBuilder builder = new MazeBuilder(this.world, x, this.posY, z);
        builder.buildMazeBase(this.grid);
        builder.build(this, this.grid);
        builder.placeControllerTile(this, startSegX + 2, this.posY + 6, startSegZ);
        builder.buildEntrance(startSegX + 2, this.posY + 2, startSegZ);
        builder.buildExit(this, endSegX - 2, this.posY, endSegZ, this.requestedKeys);
        this.addDynamicStructure(new ShiftMazeEntrance(this), this.entryX, this.entryZ);
    }

    private int getChestAmount() {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        return 6;
    }

    private int calcSizeX(Random rand) {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return rand.nextInt(4) * 2 + 18;
            }
            case 2: {
                return rand.nextInt(5) * 2 + 22;
            }
        }
        return rand.nextInt(6) * 2 + 24;
    }

    private int calcSizeZ(Random rand) {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return rand.nextInt(4) * 2 + 18;
            }
            case 2: {
                return rand.nextInt(5) * 2 + 22;
            }
        }
        return rand.nextInt(6) * 2 + 24;
    }

    @Override
    public StructureData createDataStorage() {
        return new ShiftMazeData(this);
    }

    public UUID createNewDoorKeyId() {
        UUID newKey = UUID.randomUUID();
        this.requestedKeys.add(newKey);
        return newKey;
    }

    public ShiftMazeState createNewMazeState() {
        ShiftMazeState state = new ShiftMazeState();
        this.states.add(state);
        return state;
    }

    public List<ShiftMazeState> getAllStates() {
        return Collections.unmodifiableList(this.states);
    }

    public void addEndDoor(int x, int y, int z) {
        this.endDoorCoords.add(new Coordinate(x, y, z));
    }

    public void addToggleDoor(int x, int y, int z, List<ShiftMazeState> states) {
        Coordinate c = new Coordinate(x, y, z);
        this.toggleDoors.add(c);
        for (ShiftMazeState state : states) {
            state.appendToggleDoor(c);
        }
    }

    public Collection<Coordinate> getAllToggleDoors() {
        return Collections.unmodifiableCollection(this.toggleDoors);
    }

    public ShiftMazeState getActiveState() {
        return this.states.get(this.indexActiveState);
    }

    public void cycleState() {
        this.indexActiveState = (this.indexActiveState + 1) % this.states.size();
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    protected void clearCaches() {
        this.grid = null;
        this.requestedKeys.clear();
        this.endDoorCoords.clear();
        this.toggleDoors.clear();
        this.states.clear();
        this.indexActiveState = 0;
    }

    @Override
    public boolean hasBeenSolved(World world) {
        for (Coordinate c : this.endDoorCoords) {
            if (BlockChromaDoor.isOpen((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void openStructure(World world) {
        for (Coordinate c : this.endDoorCoords) {
            ((BlockChromaDoor.TileEntityChromaDoor)c.getTileEntity((IBlockAccess)world)).open(-1);
        }
        for (Coordinate c : this.toggleDoors) {
            ((BlockChromaDoor.TileEntityChromaDoor)c.getTileEntity((IBlockAccess)world)).open(-1);
        }
    }
}

