/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.TDMaze;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.BlockHoverBlock;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.Structure.ThreeDMazeGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class MazeRoom
extends StructurePiece {
    private final HashSet<Coordinate> cells = new HashSet();
    public final int size;
    public final Coordinate center;
    public final int cellRadius;
    private final Random rand;

    public MazeRoom(ThreeDMazeGenerator s, int sz, int w, Coordinate c, Random r) {
        super(s);
        this.size = sz;
        this.center = c;
        this.cellRadius = w;
        this.rand = r;
    }

    public MazeRoom addCell(Coordinate c) {
        this.cells.add(c);
        return this;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        block17: {
            int dz;
            int dy;
            int dx;
            MultiMap openCells = new MultiMap(MultiMap.CollectionType.HASHSET);
            for (Coordinate c : this.cells) {
                c = c.offset(this.center.negate());
                for (int i = 0; i <= this.size; ++i) {
                    for (int j = 0; j <= this.size; ++j) {
                        for (int k = 0; k <= this.size; ++k) {
                            BlockKey bk;
                            int dx2 = x + c.xCoord * this.size + i;
                            int dy2 = y + c.yCoord * this.size + j;
                            int dz2 = z + c.zCoord * this.size + k;
                            if (j == 0) {
                                BlockKey bk2 = world.getBlock(dx2, dy2, dz2);
                                if (bk2 == null || bk2.blockID != Blocks.field_150350_a) continue;
                                world.setBlock(dx2, dy2, dz2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CRACKS.metadata);
                                openCells.addValue((Object)c, (Object)ForgeDirection.DOWN);
                                continue;
                            }
                            if (j == this.size) {
                                BlockKey bk3 = world.getBlock(dx2, dy2, dz2);
                                if (bk3 == null || bk3.blockID != Blocks.field_150350_a) continue;
                                world.setBlock(dx2, dy2, dz2, ChromaBlocks.HOVER.getBlockInstance(), BlockHoverBlock.HoverType.DAMPER.getPermanentMeta());
                                openCells.addValue((Object)c, (Object)ForgeDirection.UP);
                                continue;
                            }
                            boolean flag = false;
                            if (!(c.xCoord <= -this.cellRadius && i <= 0 || c.xCoord >= this.cellRadius && i >= this.size || c.zCoord <= -this.cellRadius && k <= 0 || c.zCoord >= this.cellRadius && k >= this.size)) {
                                world.setBlock(dx2, dy2, dz2, Blocks.field_150350_a);
                                flag = true;
                            }
                            if (flag || (bk = world.getBlock(dx2, dy2, dz2)) == null || bk.blockID != Blocks.field_150350_a) continue;
                            world.setBlock(dx2, dy2, dz2, Blocks.field_150411_aY);
                        }
                    }
                }
            }
            if (this.rand.nextInt(Math.max(1, 3 - this.cellRadius)) == 0) {
                String s = this.rand.nextBoolean() ? "dungeonChest" : "pyramidDesertyChest";
                ItemStack is = this.rand.nextBoolean() ? ChromaStacks.getChargedShard(CrystalElement.randomElement()) : ChromaStacks.rawCrystal.func_77946_l();
                int m = 2;
                if (this.cellRadius > 1 && this.rand.nextInt(4) == 0) {
                    is = ChromaStacks.complexIngot.func_77946_l();
                    m = 1;
                }
                is.field_77994_a = 1 + m * this.rand.nextInt(2 * this.cellRadius);
                this.parent.generateLootChest(x + this.size / 2, y + this.size / 2, z + this.size / 2, ReikaDirectionHelper.getRandomDirection((boolean)false, (Random)this.rand), s, this.rand.nextInt(1 + this.cellRadius), is, 100);
            }
            if (this.cellRadius != 2) break block17;
            if (this.rand.nextBoolean() && !openCells.get((Object)new Coordinate(0, 0, 0)).contains(ForgeDirection.DOWN)) {
                for (int i = -2; i <= this.size + 2; ++i) {
                    for (int k = -2; k <= this.size + 2; ++k) {
                        dx = x + i;
                        dy = y + 1;
                        dz = z + k;
                        if (i == -2 || i == this.size + 2 || k == -2 || k == this.size + 2) {
                            world.setBlock(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                            continue;
                        }
                        if (i == -1 || i == this.size + 1 || k == -1 || k == this.size + 1) {
                            world.setBlock(dx, dy, dz, ChromaBlocks.CHROMA.getBlockInstance());
                            continue;
                        }
                        if (i != 0 && i != this.size + 0 && k != 0 && k != this.size + 0) continue;
                        world.setBlock(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    }
                }
            } else {
                for (int i = -1; i <= this.size + 1; ++i) {
                    for (int k = -1; k <= this.size + 1; ++k) {
                        dx = x + i;
                        dy = y + 1;
                        dz = z + k;
                        if (i != -1 && i != this.size + 1 && k != -1 && k != this.size + 1) continue;
                        world.setBlock(dx, dy, dz, Blocks.field_150426_aN);
                        world.setBlock(dx, dy + 1, dz, Blocks.field_150426_aN);
                        world.setBlock(dx + 1, dy, dz, Blocks.field_150426_aN);
                        world.setBlock(dx - 1, dy, dz, Blocks.field_150426_aN);
                        world.setBlock(dx, dy, dz + 1, Blocks.field_150426_aN);
                        world.setBlock(dx, dy, dz - 1, Blocks.field_150426_aN);
                    }
                }
            }
        }
    }
}

