/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.Dimension.Structure.Traces.TracePuzzle;
import java.util.Random;
import net.minecraft.world.World;

public class TracePuzzleGenerator
extends DimensionStructureGenerator {
    private TracePuzzle[] puzzles;

    @Override
    protected void calculate(int chunkX, int chunkZ, Random rand) {
        this.puzzles = this.getPuzzles();
        this.posY = 20 + rand.nextInt(50);
        int x = chunkX;
        int y = this.posY;
        int z = chunkZ;
        for (int i = 0; i < this.puzzles.length; ++i) {
            TracePuzzle p = this.puzzles[i];
            p.calculate(rand);
            p.generate(this.world, x, y, z);
        }
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    protected void clearCaches() {
        this.puzzles = null;
    }

    private TracePuzzle[] getPuzzles() {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return new TracePuzzle[]{new TracePuzzle(this, 5, 4), new TracePuzzle(this, 5, 5), new TracePuzzle(this, 6, 6), new TracePuzzle(this, 10, 8)};
            }
            case 2: {
                return new TracePuzzle[]{new TracePuzzle(this, 5, 4), new TracePuzzle(this, 5, 5), new TracePuzzle(this, 6, 6), new TracePuzzle(this, 8, 8), new TracePuzzle(this, 12, 10)};
            }
        }
        return new TracePuzzle[]{new TracePuzzle(this, 4, 4), new TracePuzzle(this, 5, 5), new TracePuzzle(this, 6, 6), new TracePuzzle(this, 8, 8), new TracePuzzle(this, 10, 10), new TracePuzzle(this, 12, 12)};
    }

    @Override
    protected boolean hasBeenSolved(World world) {
        for (TracePuzzle p : this.puzzles) {
            if (p.hasBeenSolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void openStructure(World world) {
    }
}

