/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.Water;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Block.Dimension.Structure.Water.BlockRotatingLock;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.World.Dimension.Structure.Water.Lock;
import Reika.ChromatiCraft.World.Dimension.Structure.Water.WaterPath;
import Reika.ChromatiCraft.World.Dimension.Structure.WaterPuzzleGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.awt.Point;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WaterFloor
extends StructurePiece<WaterPuzzleGenerator> {
    public static final int HEIGHT = 7;
    public final int level;
    public final int gridSize;
    private final Lock[][] flowGrid;
    private final WaterPath path;
    private final HashSet<Coordinate> doorCoordinates = new HashSet();
    private final HashSet<Lock> checkpoints = new HashSet();
    private Coordinate origin;

    public WaterFloor(WaterPuzzleGenerator s, int lvl, int r, WaterPath path, Random rand) {
        super(s);
        this.level = lvl;
        this.gridSize = r * 2 + 1;
        this.flowGrid = new Lock[this.gridSize][this.gridSize];
        for (int i = 0; i < this.flowGrid.length; ++i) {
            for (int k = 0; k < this.flowGrid[i].length; ++k) {
                this.flowGrid[i][k] = new Lock(this, i - r, k - r);
                for (ForgeDirection dir : path.lockSides[i][k]) {
                    this.flowGrid[i][k].openEnds.add(dir);
                    while (rand.nextInt(4) > 0) {
                        this.flowGrid[i][k].rotate(false, false);
                    }
                }
            }
        }
        this.path = path;
        int c = 0;
        for (Point p : path.solution) {
            Lock l = this.getLock(p.x, p.y);
            if (++c <= 2 || rand.nextInt(Math.max(2, 6 - c)) != 0 || p.equals(path.startLoc) || p.equals(path.endLoc)) continue;
            c = 0;
            this.checkpoints.add(l);
        }
    }

    public int getWidth() {
        int r = (this.gridSize - 1) / 2;
        return r * 4 + (r - 1) * 2 + 6 + 4;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        int h;
        int k;
        this.origin = new Coordinate(x, y, z);
        boolean bottom = this.level == ((WaterPuzzleGenerator)this.parent).levelCount() - 1;
        int r0 = (this.gridSize - 1) / 2;
        for (int i = 0; i < this.flowGrid.length; ++i) {
            for (int k2 = 0; k2 < this.flowGrid[i].length; ++k2) {
                this.flowGrid[i][k2].centerLocation = new Coordinate(x, y, z).offset((i - r0) * 6, 1, (k2 - r0) * 6);
            }
        }
        int r = this.getWidth();
        for (int i = -r; i <= r; ++i) {
            for (k = -r; k <= r; ++k) {
                for (h = -3; h <= 7; ++h) {
                    if ((Math.abs(i) >= r - 4 || Math.abs(k) >= r - 4) && Math.abs(k) < r && Math.abs(i) < r && (h < 7 || Math.abs(i) > r - 4 && Math.abs(k) > r - 4)) {
                        if (Math.abs(i) == r - 4 || Math.abs(k) == r - 4) {
                            if (h <= 2) {
                                world.setBlock(x + i, y + h, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
                                continue;
                            }
                            world.setBlock(x + i, y + h, z + k, Blocks.field_150350_a);
                            continue;
                        }
                        if (h == 2) {
                            if (Math.abs(i) > r - 4 && Math.abs(k) > r - 4) {
                                world.setBlock(x + i, y + h, z + k, ChromaBlocks.DOOR.getBlockInstance());
                                this.doorCoordinates.add(new Coordinate(x + i, y + h, z + k));
                                continue;
                            }
                            world.setBlock(x + i, y + h, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), bottom ? BlockStructureShield.BlockType.STONE.metadata : BlockStructureShield.BlockType.GLASS.metadata);
                            continue;
                        }
                        world.setBlock(x + i, y + h, z + k, Blocks.field_150350_a);
                        continue;
                    }
                    if ((h >= 0 || Math.abs(i) < r - 4 || Math.abs(k) < r - 4) && (Math.abs(i) == r || Math.abs(k) == r || h == 0 && bottom || h == 7)) {
                        world.setBlock(x + i, y + h, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (Math.abs(i) + Math.abs(k)) % 6 == 0 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata);
                        continue;
                    }
                    if (h == 1) {
                        world.setBlock(x + i, y + h, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
                        continue;
                    }
                    if (h == 2) {
                        if (Math.abs(i) % 6 == 3 || Math.abs(k) % 6 == 3) {
                            world.setBlock(x + i, y + h, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), ReikaRandomHelper.doWithChance((double)40.0) ? BlockStructureShield.BlockType.MOSS.metadata : BlockStructureShield.BlockType.STONE.metadata);
                            continue;
                        }
                        world.setBlock(x + i, y + h, z + k, ChromaBlocks.WATERLOCK.getBlockInstance(), 1);
                        continue;
                    }
                    if (h < 0 && (Math.abs(i) >= r - 4 || Math.abs(k) >= r - 4)) continue;
                    if (h > 0) {
                        world.setBlock(x + i, y + h, z + k, Blocks.field_150350_a);
                        continue;
                    }
                    world.setBlock(x + i, y + h, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
                }
            }
        }
        if (this.level > 0) {
            int i;
            WaterFloor f = ((WaterPuzzleGenerator)this.parent).getLevel(this.level - 1);
            int r2 = f.getWidth();
            for (h = 8; h <= 11; ++h) {
                int k3;
                for (i = r2 - 3; i <= r; ++i) {
                    for (k3 = r2 - 3; k3 <= r; ++k3) {
                        world.setBlock(x + i, y + h, z + k3, Blocks.field_150350_a);
                        world.setBlock(x - i, y + h, z + k3, Blocks.field_150350_a);
                        world.setBlock(x + i, y + h, z - k3, Blocks.field_150350_a);
                        world.setBlock(x - i, y + h, z - k3, Blocks.field_150350_a);
                    }
                }
                for (i = -2; i <= 2; ++i) {
                    for (k3 = -2; k3 <= 2; ++k3) {
                        if (Math.abs(i) == 2 || Math.abs(k3) == 2 || h == 11) {
                            world.setBlock(x - r + 2 + i, y + h, z - r + 2 + k3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                            world.setBlock(x - r + 2 + i, y + h, z + r - 2 + k3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                            world.setBlock(x + r - 2 + i, y + h, z - r + 2 + k3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                            world.setBlock(x + r - 2 + i, y + h, z + r - 2 + k3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                            continue;
                        }
                        world.setBlock(x - r + 2 + i, y + h, z - r + 2 + k3, Blocks.field_150350_a);
                        world.setBlock(x - r + 2 + i, y + h, z + r - 2 + k3, Blocks.field_150350_a);
                        world.setBlock(x + r - 2 + i, y + h, z - r + 2 + k3, Blocks.field_150350_a);
                        world.setBlock(x + r - 2 + i, y + h, z + r - 2 + k3, Blocks.field_150350_a);
                    }
                }
                for (i = r2 - 4; i <= r; ++i) {
                    for (k3 = r2 - 4; k3 <= r; ++k3) {
                        if (Math.abs(i) <= r2 && Math.abs(k3) <= r2) continue;
                        world.setBlock(x + i, y + 7 + 4, z + k3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                        world.setBlock(x - i, y + 7 + 4, z + k3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                        world.setBlock(x + i, y + 7 + 4, z - k3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                        world.setBlock(x - i, y + 7 + 4, z - k3, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    }
                }
                for (i = r2; i <= r; ++i) {
                    world.setBlock(x + i, y + h, z + r2 - 4, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x - i, y + h, z + r2 - 4, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + i, y + h, z - r2 + 4, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x - i, y + h, z - r2 + 4, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + r2 - 4, y + h, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + r2 - 4, y + h, z - i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x - r2 + 4, y + h, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x - r2 + 4, y + h, z - i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                }
                for (i = r2 - 4; i <= r; ++i) {
                    world.setBlock(x + i, y + h, z + r, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + i, y + h, z - r, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x - i, y + h, z + r, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x - i, y + h, z - r, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + r, y + h, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x - r, y + h, z + i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x + r, y + h, z - i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                    world.setBlock(x - r, y + h, z - i, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                }
                world.setBlock(x + r2, y + h, z + r2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                world.setBlock(x - r2, y + h, z + r2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                world.setBlock(x + r2, y + h, z - r2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                world.setBlock(x - r2, y + h, z - r2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                world.setBlock(x + r2 + 1, y + h, z + r2 + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                world.setBlock(x - r2 - 1, y + h, z + r2 + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                world.setBlock(x + r2 + 1, y + h, z - r2 - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
                world.setBlock(x - r2 - 1, y + h, z - r2 - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            }
            for (h = 8; h < 11; ++h) {
                for (i = 1; i <= 3; ++i) {
                    world.setBlock(x + r - i, y + h, z + r - 4, Blocks.field_150350_a);
                    world.setBlock(x - r + i, y + h, z + r - 4, Blocks.field_150350_a);
                    world.setBlock(x + r - i, y + h, z - r + 4, Blocks.field_150350_a);
                    world.setBlock(x - r + i, y + h, z - r + 4, Blocks.field_150350_a);
                    world.setBlock(x - r + 4, y + h, z + r - i, Blocks.field_150350_a);
                    world.setBlock(x - r + 4, y + h, z - r + i, Blocks.field_150350_a);
                    world.setBlock(x + r - 4, y + h, z + r - i, Blocks.field_150350_a);
                    world.setBlock(x + r - 4, y + h, z - r + i, Blocks.field_150350_a);
                }
            }
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x + r2 + 1, y + 7 + 1, z + r2, ForgeDirection.EAST, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x + r2 + 2, y + 7 + 1, z + r2 + 1, ForgeDirection.NORTH, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x + r2, y + 7 + 1, z + r2 + 1, ForgeDirection.SOUTH, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x + r2 + 1, y + 7 + 1, z + r2 + 2, ForgeDirection.WEST, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x - r2 - 1, y + 7 + 1, z + r2, ForgeDirection.WEST, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x - r2 - 2, y + 7 + 1, z + r2 + 1, ForgeDirection.NORTH, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x - r2, y + 7 + 1, z + r2 + 1, ForgeDirection.SOUTH, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x - r2 - 1, y + 7 + 1, z + r2 + 2, ForgeDirection.EAST, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x + r2 + 1, y + 7 + 1, z - r2, ForgeDirection.EAST, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x + r2 + 2, y + 7 + 1, z - r2 - 1, ForgeDirection.SOUTH, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x + r2, y + 7 + 1, z - r2 - 1, ForgeDirection.NORTH, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x + r2 + 1, y + 7 + 1, z - r2 - 2, ForgeDirection.WEST, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x - r2 - 1, y + 7 + 1, z - r2, ForgeDirection.WEST, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x - r2 - 2, y + 7 + 1, z - r2 - 1, ForgeDirection.SOUTH, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x - r2, y + 7 + 1, z - r2 - 1, ForgeDirection.NORTH, "dungeonChest", 0, new Object[0]);
            ((WaterPuzzleGenerator)this.parent).generateLootChest(x - r2 - 1, y + 7 + 1, z - r2 - 2, ForgeDirection.EAST, "dungeonChest", 0, new Object[0]);
        }
        for (int i = 0; i < this.flowGrid.length; ++i) {
            for (k = 0; k < this.flowGrid[i].length; ++k) {
                Lock l = this.flowGrid[i][k];
                world.setTileEntity(l.centerLocation.xCoord, l.centerLocation.yCoord, l.centerLocation.zCoord, ChromaBlocks.WATERLOCK.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new LockCallback(((WaterPuzzleGenerator)this.parent).id, this.level, i - r0, k - r0, l.facing, this.checkpoints.contains(l), this.path.endsAt(l.location), l.openEnds));
                for (int n = 2; n < 6; ++n) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[n];
                    for (int d = 0; d <= 2; ++d) {
                        int dx = l.centerLocation.xCoord + d * dir.offsetX;
                        int dz = l.centerLocation.zCoord + d * dir.offsetZ;
                        if (!l.isDirectionOpen(dir)) continue;
                        world.setBlock(dx, y + 2, dz, Blocks.field_150350_a);
                    }
                    world.setBlock(l.centerLocation.xCoord + 3 * dir.offsetX, y + 2, l.centerLocation.zCoord + 3 * dir.offsetZ, Blocks.field_150350_a);
                }
            }
        }
        int lx = x + this.path.startLoc.x * 6;
        int lz = z + this.path.startLoc.y * 6;
        for (int i = 0; i <= 4; ++i) {
            world.setBlock(lx, y + 7 + i, lz, Blocks.field_150350_a);
        }
    }

    public boolean hasBeenSolved() {
        for (Lock l : this.checkpoints) {
            if (l.hasFluid) continue;
            return false;
        }
        return true;
    }

    public void rotateLock(int i, int k, boolean ccw) {
        this.getLock(i, k).rotate(true, ccw);
    }

    public Lock getLock(int i, int k) {
        int r0 = (this.gridSize - 1) / 2;
        return this.flowGrid[i + r0][k + r0];
    }

    public void updateFluid(World world, int i, int k, boolean fluid) {
        boolean flag = this.hasBeenSolved();
        this.getLock((int)i, (int)k).hasFluid = fluid;
        boolean flag2 = this.hasBeenSolved();
        if (flag != flag2) {
            if (flag2) {
                ChromaSounds.CASTHARMONIC.playSoundNoAttenuation(world, this.origin.xCoord, this.origin.yCoord, this.origin.zCoord, 0.4f, 2.0f, 512);
            }
            this.setDoorStates(world, flag2);
        }
    }

    public void setDoorStates(World world, boolean open) {
        for (Coordinate c : this.doorCoordinates) {
            if (open) {
                ((BlockChromaDoor.TileEntityChromaDoor)c.getTileEntity((IBlockAccess)world)).open(-1);
                continue;
            }
            ((BlockChromaDoor.TileEntityChromaDoor)c.getTileEntity((IBlockAccess)world)).close();
        }
    }

    public Point getStartLocation() {
        return this.path.startLoc;
    }

    private static class LockCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID uid;
        private final int level;
        private final ForgeDirection direction;
        private final int lockX;
        private final int lockY;
        private final Collection<ForgeDirection> ends;
        private final boolean isCheckpoint;
        private final boolean isEndpoint;

        private LockCallback(UUID id, int lvl, int lx, int ly, ForgeDirection dir, boolean check, boolean end, Collection<ForgeDirection> c) {
            this.uid = id;
            this.level = lvl;
            this.lockX = lx;
            this.lockY = ly;
            this.direction = dir;
            this.ends = c;
            this.isCheckpoint = check;
            this.isEndpoint = end;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof BlockRotatingLock.TileEntityRotatingLock) {
                ((BlockRotatingLock.TileEntityRotatingLock)te).setData(this.direction, this.level, this.lockX, this.lockY, this.isCheckpoint, this.isEndpoint, this.ends);
                ((BlockRotatingLock.TileEntityRotatingLock)te).uid = this.uid;
            }
        }
    }
}

