/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Block.Dimension.Structure.Water.BlockEverFluid;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.Dimension.Structure.Water.WaterFloor;
import Reika.ChromatiCraft.World.Dimension.Structure.Water.WaterLoot;
import Reika.ChromatiCraft.World.Dimension.Structure.Water.WaterPath;
import Reika.ChromatiCraft.World.Dimension.Structure.Water.WaterStructureEntrance;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class WaterPuzzleGenerator
extends DimensionStructureGenerator {
    private final ArrayList<WaterFloor> levels = new ArrayList();

    @Override
    protected void calculate(int chunkX, int chunkZ, Random rand) {
        int i;
        int y;
        this.posX = chunkX;
        this.posZ = chunkZ;
        this.posY = 10 + rand.nextInt(10);
        int n = this.getSize();
        int r = this.getRadius(0);
        int startx = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r);
        int startz = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r);
        while (startx == 0 && startz == 0) {
            startx = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r);
            startz = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            r = this.getRadius(i2);
            int endx = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r);
            int endz = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r);
            while (endx == startx && endz == startz) {
                endx = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r);
                endz = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r);
            }
            WaterPath path = new WaterPath(startx, startz, endx, endz, r);
            path.genPath(rand);
            WaterFloor w = new WaterFloor(this, i2, r, path, rand);
            this.levels.add(w);
            startx = endx;
            startz = endz;
        }
        int ty = 11;
        int topY = y = this.posY + this.levels.size() * ty;
        for (WaterFloor l : this.levels) {
            l.generate(this.world, this.posX, y, this.posZ);
            y -= ty;
        }
        y += ty;
        WaterFloor f = this.levels.get(this.levels.size() - 1);
        r = f.getWidth() - 2;
        boolean flag = true;
        for (i = 0; i < 4; ++i) {
            boolean flag2 = i == 3 || rand.nextInt(4) == 0;
            int dx = this.posX + i % 2 * r * 2 - r;
            int dz = this.posZ + i / 2 * r * 2 - r;
            new WaterLoot(this, flag && flag2).generate(this.world, dx, y, dz);
            if (!flag2) continue;
            flag = false;
        }
        this.posY = y = topY;
        f = this.levels.get(0);
        r = f.getWidth();
        for (i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                for (int h = 1; h <= 5; ++h) {
                    int dx = this.posX + i;
                    int dz = this.posZ + k;
                    int dy = y + 7 + h;
                    if (Math.abs(i) == r || Math.abs(k) == r || h == 5) {
                        this.world.setBlock(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (Math.abs(i) + Math.abs(k)) % 6 == 0 ? BlockStructureShield.BlockType.LIGHT.metadata : BlockStructureShield.BlockType.STONE.metadata);
                        continue;
                    }
                    this.world.setBlock(dx, dy, dz, Blocks.field_150350_a);
                }
            }
        }
        Point p = f.getStartLocation();
        int dx = this.posX + p.x * 6;
        int dz = this.posZ + p.y * 6;
        for (int i3 = 0; i3 <= 4; ++i3) {
            this.world.setBlock(dx, y + 7 + i3, dz, Blocks.field_150350_a);
            if (i3 <= 0) continue;
            this.world.setBlock(dx + 1, y + 7 + i3, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.GLASS.metadata);
            this.world.setBlock(dx - 1, y + 7 + i3, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.GLASS.metadata);
            this.world.setBlock(dx, y + 7 + i3, dz + 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.GLASS.metadata);
            this.world.setBlock(dx, y + 7 + i3, dz - 1, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.GLASS.metadata);
        }
        this.world.setTileEntity(dx, y + 7 + 4, dz, ChromaBlocks.EVERFLUID.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new EverFluidCallback(this.id, 0));
        y = this.posY + 7;
        this.generatePasswordTile(this.posX, y, this.posZ);
        this.addDynamicStructure(new WaterStructureEntrance(this), this.posX, this.posZ);
    }

    private int getRadius(int i) {
        return 2 + i;
    }

    private static int getSize() {
        switch (ChromaOptions.getStructureDifficulty()) {
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
        }
        return 6;
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    public boolean hasBeenSolved(World world) {
        for (WaterFloor f : this.levels) {
            if (f.hasBeenSolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void openStructure(World world) {
        for (WaterFloor f : this.levels) {
            f.setDoorStates(world, true);
        }
    }

    @Override
    protected void clearCaches() {
        this.levels.clear();
    }

    public WaterFloor getLevel(int i) {
        return this.levels.isEmpty() ? null : this.levels.get(i);
    }

    public int levelCount() {
        return this.levels.size();
    }

    private static class EverFluidCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID uid;
        private final int level;

        private EverFluidCallback(UUID id, int lvl) {
            this.uid = id;
            this.level = lvl;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof BlockEverFluid.TileEntityEverFluid) {
                BlockEverFluid.placeSource(world, x, y, z);
                ((BlockEverFluid.TileEntityEverFluid)te).setData(this.uid, this.level);
            }
        }
    }
}

