/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Terrain;

import Reika.ChromatiCraft.Base.ChromaDimensionBiomeTerrainShaper;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.DragonAPI.Instantiable.Math.Noise.SimplexNoiseGenerator;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class TerrainGenCrystalMountain
extends ChromaDimensionBiomeTerrainShaper {
    private final SimplexNoiseGenerator mountainHeight;
    private final SimplexNoiseGenerator shearNoise;
    private final SimplexNoiseGenerator threshNoise;
    private final SimplexNoiseGenerator gemNoise;
    private final SimplexNoiseGenerator dirtNoise;
    public static final double MAX_AMPLITUDE = 80.0;
    public static final double MIN_SHEAR = 0.0;
    public static final double MAX_SHEAR = 45.0;
    public static final double MIN_THRESH = 4.0;
    public static final double MAX_THRESH = 24.0;
    public static final int BIOME_SEARCH = 24;

    public TerrainGenCrystalMountain(long seed) {
        super(seed, ChromaDimensionManager.SubBiomes.MOUNTAINS);
        this.mountainHeight = new SimplexNoiseGenerator(seed);
        this.shearNoise = new SimplexNoiseGenerator(seed ^ -seed);
        this.threshNoise = new SimplexNoiseGenerator(seed ^ -seed ^ 0xFFFFFFFFFFFFFFFFL);
        this.gemNoise = new SimplexNoiseGenerator(-seed);
        this.dirtNoise = new SimplexNoiseGenerator(-seed ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void generateColumn(World world, int chunkX, int chunkZ, int i, int k, int surface, Random rand, double edgeFactor) {
        HeightData dat;
        double innerScale = 0.0625;
        double mainScale = 0.25;
        int dx = chunkX + i;
        int dz = chunkZ + k;
        double rx = this.calcR(chunkX, i, innerScale, mainScale);
        double rz = this.calcR(chunkZ, k, innerScale, mainScale);
        int dt = (int)ReikaMathLibrary.normalizeToBounds((double)this.dirtNoise.getValue(rx * 8.0, rz * 8.0), (double)0.0, (double)4.0);
        HeightData heightData = dat = this.calcHeight(rx, rz);
        heightData.maxHeight = heightData.maxHeight * edgeFactor;
        dat.isCliff = this.isCliff(chunkX, chunkZ, i, k, rx, rz, innerScale, mainScale);
        double g1 = 0.0;
        double g2 = 0.0;
        if (dat.isCliff) {
            double dc = dat.maxHeight - (double)dt - dat.shearThreshold;
            double gt = 0.75;
            double gw = ReikaMathLibrary.normalizeToBounds((double)this.gemNoise.getValue(rx * 2.0, rz * 2.0), (double)0.0, (double)(dc * gt));
            double base = this.isFlatWorld(world) ? 3.0 : 104.0;
            double mid = base + dat.shearThreshold + dc / 2.0;
            g1 = mid - gw / 2.0;
            g2 = mid + gw / 2.0;
        }
        double gmax = Math.max(g1, g2);
        double gmin = Math.min(g1, g2);
        int h = (int)dat.maxHeight;
        int my = 103;
        if (this.isFlatWorld(world)) {
            my = 3;
        }
        for (int y = 0; y < my; ++y) {
            world.func_147465_d(dx, y, dz, Blocks.field_150348_b, 0, 2);
        }
        for (int j = 0; j <= h; ++j) {
            int dy = my + j;
            int m = 0;
            Block b = Blocks.field_150348_b;
            if (j == h) {
                b = Blocks.field_150349_c;
            } else if (h - j <= dt) {
                b = Blocks.field_150346_d;
            } else if (dat.isCliff && (int)(gmax - gmin) > 1 && ReikaMathLibrary.isValueInsideBoundsIncl((double)gmin, (double)gmax, (double)dy)) {
                b = ChromaBlocks.DIMGEN.getBlockInstance();
                m = BlockDimensionDeco.DimDecoTypes.GEMSTONE.ordinal();
            }
            world.func_147465_d(dx, dy, dz, b, m, 2);
        }
    }

    private HeightData calcHeight(double rx, double rz) {
        double voff = 0.6;
        double val = Math.max(0.0, (voff + this.mountainHeight.getValue(rx, rz)) * 35.0 / (1.0 + voff));
        double shear = ReikaMathLibrary.normalizeToBounds((double)this.shearNoise.getValue(rx, rz), (double)0.0, (double)45.0);
        double shearThresh = ReikaMathLibrary.normalizeToBounds((double)this.threshNoise.getValue(rx, rz), (double)4.0, (double)24.0);
        if (val >= shearThresh) {
            val += shear;
        }
        return new HeightData(val, shear, shearThresh);
    }

    private boolean isCliff(int cx, int cz, int i, int k, double rx, double rz, double innerScale, double mainScale) {
        double h = this.calcHeight(rx, rz).maxHeight;
        double rxp = rx + innerScale * mainScale;
        double rxn = rx - innerScale * mainScale;
        double rzp = rz + innerScale * mainScale;
        double rzn = rz - innerScale * mainScale;
        double hpx = this.calcHeight(rxp, rz).maxHeight;
        double hnx = this.calcHeight(rxn, rz).maxHeight;
        double hpz = this.calcHeight(rx, rzp).maxHeight;
        double hnz = this.calcHeight(rx, rzn).maxHeight;
        return Math.abs(h - hpx) > 4.0 || Math.abs(h - hpz) > 4.0 || Math.abs(h - hnx) > 4.0 || Math.abs(h - hnz) > 4.0;
    }

    @Override
    public double getBiomeSearchDistance() {
        return 24.0;
    }

    private static class HeightData {
        private double maxHeight;
        private final double shearHeight;
        private final double shearThreshold;
        private boolean isCliff;

        private HeightData(double h, double s, double t) {
            this.maxHeight = h;
            this.shearHeight = s;
            this.shearThreshold = t;
        }
    }
}

