/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Terrain;

import Reika.ChromatiCraft.Base.ChromaDimensionBiomeTerrainShaper;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.DragonAPI.Instantiable.Math.Noise.NoiseGeneratorBase;
import Reika.DragonAPI.Instantiable.Math.Noise.SimplexNoiseGenerator;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TerrainGenGlowingCracks
extends ChromaDimensionBiomeTerrainShaper {
    private final NoiseGeneratorBase shieldingThickness;
    private final NoiseGeneratorBase shieldingDarkThickness;
    public static final int CRACK_DEPTH = 12;
    private static final int MIN_SHIELD_THICKNESS = 2;
    private static final int MAX_SHIELD_THICKNESS = 10;
    public static final int BIOME_SEARCH = 24;
    private final HashSet<Point> crackShape = new HashSet();

    public TerrainGenGlowingCracks(long seed) {
        super(seed, ChromaDimensionManager.Biomes.GLOWCRACKS);
        this.shieldingThickness = new SimplexNoiseGenerator(seed * 2L).setFrequency(4.0);
        this.shieldingDarkThickness = new SimplexNoiseGenerator(-seed * 2L).setFrequency(4.0);
        try (InputStream in = ChromatiCraft.class.getResourceAsStream("Textures/cracks.png");){
            BufferedImage img = ImageIO.read(in);
            for (int x = 0; x < 1500; ++x) {
                for (int z = 0; z < 1500; ++z) {
                    int rgb = img.getRGB(x, z) & 0xFFFFFF;
                    if (rgb != 0) continue;
                    this.crackShape.add(new Point(x, z));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void generateColumn(World world, int chunkX, int chunkZ, int i, int k, int surface, Random rand, double edgeFactor) {
        double innerScale = 0.0625;
        double mainScale = 0.6666666666666666;
        int dx = chunkX + i;
        int dz = chunkZ + k;
        boolean dt = true;
        double rx = this.calcR(chunkX, i, innerScale, mainScale);
        double rz = this.calcR(chunkZ, k, innerScale, mainScale);
        if (this.crackShape.contains(new Point((dx % 1500 + 1500) % 1500, (dz % 1500 + 1500) % 1500))) {
            int space = 30;
            int y = 104 + space;
            int m = 12 + space;
            int st = (int)ReikaMathLibrary.normalizeToBounds((double)this.shieldingThickness.getValue(rx, rz), (double)2.0, (double)Math.min(m - 2, 10));
            int shield = m - st;
            int dark = m - (int)ReikaMathLibrary.normalizeToBounds((double)this.shieldingDarkThickness.getValue(rx, rz), (double)1.0, (double)st);
            for (int j = 0; j <= m; ++j) {
                int dy = y - j;
                this.cutBlock(world, dx, dy, dz);
                if (j < shield && (j <= 1 || j >= shield || rand.nextInt(Math.max(2, shield - j)) > 1)) continue;
                for (int d = 2; d < 6; ++d) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[d];
                    int ddx = dx + dir.offsetX;
                    int ddz = dz + dir.offsetZ;
                    Block at = world.func_147439_a(ddx, dy, ddz);
                    if (at != Blocks.field_150348_b && at != ChromaBlocks.TIEREDORE.getBlockInstance()) continue;
                    world.func_147465_d(ddx, dy, ddz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), j >= dark ? BlockStructureShield.BlockType.CLOAK.ordinal() : BlockStructureShield.BlockType.STONE.ordinal(), 2);
                }
            }
            for (int d = 0; d < 6; ++d) {
                world.func_147449_b(dx, y - space - 12 - 1 - d, dz, ChromatiCraft.lumen.getBlock());
            }
        } else {
            for (int y = 94; y <= 114; ++y) {
                if (world.func_147439_a(dx, y, dz) != Blocks.field_150355_j && world.func_147439_a(dx, y, dz) != Blocks.field_150358_i) continue;
                world.func_147449_b(dx, y, dz, (Block)Blocks.field_150354_m);
            }
        }
    }

    @Override
    public double getBiomeSearchDistance() {
        return 24.0;
    }
}

